/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.gui.screen.ColorSelectScreen;
import fi.dy.masa.malilib.gui.screen.util.HSV;
import java.awt.Color;

public class RGB {
    private final float r;
    private final float g;
    private final float b;

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    private RGB(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static RGB ofFFF(float r, float g, float b) {
        return new RGB(r, g, b);
    }

    public static RGB ofIII(int r, int g, int b) {
        return new RGB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static RGB ofARGB(int argb) {
        return RGB.ofIII(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public int toColor() {
        return this.toColor(255);
    }

    public int toColor(int a) {
        int[] array = this.standardize();
        return ColorSelectScreen.encodeARGB(a, array[0], array[1], array[2]);
    }

    public int[] standardize() {
        return new int[]{(int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f)};
    }

    public HSV toHSV() {
        int[] ints = this.standardize();
        float[] floats = Color.RGBtoHSB(ints[0], ints[1], ints[2], null);
        return HSV.ofFArray(floats);
    }
}

