/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.gui.screen.util.RGB;
import java.awt.Color;

public class HSV {
    private final int h;
    private final float s;
    private final float v;

    public int getH() {
        return this.h;
    }

    public float getS() {
        return this.s;
    }

    public float getV() {
        return this.v;
    }

    private HSV(int h, float s, float v) {
        this.h = h;
        this.s = s;
        this.v = v;
    }

    public static HSV ofIFF(int h, float s, float v) {
        return new HSV(h, s, v);
    }

    public static HSV ofIII(int h, int s, int v) {
        return new HSV(h, (float)s / 100.0f, (float)v / 100.0f);
    }

    public static HSV ofFFF(float h, float s, float v) {
        return new HSV((int)(h * 359.0f), s, v);
    }

    public static HSV ofIFI(int h, float s, int v) {
        return new HSV(h, s, (float)v / 100.0f);
    }

    public static HSV ofIIF(int h, int s, float v) {
        return new HSV(h, (float)s / 100.0f, v);
    }

    public static HSV ofFArray(float[] array) {
        return HSV.ofFFF(array[0], array[1], array[2]);
    }

    public static HSV ofARGB(int argb) {
        return RGB.ofARGB(argb).toHSV();
    }

    public int[] standardize() {
        return new int[]{this.h, (int)(this.s * 100.0f), (int)(this.v * 100.0f)};
    }

    public int toColor() {
        return Color.HSBtoRGB((float)this.h / 359.0f, this.s, this.v);
    }

    public int toColor(int a) {
        return this.toColor() << 8 >>> 8 | a << 24;
    }

    public RGB toRGB() {
        return RGB.ofARGB(Color.HSBtoRGB((float)this.h / 359.0f, this.s, this.v));
    }
}

