/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.screen.StringListEditScreen;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import net.minecraft.GuiScreen;

class ConfigItemStringList
extends ConfigItem<ConfigStringList> {
    final ButtonBase editButton;

    public ConfigItemStringList(int index, ConfigStringList config, GuiScreen screen) {
        super(index, config, screen);
        this.editButton = ScreenConstants.getCommonButton(index, this.getStringPreview(), screen, button -> screen.mc.displayGuiScreen((GuiScreen)new StringListEditScreen(config, screen)));
        this.buttons.add(this.editButton);
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, DrawContext drawContext) {
        super.postRenderHovered(mouseX, mouseY, selected, drawContext);
        if (this.editButton.isMouseOver()) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(StringUtils.translate("manyLib.gui.comment.clickToEditStringList"));
            strings.addAll(((ConfigStringList)this.config).getStringListValue());
            RenderUtils.drawTextList(strings, mouseX, mouseY, drawContext);
        }
    }

    private String getStringPreview() {
        String raw = ((ConfigStringList)this.config).getDisplayText();
        return raw.length() > 24 ? raw.substring(0, 20) + ",...]" : raw;
    }

    @Override
    public void resetButtonClicked() {
        this.editButton.setDisplayString(this.getStringPreview());
    }
}

