/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.screen.KeySettingsScreen;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.GuiScreen;

class ConfigItemHotkey
extends ConfigItem<ConfigHotkey> {
    ButtonBase hotkeyButton;
    ButtonBase keybindSettingsButton;
    protected final List<String> overlapInfo = new ArrayList<String>();
    boolean editing;
    IKeybind keybind;

    public ConfigItemHotkey(int index, ConfigHotkey config, GuiScreen screen) {
        super(index, config, screen);
        this.keybind = config.getKeybind();
        this.addHotKeyButton(index);
        this.addKeybindSettingsButton(index);
    }

    private void addKeybindSettingsButton(int index) {
        this.keybindSettingsButton = ScreenConstants.getJumpButton(index, this.screen, button -> this.screen.mc.displayGuiScreen((GuiScreen)new KeySettingsScreen(this.screen, ((ConfigHotkey)this.config).getConfigGuiDisplayName(), this.keybind)));
        this.buttons.add(this.keybindSettingsButton);
    }

    protected void addHotKeyButton(int index) {
        this.hotkeyButton = ScreenConstants.getHotkeyButton(index, (ConfigHotkey)this.config, this.screen, button -> {
            this.editing = true;
            this.keybind.clearKeys();
        });
        this.hotkeyButton.setHoverInfoRequiresShift(true);
        this.buttons.add(this.hotkeyButton);
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, DrawContext drawContext) {
        this.updateDisplayStringByKeybind();
        super.render(mouseX, mouseY, selected, drawContext);
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, DrawContext drawContext) {
        super.postRenderHovered(mouseX, mouseY, selected, drawContext);
        if (this.hotkeyButton.isMouseOver() && this.hotkeyButton.hasHoverText()) {
            RenderUtils.drawHoverText(mouseX, mouseY, this.hotkeyButton.getHoverStrings(), drawContext);
        }
        this.hotkeyButton.postRenderHovered(mouseX, mouseY, selected, drawContext);
        if (this.keybindSettingsButton.isMouseOver()) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(StringUtils.translate("manyLib.keybind.settings") + ":");
            strings.addAll(this.keybind.getSettings().toStringList());
            RenderUtils.drawTextList(strings, mouseX, mouseY, drawContext);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.editing && !this.hotkeyButton.isMouseOver()) {
            this.editing = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (!this.editing) {
            return false;
        }
        if (modifiers == 1 || modifiers == 28 || modifiers == 156) {
            this.editing = false;
            return true;
        }
        this.keybind.addKey(modifiers);
        return true;
    }

    @Override
    protected void onMouseReleasedImpl(int mouseX, int mouseY, int mouseButton) {
        super.onMouseReleasedImpl(mouseX, mouseY, mouseButton);
        if (!this.hotkeyButton.isMouseOver()) {
            this.editing = false;
        }
    }

    private void updateDisplayStringByKeybind() {
        this.updateConflicts();
        Object string = this.keybind.getKeysDisplayString();
        if (((String)string).isEmpty()) {
            string = "NONE";
        }
        if (this.editing) {
            string = GuiBase.TXT_YELLOW + "> " + (String)string + " <";
        } else if (!this.overlapInfo.isEmpty()) {
            string = GuiBase.TXT_GOLD + (String)string;
        }
        this.hotkeyButton.setDisplayString((String)string);
    }

    protected void updateConflicts() {
        List<KeybindCategory> categories = InputEventHandler.getKeybindManager().getKeybindCategories();
        ArrayList<IHotkey> overlaps = new ArrayList<IHotkey>();
        this.overlapInfo.clear();
        for (KeybindCategory category : categories) {
            List<? extends IHotkey> hotkeys = category.getHotkeys();
            for (IHotkey iHotkey : hotkeys) {
                if (!this.keybind.overlaps(iHotkey.getKeybind())) continue;
                overlaps.add(iHotkey);
            }
            if (overlaps.size() <= 0) continue;
            if (this.overlapInfo.size() > 0) {
                this.overlapInfo.add("-----");
            }
            this.overlapInfo.add(category.getModName());
            this.overlapInfo.add(" > " + category.getCategory());
            for (IHotkey iHotkey : overlaps) {
                String key = " [ " + GuiBase.TXT_GOLD + iHotkey.getKeybind().getKeysDisplayString() + GuiBase.TXT_RST + " ]";
                this.overlapInfo.add("    - " + iHotkey.getConfigGuiDisplayName() + key);
            }
            overlaps.clear();
        }
        this.hotkeyButton.setHoverStrings(this.overlapInfo);
    }
}

