/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.interfaces;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.screen.interfaces.ScreenWithPages;
import net.minecraft.GuiScreen;

public abstract class ScreenPaged
extends GuiBase
implements ScreenWithPages {
    protected final int rows;
    protected int columns;
    protected int pageCapacity;
    protected int pageIndex;
    protected int maxPageIndex;

    public ScreenPaged(GuiScreen parent, int rows, int columns) {
        this(parent, rows, columns, 1);
    }

    public ScreenPaged(GuiScreen parent, int rows, int columns, int configSize) {
        this.setParent(parent);
        this.rows = rows;
        this.columns = columns;
        this.pageCapacity = rows * columns;
        this.updatePageCount(configSize);
    }

    protected void updatePageCount(int configSize) {
        this.maxPageIndex = (configSize - 1) / this.pageCapacity;
    }

    protected int getLeftBorder() {
        return this.width / 2 - 155;
    }

    protected int getButtonPosX(int index) {
        return this.getLeftBorder() + (index %= this.pageCapacity) % this.columns * 160;
    }

    protected int getButtonPosY(int index) {
        return this.height / 6 + 24 * ((index %= this.pageCapacity) / this.columns) - 6;
    }

    @Override
    protected void tickScreen() {
        super.tickScreen();
        this.wheelListener();
    }

    @Override
    public boolean isVisible(int index) {
        return index >= this.pageIndex * this.pageCapacity && index < (this.pageIndex + 1) * this.pageCapacity;
    }

    @Override
    public void scroll(boolean isPageDown) {
        if (this.maxPageIndex == 0) {
            return;
        }
        if (isPageDown && this.canPageDown()) {
            ++this.pageIndex;
        }
        if (!isPageDown && this.canPageUp()) {
            --this.pageIndex;
        }
        this.setVisibilities();
    }

    protected boolean canPageUp() {
        return this.pageIndex > 0;
    }

    protected boolean canPageDown() {
        return this.pageIndex < this.maxPageIndex;
    }
}

