/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.feat.SortCategory;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.SearchField;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonPeriodic;
import fi.dy.masa.malilib.gui.screen.ListScreen;
import fi.dy.masa.malilib.gui.screen.interfaces.Searchable;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.gui.screen.util.WidthAdder;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.GuiScreen;
import org.lwjgl.input.Keyboard;

public class GlobalSearchScreen
extends ListScreen<ConfigItem<?>>
implements Searchable {
    private final List<SearchResult> searchResultsCache = new ArrayList<SearchResult>();
    private final List<SearchResult> searchResults = new ArrayList<SearchResult>();

    public GlobalSearchScreen(GuiScreen parentScreen) {
        this.setParent(parentScreen);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.setTitle(StringUtils.translate("manyLib.gui.title.globalSearching"));
        WidthAdder widthAdder = new WidthAdder(200);
        ConfigEnum<SortCategory> sortCategoryConfigEnum = new ConfigEnum<SortCategory>("manyLib.sortCategory", SortCategory.Default);
        this.addButton(ScreenConstants.getSortButton(this, widthAdder, 10, sortCategoryConfigEnum, button -> {
            ((IButtonPeriodic)((Object)button)).next();
            this.sort((SortCategory)((Object)((Object)sortCategoryConfigEnum.getEnumValue())));
        }));
        SearchField searchField = ScreenConstants.getSearchButton(this);
        searchField.initialSearch();
        this.addWidget(searchField);
        this.onStatusChange();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    protected ConfigItem<?> createEntry(int realIndex, int relativeIndex) {
        SearchResult searchResult = this.searchResults.get(realIndex);
        ConfigItem<?> configItem = ConfigItem.getConfigItem(relativeIndex, searchResult.configBase(), this);
        configItem.addTooltip(GuiBase.TXT_AQUA + "<" + searchResult.mod() + ">", true);
        return configItem;
    }

    @Override
    public int getMaxCapacity() {
        return 8;
    }

    @Override
    public int getContentSize() {
        return this.searchResults.size();
    }

    @Override
    public void updateSearchResult(String input) {
        this.searchResultsCache.clear();
        ConfigManager.getInstance().getConfigMap().values().stream().sorted(Comparator.comparing(IConfigHandler::getName)).flatMap(iConfigHandler -> Stream.concat(iConfigHandler.getValues().stream(), iConfigHandler.getHotkeys().stream()).map(configBase -> new SearchResult(iConfigHandler.getName(), (ConfigBase<?>)configBase))).filter(x -> ConfigItem.supported(x.configBase())).filter(x -> this.matchResult((SearchResult)x, input)).forEach(this.searchResultsCache::add);
        this.searchResults.clear();
        this.searchResults.addAll(this.searchResultsCache);
        this.onContentChange();
    }

    private boolean matchResult(SearchResult searchResult, String input) {
        if (input.isEmpty()) {
            return true;
        }
        String configGuiDisplayName = searchResult.configBase().getConfigGuiDisplayName();
        if (configGuiDisplayName != null && StringUtils.stringMatchesInput(configGuiDisplayName, input)) {
            return true;
        }
        String configGuiDisplayComment = searchResult.configBase().getConfigGuiDisplayComment();
        return configGuiDisplayComment != null && StringUtils.stringMatchesInput(configGuiDisplayComment, input);
    }

    void sort(SortCategory sortCategory) {
        if (sortCategory == SortCategory.Default) {
            this.searchResults.clear();
            this.searchResults.addAll(this.searchResultsCache);
        } else {
            this.searchResults.sort((x, y) -> sortCategory.category.compare(x.configBase(), y.configBase()));
        }
        this.resetStatus();
        this.markShouldUpdateEntries();
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
        ConfigManager.getInstance().saveAllConfigs();
    }

    private record SearchResult(String mod, ConfigBase<?> configBase) {
    }
}

