/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen;

import fi.dy.masa.malilib.ManyLibConfig;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.gui.ManyLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.screen.interfaces.IMenu;
import fi.dy.masa.malilib.gui.screen.interfaces.ScreenPaged;
import fi.dy.masa.malilib.gui.widgets.WidgetText;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.GuiScreen;

public class FakeModMenu
extends ScreenPaged
implements IMenu {
    private final List<IConfigHandler> configs = ConfigManager.getInstance().getConfigMap().values().stream().toList();
    private ButtonGeneric pageUp;
    private ButtonGeneric pageDown;

    public FakeModMenu(GuiScreen parent) {
        super(parent, 6, 2);
        this.updatePageCount(this.configs.size());
    }

    @Override
    public void initGui() {
        ButtonGeneric pageDown;
        ButtonGeneric pageUp;
        super.initGui();
        for (int i = 0; i < this.configs.size(); ++i) {
            IConfigHandler configHandler = this.configs.get(i);
            int finalI = i;
            String name = configHandler.getName();
            this.addButton(this.getButton(this.getButtonPosX(i), this.getButtonPosY(i), StringUtils.getTranslatedOrFallback("config.menu.name." + name, name), configHandler.getMenuComment(), button -> {
                IConfigHandler simpleConfigs = this.configs.get(finalI);
                this.mc.displayGuiScreen(simpleConfigs.getConfigScreen(this));
            }));
        }
        this.addWidget(WidgetText.of(String.valueOf(ManyLibConfig.TitleFormat.getEnumValue()) + StringUtils.translate("manyLib.gui.title.options")).position(this.width / 2, 20).centered());
        this.addWidget(ButtonGeneric.builder(StringUtils.translate("gui.done"), button -> this.mc.displayGuiScreen(this.getParent())).dimensions(this.width / 2 - 100, this.height / 6 + 168, 200, 20).build());
        this.pageUp = pageUp = ButtonGeneric.builder(ManyLibIcons.PageUpButton, button -> this.scroll(false)).dimensions(this.width / 2 + 132, this.height / 6 + 168, 20, 20).hoverStrings(StringUtils.translate("manyLib.gui.button.pageUp")).build();
        this.addWidget(pageUp);
        this.pageDown = pageDown = ButtonGeneric.builder(ManyLibIcons.PageDownButton, button -> this.scroll(true)).dimensions(this.width / 2 + 154, this.height / 6 + 168, 20, 20).hoverStrings(StringUtils.translate("manyLib.gui.button.pageDown")).build();
        this.addWidget(pageDown);
        this.setVisibilities();
    }

    @Override
    public void setVisibilities() {
        for (int i = 0; i < this.configs.size(); ++i) {
            ((ButtonBase)((Object)this.buttons.get(i))).setVisible(this.isVisible(i));
        }
        this.pageUp.setEnabled(this.canPageUp());
        this.pageDown.setEnabled(this.canPageDown());
    }
}

