/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen;

import fi.dy.masa.malilib.config.ConfigTab;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.interfaces.IConfigResettable;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.feat.ProgressSaving;
import fi.dy.masa.malilib.feat.SortCategory;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.PullDownButton;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonPeriodic;
import fi.dy.masa.malilib.gui.screen.GlobalSearchScreen;
import fi.dy.masa.malilib.gui.screen.ListScreen;
import fi.dy.masa.malilib.gui.screen.interfaces.AboutInputMethod;
import fi.dy.masa.malilib.gui.screen.interfaces.Searchable;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.DropDownEntry;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.gui.screen.util.WidthAdder;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.GuiScreen;
import net.minecraft.GuiYesNoMITE;
import org.lwjgl.input.Keyboard;

public class DefaultConfigScreen
extends ListScreen<ConfigItem<?>>
implements Searchable {
    public final IConfigHandler configInstance;
    public ConfigTab currentTab;
    public int currentTabIndex;
    public boolean needSyncTab;
    private boolean firstSeen = true;
    private final List<ConfigTab> configTabs;
    private long lastShift = 0L;

    public DefaultConfigScreen(GuiScreen parentScreen, IConfigHandler configInstance) {
        this.setParent(parentScreen);
        this.useTitleHierarchy = false;
        this.configInstance = configInstance;
        this.configTabs = configInstance.getConfigTabs();
        this.setTitle(this.createTitle());
    }

    @Override
    public void initGui() {
        super.initGui();
        this.initElements();
        this.setCurrentTab(this.firstSeen ? ProgressSaving.getPage(this.configInstance.getName()) : this.currentTabIndex);
        this.needSyncTab = false;
        this.onContentChange();
        if (this.firstSeen) {
            this.firstSeen = false;
            this.setStatus(ProgressSaving.getStatus(this.configInstance.getName()));
        }
        this.onStatusChange();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected void initElements() {
        WidthAdder widthAdder = new WidthAdder(20);
        this.addTabButtons(widthAdder);
        String configInstanceName = this.configInstance.getName();
        this.addButton(ScreenConstants.getResetAllButton(widthAdder, () -> this.currentTab.getAllConfigs().stream().anyMatch(IConfigResettable::isModified), button -> {
            String question = StringUtils.translate("manyLib.gui.reset_tab_question");
            String yes = StringUtils.translate("gui.yes");
            String no = StringUtils.translate("gui.no");
            GuiYesNoMITE var3 = new GuiYesNoMITE((GuiScreen)this, question, configInstanceName + ": " + this.currentTab.getGuiDisplayName(), yes, no, 0);
            this.mc.displayGuiScreen((GuiScreen)var3);
        }));
        ConfigEnum<SortCategory> sortCategoryConfigEnum = new ConfigEnum<SortCategory>("manyLib.sortCategory", SortCategory.Default);
        this.addButton(ScreenConstants.getSortButton(this, widthAdder, 30, sortCategoryConfigEnum, button -> {
            ((IButtonPeriodic)((Object)button)).next();
            this.sort((SortCategory)((Object)((Object)sortCategoryConfigEnum.getEnumValue())));
        }));
        this.addWidget(ScreenConstants.getSearchButton(this));
        PullDownButton<DropDownEntry> pullDownButton = ScreenConstants.getPullDownButton(this, this.configInstance);
        this.addButton(pullDownButton);
        pullDownButton.initDropDownEntries(this.configInstance, this.getParent());
        pullDownButton.addToList(this::addButton);
    }

    void addTabButtons(WidthAdder widthAdder) {
        int index = 0;
        while (index < this.configTabs.size()) {
            ConfigTab configTab = this.configTabs.get(index);
            String name = configTab.getGuiDisplayName();
            int stringWidth = this.fontRenderer.getStringWidth(name);
            int finalIndex = index++;
            this.addButton(ButtonGeneric.builder(name, button -> this.setCurrentTab(finalIndex)).onUpdate(button -> button.setEnabled(this.currentTabIndex != finalIndex)).dimensions(widthAdder.getWidth(), 30, stringWidth + 10, 20).hoverStrings(configTab.getTooltip()).build());
            widthAdder.addWidth(stringWidth + 14);
        }
    }

    void setCurrentTab(int index) {
        this.needSyncTab = true;
        this.currentTab = this.configTabs.get(index);
        this.currentTabIndex = index;
    }

    @Override
    protected ConfigItem<?> createEntry(int realIndex, int relativeIndex) {
        return ConfigItem.getConfigItem(relativeIndex, this.currentTab.getSearchableConfig(realIndex), this);
    }

    @Override
    public int getContentSize() {
        return this.currentTab.getSearchableConfigSize();
    }

    @Override
    public int getMaxCapacity() {
        return 7;
    }

    @Override
    protected boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            if (this.needSyncTab) {
                this.needSyncTab = false;
                this.initGui();
            }
            return true;
        }
        return this.entries.stream().filter(configItem -> configItem instanceof AboutInputMethod).map(configItem -> (AboutInputMethod)((Object)configItem)).anyMatch(aboutInputMethod -> aboutInputMethod.tryActivateIM(mouseX, mouseY, mouseButton));
    }

    @Override
    protected boolean onCharTyped(char charIn, int modifiers) {
        if (super.onCharTyped(charIn, modifiers)) {
            return true;
        }
        if (modifiers == 42) {
            long time = System.currentTimeMillis();
            if (time - this.lastShift < 200L) {
                this.mc.displayGuiScreen((GuiScreen)new GlobalSearchScreen(this));
                return true;
            }
            this.lastShift = time;
        }
        return false;
    }

    public void confirmClicked(boolean result, int flag) {
        if (result && flag == 0) {
            this.currentTab.getAllConfigs().forEach(IConfigResettable::resetToDefault);
        }
        this.mc.displayGuiScreen((GuiScreen)this);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.configInstance.save();
        InputEventHandler.getKeybindManager().updateUsedKeys();
        ProgressSaving.saveProgress(this.configInstance.getName(), this.currentTabIndex, this.getStatus());
        this.firstSeen = true;
    }

    void sort(SortCategory sortCategory) {
        this.currentTab.sort(sortCategory);
        this.resetStatus();
        this.markShouldUpdateEntries();
    }

    @Override
    public void updateSearchResult(String input) {
        this.currentTab.updateSearchableConfigs(input);
        this.onContentChange();
    }

    public String createTitle() {
        return this.configInstance.getName() + " Configs";
    }
}

