/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.screen.interfaces.StatusScreen;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.GuiScreen;
import net.minecraft.MathHelper;
import org.lwjgl.opengl.GL11;

public class ScrollBar<T extends GuiScreen>
extends ButtonGeneric {
    protected boolean dragging;
    protected float sliderRatio;
    protected int maxStatus;
    protected float percentage;
    protected int sliderHeight;
    protected final T screen;

    public ScrollBar(int xPos, int yPos, int width, int height, int pageCapacity, int maxStatus, T screen) {
        super(xPos, yPos, width, height, "", button -> {});
        this.updateArguments(maxStatus, pageCapacity);
        this.screen = screen;
        this.setRenderDefaultBackground(false);
    }

    public void updateArguments(boolean visible) {
        this.setVisible(visible);
        this.updateArguments(((StatusScreen)this.screen).getMaxCapacity(), ((StatusScreen)this.screen).getContentSize());
    }

    private void updateArguments(int pageCapacity, int contentSize) {
        float temp;
        if (contentSize <= pageCapacity) {
            temp = 1.0f;
            this.maxStatus = 0;
        } else {
            temp = (float)pageCapacity / (float)contentSize;
            this.maxStatus = contentSize - pageCapacity;
        }
        this.percentage = temp;
        this.sliderHeight = (int)((float)this.height * temp);
    }

    @Override
    protected int getTextureOffset(boolean isMouseOver) {
        return 0;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, DrawContext drawContext) {
        if (this.visible) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int backGroundColor = StringUtils.getColor("#C0404040", 0);
            this.drawGradientRect(this.x, this.y, this.x + this.width, this.y + this.height, backGroundColor, backGroundColor);
        }
        super.render(mouseX, mouseY, selected, drawContext);
    }

    @Override
    public void onMouseDraggedImpl(int mouseX, int mouseY) {
        if (this.enabled && this.visible) {
            if (this.dragging) {
                this.sliderRatio = this.getRatioFromSlider(mouseY);
                this.updateScreenByRatio();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int scrollColor = StringUtils.getColor("#FFFFFFFF", 0);
            int y = this.y + (int)(this.sliderRatio * (float)(this.height - 8));
            if (y > this.y + this.height - this.sliderHeight) {
                y = this.y + this.height - this.sliderHeight;
            }
            this.drawGradientRect(this.x + 1, y + 1, this.x + this.width - 1, y + this.sliderHeight + 3, scrollColor, scrollColor);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            this.sliderRatio = this.getRatioFromSlider(mouseY);
            this.updateScreenByRatio();
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseReleasedImpl(int mouseX, int mouseY, int mouseButton) {
        this.dragging = false;
    }

    public void updateRatioByScreen(int status) {
        if (this.maxStatus > 0) {
            this.sliderRatio = (1.0f - this.percentage) * ((float)status / (float)this.maxStatus);
        }
    }

    private void updateScreenByRatio() {
        float temp = 1.0f;
        if (this.sliderRatio < 1.0f - this.percentage) {
            temp = this.sliderRatio / (1.0f - this.percentage);
        }
        ((StatusScreen)this.screen).setStatusByRatio(temp);
    }

    private float getRatioFromSlider(int mouseY) {
        return MathHelper.clamp_float((float)((float)(mouseY - (this.y + 4)) / (float)(this.height - 8)), (float)0.0f, (float)1.0f);
    }
}

