/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import fi.dy.masa.malilib.ManyLibConfig;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.ManyLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonActionListener;
import fi.dy.masa.malilib.gui.screen.util.DropDownEntry;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.GuiScreen;

public class PullDownButton<T extends DropDownEntry>
extends ButtonGeneric {
    private boolean expand;
    List<T> dropDownEntries = new ArrayList<T>();
    Constructor<T> constructor;

    public PullDownButton(int x, int y, int width, int height, String message, String tooltip, Constructor<T> constructor) {
        super(x, y, width, height, message, null);
        this.actionListener = button -> {
            this.dropDownEntries.forEach(dropDownEntry -> dropDownEntry.setVisible(!dropDownEntry.isVisible()));
            this.expand = !this.expand;
        };
        this.setHoverStrings(tooltip);
        this.setTextCentered(false);
        this.setRenderDefaultBackground(false);
        this.constructor = constructor;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, DrawContext drawContext) {
        if (this.visible) {
            if (this.expand) {
                RenderUtils.drawRect(0, 0, GuiUtils.getScaledWindowWidth(), GuiUtils.getScaledWindowHeight(), ManyLibConfig.HighlightColor.getColorInteger());
            }
            RenderUtils.drawOutline(this.x, this.y, this.width, this.height, -1);
            this.bindTexture(ManyLibIcons.ARROW_DOWN.getTexture());
            ManyLibIcons.ARROW_DOWN.renderAt(this.x + this.width - 20, this.y + 1, 0.0f, false, false);
        }
        super.render(mouseX, mouseY, selected, drawContext);
    }

    @Override
    protected void onMouseReleasedImpl(int mouseX, int mouseY, int mouseButton) {
        super.onMouseReleasedImpl(mouseX, mouseY, mouseButton);
        if (this.expand && !this.isMouseOver(mouseX, mouseY)) {
            this.actionListener.actionPerformedWithButton(this);
        }
    }

    public void initDropDownEntries(IConfigHandler currentConfigInstance, GuiScreen parent) {
        this.dropDownEntries.clear();
        Map<String, IConfigHandler> configMap = ConfigManager.getInstance().getConfigMap();
        String[] array = (String[])configMap.keySet().toArray(String[]::new);
        for (int i = 0; i < array.length; ++i) {
            String key = array[i];
            IConfigHandler iConfigHandler = configMap.get(key);
            this.dropDownEntries.add((T)((Object)((DropDownEntry)((Object)this.constructor.createEntry(i, this.x, this.y + this.height, iConfigHandler == currentConfigInstance, iConfigHandler.getName(), button -> this.mc.displayGuiScreen(iConfigHandler.getConfigScreen(parent)))))));
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        return super.onMouseClickedImpl(mouseX, mouseY, mouseButton);
    }

    public void addToList(Consumer<T> consumer) {
        this.dropDownEntries.forEach(consumer);
    }

    @FunctionalInterface
    public static interface Constructor<T> {
        public T createEntry(int var1, int var2, int var3, boolean var4, String var5, IButtonActionListener var6);
    }
}

