/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.interfaces.IConfigBase;
import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.widgets.WidgetTextField;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormatting;
import net.minecraft.FontRenderer;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends GuiScreen
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = EnumChatFormatting.AQUA.toString();
    public static final String TXT_BLACK = EnumChatFormatting.BLACK.toString();
    public static final String TXT_BLUE = EnumChatFormatting.BLUE.toString();
    public static final String TXT_GOLD = EnumChatFormatting.GOLD.toString();
    public static final String TXT_GRAY = EnumChatFormatting.GRAY.toString();
    public static final String TXT_GREEN = EnumChatFormatting.GREEN.toString();
    public static final String TXT_RED = EnumChatFormatting.RED.toString();
    public static final String TXT_WHITE = EnumChatFormatting.WHITE.toString();
    public static final String TXT_YELLOW = EnumChatFormatting.YELLOW.toString();
    public static final String TXT_BOLD = EnumChatFormatting.BOLD.toString();
    public static final String TXT_ITALIC = EnumChatFormatting.ITALIC.toString();
    public static final String TXT_RST = EnumChatFormatting.RESET.toString();
    public static final String TXT_STRIKETHROUGH = EnumChatFormatting.STRIKETHROUGH.toString();
    public static final String TXT_UNDERLINE = EnumChatFormatting.UNDERLINE.toString();
    public static final String TXT_DARK_AQUA = EnumChatFormatting.DARK_AQUA.toString();
    public static final String TXT_DARK_BLUE = EnumChatFormatting.DARK_BLUE.toString();
    public static final String TXT_DARK_GRAY = EnumChatFormatting.DARK_GRAY.toString();
    public static final String TXT_DARK_GREEN = EnumChatFormatting.DARK_GREEN.toString();
    public static final String TXT_DARK_PURPLE = EnumChatFormatting.DARK_PURPLE.toString();
    public static final String TXT_DARK_RED = EnumChatFormatting.DARK_RED.toString();
    public static final String TXT_LIGHT_PURPLE = EnumChatFormatting.LIGHT_PURPLE.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 40;
    protected static final int TOP = 15;
    public final Minecraft mc = Minecraft.getMinecraft();
    public final FontRenderer textRenderer;
    public final int fontHeight;
    protected final List<ButtonBase> buttons;
    protected final List<WidgetBase> widgets;
    protected final List<TextFieldWrapper<? extends WidgetTextField>> textFields;
    private final MessageRenderer messageRenderer;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    @Nullable
    private GuiScreen parent;

    public GuiBase() {
        this.textRenderer = this.mc.fontRenderer;
        this.fontHeight = this.textRenderer.FONT_HEIGHT;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends WidgetTextField>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable GuiScreen parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public GuiScreen getParent() {
        return this.parent;
    }

    public String getTitleString() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitleString() + " => " + this.title : this.title;
    }

    public WidgetBase getHoveredWidget() {
        return this.hoveredWidget;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void resize(Minecraft mc, int width, int height) {
        GuiScreen guiScreen;
        if (this.parent != null && (guiScreen = this.parent) instanceof GuiBase) {
            GuiBase guiBase = (GuiBase)guiScreen;
            guiBase.resize(mc, width, height);
        }
    }

    public void initGui() {
        super.initGui();
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.mc.displayGuiScreen(this.parent);
        }
    }

    public final void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.render(new DrawContext(), mouseX, mouseY, partialTicks);
    }

    protected void render(DrawContext drawContext, int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY);
        this.drawTitle(drawContext, mouseX, mouseY, partialTicks);
        this.drawWidgets(mouseX, mouseY, drawContext);
        this.drawTextFields(mouseX, mouseY, drawContext);
        this.drawButtons(mouseX, mouseY, partialTicks, drawContext);
        this.drawContents(drawContext, mouseX, mouseY, partialTicks);
        this.drawButtonHoverTexts(mouseX, mouseY, partialTicks, drawContext);
        this.drawHoveredWidget(mouseX, mouseY, drawContext);
        this.drawGuiMessages(drawContext);
    }

    protected final void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    protected final void mouseMovedOrUp(int par1, int par2, int par3) {
        this.onMouseReleased(par1, par2, par3);
    }

    protected final void keyTyped(char par1, int par2) {
        this.onCharTyped(par1, par2);
    }

    protected boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends WidgetTextField> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    protected boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        for (ButtonBase button : this.buttons) {
            button.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    protected boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        for (TextFieldWrapper<? extends WidgetTextField> entry : this.textFields) {
            if (!entry.onCharTyped(charIn, modifiers)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && modifiers == 1) {
            this.closeGui(true);
            return true;
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages(DrawContext drawContext) {
        this.messageRenderer.drawMessages(this.width / 2, this.height / 2, drawContext);
    }

    public void bindTexture(ResourceLocation texture) {
        RenderUtils.bindTexture(texture);
    }

    public <T extends ButtonBase> void addButton(T button) {
        this.buttons.add(button);
    }

    public <T extends WidgetTextField> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains((Object)widget)) {
            this.widgets.remove((Object)widget);
            return true;
        }
        return false;
    }

    public final void updateScreen() {
        this.tickScreen();
    }

    protected void tickScreen() {
        this.widgets.forEach(WidgetBase::tickScreen);
        this.buttons.forEach(WidgetBase::tickScreen);
    }

    protected void clearElements() {
        this.widgets.clear();
        this.buttons.clear();
        this.textFields.clear();
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
        this.drawDefaultBackground();
    }

    protected void drawTitle(DrawContext drawContext, int mouseX, int mouseY, float partialTicks) {
        this.drawString(drawContext, this.getTitleString(), 40, 15, -1);
    }

    protected void drawContents(DrawContext drawContext, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(int mouseX, int mouseY, float partialTicks, DrawContext drawContext) {
        for (ButtonBase button : this.buttons) {
            button.render(mouseX, mouseY, button.isMouseOver(), drawContext);
        }
    }

    protected void drawTextFields(int mouseX, int mouseY, DrawContext drawContext) {
        for (TextFieldWrapper<? extends WidgetTextField> entry : this.textFields) {
            entry.render(mouseX, mouseY, drawContext);
        }
    }

    protected void drawWidgets(int mouseX, int mouseY, DrawContext drawContext) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(mouseX, mouseY, false, drawContext);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(int mouseX, int mouseY, float partialTicks, DrawContext drawContext) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(mouseX, mouseY, button.getHoverStrings(), drawContext);
        }
    }

    protected boolean shouldRenderHoverStuff() {
        return this.mc.currentScreen == this;
    }

    protected void drawHoveredWidget(int mouseX, int mouseY, DrawContext drawContext) {
        if (!this.shouldRenderHoverStuff()) {
            return;
        }
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(mouseX, mouseY, false, drawContext);
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.getStringWidth(text);
    }

    public void drawString(DrawContext drawContext, String text, int x, int y, int color) {
        drawContext.drawText(this.textRenderer, text, x, y, color, false);
    }

    public void drawStringWithShadow(DrawContext drawContext, String text, int x, int y, int color) {
        drawContext.drawTextWithShadow(this.textRenderer, text, x, y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getConfigGuiDisplayName()));
        }
        return width;
    }

    public static void openGui(GuiScreen gui) {
        Minecraft.getMinecraft().displayGuiScreen(gui);
    }

    public static boolean isShiftDown() {
        return GuiScreen.isShiftKeyDown();
    }

    public static boolean isCtrlDown() {
        return GuiScreen.isCtrlKeyDown();
    }

    public static boolean isAltDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isLeftClicking() {
        return Mouse.isButtonDown((int)0);
    }

    public static boolean isRightClicking() {
        return Mouse.isButtonDown((int)1);
    }
}

