/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import fi.dy.masa.malilib.config.interfaces.ConfigType;
import fi.dy.masa.malilib.config.interfaces.IConfigBase;
import fi.dy.masa.malilib.config.interfaces.IConfigNotifiable;
import fi.dy.masa.malilib.config.interfaces.IConfigResettable;
import fi.dy.masa.malilib.config.interfaces.IValueChangeCallback;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigBase<T extends IConfigBase>
implements IConfigBase,
IConfigResettable,
IConfigNotifiable<T> {
    private final ConfigType type;
    private final String name;
    private final String comment;
    private IValueChangeCallback<T> callback;

    public ConfigBase(ConfigType type, String name, String comment) {
        this.type = type;
        this.name = name;
        this.comment = comment;
    }

    @Override
    public ConfigType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setValueChangeCallback(IValueChangeCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged(this);
        }
    }
}

