/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigTab;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.screen.DefaultConfigScreen;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.GuiScreen;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleConfigs
implements IConfigHandler {
    protected String name;
    protected File optionsFile;
    protected final List<ConfigHotkey> hotkeys;
    protected final List<ConfigBase<?>> values;
    protected String menuComment;

    public SimpleConfigs(String name, List<ConfigHotkey> hotkeys, List<?> values) {
        this(name, hotkeys, values, null);
    }

    public SimpleConfigs(String name, List<ConfigHotkey> hotkeys, List<?> values, String menuComment) {
        this.name = name;
        this.optionsFile = new File("config" + File.separator + name + ".json");
        if (values == null || values.isEmpty()) {
            this.values = List.of();
        } else {
            this.values = new ArrayList();
            SimpleConfigs.castFill(this.values, values);
        }
        this.hotkeys = hotkeys == null || hotkeys.isEmpty() ? List.of() : hotkeys;
        this.menuComment = menuComment;
    }

    @Deprecated(since="2.1.0", forRemoval=true)
    public SimpleConfigs(String name, List<ConfigHotkey> hotkeys, List<?> values, String valueComment, String hotKeysComment) {
        this(name, hotkeys, values, valueComment);
    }

    private static <T> void castFill(List<T> to, List<?> from) {
        for (Object o : from) {
            to.add(o);
        }
    }

    @Override
    public GuiScreen getConfigScreen(GuiScreen parentScreen) {
        return new DefaultConfigScreen(parentScreen, this);
    }

    @Override
    public void save() {
        JsonObject configRoot = new JsonObject();
        if (!this.hotkeys.isEmpty()) {
            ConfigUtils.writeConfigBase(configRoot, "HotKeys", this.hotkeys);
        }
        if (!this.values.isEmpty()) {
            ConfigUtils.writeConfigBase(configRoot, "Values", this.values);
        }
        JsonUtils.writeJsonToFile(configRoot, this.optionsFile);
    }

    @Override
    public void load() {
        if (!this.optionsFile.exists()) {
            this.save();
            return;
        }
        JsonElement jsonElement = JsonUtils.parseJsonFile(this.optionsFile);
        if (jsonElement != null && jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            ConfigUtils.readConfigBase(obj, "HotKeys", this.hotkeys);
            ConfigUtils.readConfigBase(obj, "Values", this.values);
            this.save();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Deprecated(since="1.1.2")
    public File getOptionsFile() {
        return this.optionsFile;
    }

    @Override
    @Nullable
    public List<ConfigHotkey> getHotkeys() {
        return this.hotkeys;
    }

    @Override
    public List<ConfigTab> getConfigTabs() {
        ArrayList<ConfigTab> configTabs = new ArrayList<ConfigTab>();
        if (!this.values.isEmpty()) {
            configTabs.add(new ConfigTab("generic", this.values));
        }
        if (!this.hotkeys.isEmpty()) {
            ArrayList temp = new ArrayList();
            SimpleConfigs.castFill(temp, this.hotkeys);
            configTabs.add(new ConfigTab("hotkey", temp));
        }
        return configTabs;
    }

    @Override
    @Nullable
    public List<ConfigBase<?>> getValues() {
        return this.values;
    }

    @Override
    public String getMenuComment() {
        return StringUtils.getTranslatedOrFallback("config.menu.comment." + this.name, this.menuComment);
    }
}

