/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.feat.SortCategory;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigTab {
    String unlocalizedName;
    final ImmutableList<ConfigBase<?>> allConfigs;
    List<ConfigBase<?>> searchableConfigs;
    String searchText;

    public ConfigTab(String unlocalizedName, List<?> allConfigs) {
        this.unlocalizedName = unlocalizedName;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object allConfig : allConfigs) {
            ConfigBase config = (ConfigBase)allConfig;
            if (!ConfigItem.supported(config)) continue;
            builder.add((Object)config);
        }
        this.allConfigs = builder.build();
        this.searchableConfigs = new ArrayList((Collection<ConfigBase<?>>)this.allConfigs);
    }

    public String getGuiDisplayName() {
        return StringUtils.getTranslatedOrFallback("config.tab." + this.unlocalizedName, this.unlocalizedName);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getTooltip() {
        return StringUtils.getTranslatedOrFallback("config.tab." + this.unlocalizedName + ".comment", null);
    }

    public List<ConfigBase<?>> getAllConfigs() {
        return this.allConfigs;
    }

    public void sort(SortCategory sortCategory) {
        if (sortCategory == SortCategory.Default) {
            if (this.searchText == null || this.searchText.isEmpty()) {
                this.searchableConfigs = new ArrayList((Collection<ConfigBase<?>>)this.allConfigs);
            } else {
                this.updateSearchableConfigs(this.searchText);
            }
        } else {
            this.searchableConfigs.sort(sortCategory.category);
        }
    }

    public void updateSearchableConfigs(String input) {
        this.searchText = input;
        if (input.isEmpty()) {
            this.resetSearchableConfigs();
            return;
        }
        this.searchableConfigs = this.allConfigs.stream().filter(configBase -> StringUtils.stringMatchesInput(configBase.getConfigGuiDisplayName(), input)).collect(Collectors.toList());
    }

    public void resetSearchableConfigs() {
        this.searchableConfigs = new ArrayList((Collection<ConfigBase<?>>)this.allConfigs);
    }

    public int getSearchableConfigSize() {
        return this.searchableConfigs.size();
    }

    public ConfigBase<?> getSearchableConfig(int index) {
        return this.searchableConfigs.get(index);
    }
}

