/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.SimpleConfigs;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.EnumChatFormatting;

public class ManyLibConfig
extends SimpleConfigs {
    private static final ManyLibConfig Instance;
    public static final List<ConfigHotkey> hotkeys;
    public static final List<ConfigBase<?>> values;
    public static final ConfigHotkey OpenConfigMenu;
    public static final ConfigHotkey OpenModMenu;
    public static final ConfigHotkey SearchAny;
    public static final ConfigBoolean HideConfigButton;
    public static final ConfigInteger HoverTextYLevel;
    public static final ConfigColor HighlightColor;
    public static final ConfigEnum<EnumChatFormatting> TitleFormat;
    public static final ConfigBoolean AutoSaveLoad;

    public ManyLibConfig(String name, List<ConfigHotkey> hotkeys, List<?> values) {
        super(name, hotkeys, values);
    }

    public static ManyLibConfig getInstance() {
        return Instance;
    }

    @Override
    public String getMenuComment() {
        return StringUtils.translate("config.menu.comment." + this.name, OpenConfigMenu.getDisplayText());
    }

    static {
        OpenConfigMenu = new ConfigHotkey("manyLib.openMenu", "M,C", "\u6253\u5f00ManyLib\u81ea\u8eab\u914d\u7f6e\u9875\u9762");
        OpenModMenu = new ConfigHotkey("manyLib.openModMenu", KeybindMulti.fromStorageString("M", KeybindSettings.RELEASE), "\u6253\u5f00ManyLib\u5168\u90e8\u7528\u6237\u7684\u83dc\u5355");
        SearchAny = new ConfigHotkey("manyLib.searchAny", "M,A", "ManyLib\u5168\u5c40\u914d\u7f6e\u641c\u7d22");
        HideConfigButton = new ConfigBoolean("manyLib.hideValueButton", false, "\u9690\u85cf\u5728\u6e38\u620f\u4e3b\u754c\u9762\u4ee5\u53ca\u6682\u505c\u754c\u9762\u7684\u6570\u503c\u914d\u7f6e\u6309\u94ae");
        HoverTextYLevel = new ConfigInteger("manyLib.hoverInfoY", 70, 0, 512, false, "\u4ece\u5c4f\u5e55\u5e95\u90e8\u5f80\u4e0a\u6570");
        HighlightColor = new ConfigColor("manyLib.highlightColor", "#77777777");
        TitleFormat = new ConfigEnum<EnumChatFormatting>("manyLib.titleFormat", EnumChatFormatting.WHITE);
        AutoSaveLoad = new ConfigBoolean("manyLib.autoSaveLoad", true, "(\u5bf9\u6240\u6709\u6a21\u7ec4\u6709\u6548)\u8fdb\u5165\u4e16\u754c\u65f6\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6, \u9000\u51fa\u65f6\u4fdd\u5b58");
        values = List.of(HideConfigButton, HoverTextYLevel, HighlightColor, TitleFormat, AutoSaveLoad);
        hotkeys = List.of(OpenConfigMenu, OpenModMenu, SearchAny);
        Instance = new ManyLibConfig("ManyLib", hotkeys, values);
    }

    public static class Debug {
        public static final ConfigBoolean INPUT_CANCELLATION_DEBUG = new ConfigBoolean("inputCancellationDebugging", false, "When enabled, then the cancellation reason/source\nfor inputs (keyboard and mouse) is printed out");
        public static final ConfigBoolean KEYBIND_DEBUG = new ConfigBoolean("keybindDebugging", false, "When enabled, key presses and held keys are\nprinted to the game console (and the action bar, if enabled)");
        public static final ConfigBoolean KEYBIND_DEBUG_ACTIONBAR = new ConfigBoolean("keybindDebuggingIngame", true, "If enabled, then the messages from 'keybindDebugging'\nare also printed to the in-game action bar");
        public static final ConfigBoolean MOUSE_SCROLL_DEBUG = new ConfigBoolean("mouseScrollDebug", false, "If enabled, some debug values from mouse scrolling\nare printed to the game console/log");
        public static final ImmutableList<ConfigBase<?>> OPTIONS = ImmutableList.of((Object)INPUT_CANCELLATION_DEBUG, (Object)KEYBIND_DEBUG, (Object)KEYBIND_DEBUG_ACTIONBAR, (Object)MOUSE_SCROLL_DEBUG);
    }
}

