/*
 * Decompiled with CFR 0.152.
 */
package com.github.Debris.ModernMite.mixins.misc;

import com.github.Debris.ModernMite.config.EnumSprintingMode;
import com.github.Debris.ModernMite.config.ModernMiteConfig;
import com.github.skystardust.InputMethodBlocker.NativeUtils;
import com.github.skystardust.InputMethodBlocker.compat.InputMethodHandler;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.EntityClientPlayerMP;
import net.minecraft.EntityPlayer;
import net.minecraft.GameSettings;
import net.minecraft.GuiChat;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import net.minecraft.PlayerControllerMP;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    public EntityClientPlayerMP thePlayer;
    @Shadow
    public GameSettings gameSettings;
    @Shadow
    public GuiScreen currentScreen;

    @Shadow
    public abstract void displayGuiScreen(GuiScreen var1);

    @WrapWithCondition(method={"startGame"}, at={@At(value="INVOKE", target="Lnet/minecraft/ReferenceFileWriter;write()V")})
    private boolean doNotWriteReferenceFile() {
        return !ModernMiteConfig.NoReferenceFile.getBooleanValue();
    }

    @WrapWithCondition(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/PlayerControllerMP;toggleRun(Lnet/minecraft/EntityPlayer;)V")})
    private boolean sprintingMode(PlayerControllerMP instance, EntityPlayer player) {
        return switch ((EnumSprintingMode)ModernMiteConfig.SprintingMode.getEnumValue()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumSprintingMode.Toggle -> true;
            case EnumSprintingMode.Press -> {
                if (this.thePlayer.movementInput.moveForward > 0.0f) {
                    this.thePlayer.setSprinting(true);
                }
                yield false;
            }
        };
    }

    @Inject(method={"displayGuiScreen"}, at={@At(value="HEAD")})
    private void chatFix(GuiScreen screen, CallbackInfo ci) {
        NativeUtils.activeOrInactive(InputMethodHandler.getInstance().shouldActive(screen));
    }

    @Inject(method={"openChat"}, at={@At(value="TAIL")})
    private void active(GuiChat chatScreen, CallbackInfo ci) {
        if (ModernMiteConfig.VanillaChat.getBooleanValue()) {
            return;
        }
        NativeUtils.activeOrInactive(!chatScreen.defaultInputFieldText.startsWith("/") || ModernMiteConfig.SlashIM.getBooleanValue());
    }

    @Inject(method={"closeImposedChat"}, at={@At(value="HEAD")})
    private void inactive(CallbackInfo ci) {
        if (ModernMiteConfig.VanillaChat.getBooleanValue()) {
            return;
        }
        NativeUtils.inactive("");
    }

    @WrapOperation(method={"clickMouse"}, at={@At(value="INVOKE", target="Lnet/minecraft/GuiScreen;isCtrlKeyDown()Z", ordinal=0)})
    private boolean noAttackDump(Operation<Boolean> original) {
        return !ModernMiteConfig.NoAttackDump.getBooleanValue() && (Boolean)original.call(new Object[0]) != false;
    }

    @Inject(method={"runTick"}, at={@At(value="TAIL")})
    public void allowsImposedChat(CallbackInfo ci) {
        if (!ModernMiteConfig.VanillaChat.getBooleanValue()) {
            return;
        }
        while (this.gameSettings.keyBindChat.isPressed() && this.gameSettings.chatVisibility != 2) {
            this.displayGuiScreen((GuiScreen)new GuiChat());
        }
        if (this.currentScreen == null && this.gameSettings.keyBindCommand.isPressed() && this.gameSettings.chatVisibility != 2) {
            this.displayGuiScreen((GuiScreen)new GuiChat("/"));
        }
    }
}

