/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.mixin.common.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import moddedmite.xylose.bettergamesetting.api.IGameSetting;
import moddedmite.xylose.bettergamesetting.client.CustomKeys;
import moddedmite.xylose.bettergamesetting.client.EnumOptionsExtra;
import moddedmite.xylose.bettergamesetting.util.OptionMathHelper;
import net.minecraft.EnumOptions;
import net.minecraft.GameSettings;
import net.minecraft.I18n;
import net.minecraft.KeyBinding;
import net.minecraft.Minecraft;
import net.minecraft.client.main.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GameSettings.class})
public abstract class GameSettingsMixin
implements IGameSetting {
    @Shadow
    private File optionsFile;
    @Shadow
    public int renderDistance;
    @Shadow
    public int limitFramerate;
    @Shadow
    public float gammaSetting;
    @Shadow
    public float fovSetting;
    @Shadow
    public boolean clouds;
    @Shadow
    protected Minecraft mc;
    @Shadow
    public KeyBinding[] keyBindings;
    @Unique
    public boolean forceUnicodeFont;
    @Unique
    public float recordVolume = 1.0f;
    @Unique
    public float weatherVolume = 1.0f;
    @Unique
    public float blockVolume = 1.0f;
    @Unique
    public float hostileVolume = 1.0f;
    @Unique
    public float neutralVolume = 1.0f;
    @Unique
    public float playerVolume = 1.0f;
    @Unique
    public float ambientVolume = 1.0f;
    @Unique
    public float uiVolume = 1.0f;
    @Unique
    private static final Gson gson = new Gson();
    @Unique
    public List<String> resourcePacks = Lists.newArrayList();
    @Unique
    public List<String> incompatibleResourcePacks = Lists.newArrayList();
    @Unique
    private static final ParameterizedType typeListString = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    @Unique
    public boolean transparentBackground;
    @Unique
    public boolean highlightButtonText;

    @Shadow
    protected abstract float parseFloat(String var1);

    @Shadow
    public abstract void saveOptions();

    @Shadow
    public abstract float getOptionFloatValue(EnumOptions var1);

    @WrapOperation(method={"<init>(Lnet/minecraft/Minecraft;Ljava/io/File;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/GameSettings;loadOptions()V", opcode=181)})
    private void newDefaultValue(GameSettings instance, Operation<Void> original) {
        this.renderDistance = 8;
        this.limitFramerate = 120;
        this.gammaSetting = 0.5f;
        this.fovSetting = 70.0f;
        this.resourcePacks.add("MITE Resource Pack 1.6.4.zip");
        this.forceUnicodeFont = false;
        this.transparentBackground = true;
        this.highlightButtonText = true;
        original.call(new Object[]{instance});
    }

    @Inject(method={"<init>()V"}, at={@At(value="RETURN")})
    private void newDefaultValue_1(CallbackInfo ci) {
        this.renderDistance = 8;
        this.limitFramerate = 120;
        this.gammaSetting = 0.5f;
        this.fovSetting = 70.0f;
        this.resourcePacks.add("MITE Resource Pack 1.6.4.zip");
        this.forceUnicodeFont = false;
        this.transparentBackground = true;
        this.highlightButtonText = true;
    }

    @Redirect(method={"<init>(Lnet/minecraft/Minecraft;Ljava/io/File;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/GameSettings;gammaSetting:F", opcode=181))
    private void keepGammaSetting(GameSettings instance, float value) {
    }

    @Inject(method={"initKeybindings"}, at={@At(value="RETURN")})
    private void addKeybindings(CallbackInfo ci) {
        KeyBinding[] vanillaKeyBindings = this.keyBindings;
        KeyBinding[] myKeybindings = CustomKeys.getNewKeybindings();
        KeyBinding[] newKeyBindings = new KeyBinding[vanillaKeyBindings.length + myKeybindings.length];
        System.arraycopy(vanillaKeyBindings, 0, newKeyBindings, 0, vanillaKeyBindings.length);
        System.arraycopy(myKeybindings, 0, newKeyBindings, vanillaKeyBindings.length, myKeybindings.length);
        this.keyBindings = newKeyBindings;
    }

    @Inject(method={"setOptionValue"}, at={@At(value="HEAD")})
    public void setOptionValue(EnumOptions par1EnumOptions, int par2, CallbackInfo ci) {
        if (par1EnumOptions == EnumOptionsExtra.FORCE_UNICODE_FONT) {
            this.forceUnicodeFont = !this.forceUnicodeFont;
            this.mc.fontRenderer.setUnicodeFlag(this.mc.getLanguageManager().isCurrentLocaleUnicode() || this.forceUnicodeFont);
        }
        if (par1EnumOptions == EnumOptionsExtra.TRANSPARENT_BACKGROUND) {
            boolean bl = this.transparentBackground = !this.transparentBackground;
        }
        if (par1EnumOptions == EnumOptionsExtra.HIGHLIGHT_BUTTON_TEXT) {
            this.highlightButtonText = !this.highlightButtonText;
        }
    }

    @Inject(method={"setOptionFloatValue"}, at={@At(value="TAIL")})
    public void setOptionFloatValue(EnumOptions par1EnumOptions, float par2, CallbackInfo ci) {
        if (par1EnumOptions == EnumOptions.RENDER_DISTANCE) {
            this.renderDistance = (int)par2;
        }
        if (par1EnumOptions == EnumOptions.FRAMERATE_LIMIT) {
            this.limitFramerate = (int)par2;
        }
        if (par1EnumOptions == EnumOptions.FOV) {
            this.fovSetting = (int)OptionMathHelper.denormalizeValue(par2, 30.0f, 110.0f, 1.0f);
        }
        if (par1EnumOptions == EnumOptions.GAMMA) {
            this.gammaSetting = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.RECORDS) {
            this.recordVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.WEATHER) {
            this.weatherVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.BLOCKS) {
            this.blockVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.MOBS) {
            this.hostileVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.ANIMALS) {
            this.neutralVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.PLAYERS) {
            this.playerVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.AMBIENT) {
            this.ambientVolume = par2;
        }
        if (par1EnumOptions == EnumOptionsExtra.UI) {
            this.uiVolume = par2;
        }
    }

    @Inject(method={"getOptionFloatValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOptionFloatValue(EnumOptions par1EnumOptions, CallbackInfoReturnable<Float> cir) {
        if (par1EnumOptions == EnumOptions.RENDER_DISTANCE) {
            cir.setReturnValue((Object)Float.valueOf(this.renderDistance));
        }
        if (par1EnumOptions == EnumOptions.FRAMERATE_LIMIT) {
            cir.setReturnValue((Object)Float.valueOf(this.limitFramerate));
        }
        if (par1EnumOptions == EnumOptions.FOV) {
            cir.setReturnValue((Object)Float.valueOf(OptionMathHelper.normalizeValue(this.fovSetting, 30.0f, 110.0f, 1.0f)));
        }
        if (par1EnumOptions == EnumOptions.GAMMA) {
            cir.setReturnValue((Object)Float.valueOf(this.gammaSetting));
        }
        if (par1EnumOptions == EnumOptionsExtra.RECORDS) {
            cir.setReturnValue((Object)Float.valueOf(this.recordVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.WEATHER) {
            cir.setReturnValue((Object)Float.valueOf(this.weatherVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.BLOCKS) {
            cir.setReturnValue((Object)Float.valueOf(this.blockVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.MOBS) {
            cir.setReturnValue((Object)Float.valueOf(this.hostileVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.ANIMALS) {
            cir.setReturnValue((Object)Float.valueOf(this.neutralVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.PLAYERS) {
            cir.setReturnValue((Object)Float.valueOf(this.playerVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.AMBIENT) {
            cir.setReturnValue((Object)Float.valueOf(this.ambientVolume));
        }
        if (par1EnumOptions == EnumOptionsExtra.UI) {
            cir.setReturnValue((Object)Float.valueOf(this.uiVolume));
        }
    }

    @Inject(method={"getKeyBinding"}, at={@At(value="HEAD")}, cancellable=true)
    public void getKeyBinding(EnumOptions par1EnumOptions, CallbackInfoReturnable<String> cir) {
        String var2 = I18n.getString((String)par1EnumOptions.getEnumString()) + ": ";
        float var5 = this.getOptionFloatValue(par1EnumOptions);
        if (par1EnumOptions == EnumOptions.RENDER_DISTANCE) {
            cir.setReturnValue((Object)(var2 + this.renderDistance + I18n.getString((String)"options.chunks")));
        }
        if (par1EnumOptions == EnumOptions.FRAMERATE_LIMIT) {
            if (this.limitFramerate >= 260) {
                cir.setReturnValue((Object)(var2 + I18n.getString((String)"options.framerateLimit.max")));
            } else {
                cir.setReturnValue((Object)(var2 + this.limitFramerate + " fps"));
            }
        }
        if (par1EnumOptions == EnumOptions.FOV) {
            if (var5 == 0.5f) {
                cir.setReturnValue((Object)(var2 + I18n.getString((String)"options.fov.min")));
            } else if (var5 == 1.0f) {
                cir.setReturnValue((Object)(var2 + I18n.getString((String)"options.fov.max")));
            } else {
                cir.setReturnValue((Object)(var2 + (int)this.fovSetting));
            }
        }
        if (par1EnumOptions == EnumOptionsExtra.FORCE_UNICODE_FONT) {
            cir.setReturnValue((Object)(var2 + GameSettingsMixin.getTranslationBoolean(this.forceUnicodeFont)));
        }
        if (par1EnumOptions == EnumOptionsExtra.TRANSPARENT_BACKGROUND) {
            cir.setReturnValue((Object)(var2 + GameSettingsMixin.getTranslationBoolean(this.transparentBackground)));
        }
        if (par1EnumOptions == EnumOptionsExtra.HIGHLIGHT_BUTTON_TEXT) {
            cir.setReturnValue((Object)(var2 + GameSettingsMixin.getTranslationBoolean(this.highlightButtonText)));
        }
    }

    @Inject(method={"loadOptions"}, at={@At(value="TAIL")})
    public void loadOptions(CallbackInfo ci) {
        try {
            String s;
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader var1 = new BufferedReader(new FileReader(this.optionsFile));
            while ((s = var1.readLine()) != null) {
                String[] astring = s.split(":");
                if (astring[0].equals("renderDistance")) {
                    int val = Integer.parseInt(astring[1]);
                    this.renderDistance = val == 0 ? 12 : (val == 1 ? 8 : val);
                }
                if (astring[0].equals("maxFps")) {
                    int val2 = Integer.parseInt(astring[1]);
                    this.limitFramerate = val2 == 2 ? 35 : (val2 == 1 || val2 == 3 ? 120 : (val2 == 0 ? 200 : val2));
                }
                if (astring[0].equals("fovSetting")) {
                    this.fovSetting = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("resourcePacks")) {
                    this.resourcePacks = (List)gson.fromJson(s.substring(s.indexOf(58) + 1), (Type)typeListString);
                    if (this.resourcePacks == null) {
                        this.resourcePacks = new ArrayList<String>();
                    }
                }
                if (astring[0].equals("incompatibleResourcePacks")) {
                    this.incompatibleResourcePacks = (List)gson.fromJson(s.substring(s.indexOf(58) + 1), (Type)typeListString);
                    if (this.incompatibleResourcePacks == null) {
                        this.incompatibleResourcePacks = Lists.newArrayList();
                    }
                }
                if (astring[0].equals("forceUnicodeFont")) {
                    this.forceUnicodeFont = astring[1].equals("true");
                }
                if (astring[0].equals("transparentBackground")) {
                    this.transparentBackground = astring[1].equals("true");
                }
                if (astring[0].equals("highlightButtonText")) {
                    this.highlightButtonText = astring[1].equals("true");
                }
                if (astring[0].equals("record")) {
                    this.recordVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("weather")) {
                    this.weatherVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("block")) {
                    this.blockVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("hostile")) {
                    this.hostileVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("neutral")) {
                    this.neutralVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("player")) {
                    this.playerVolume = this.parseFloat(astring[1]);
                }
                if (astring[0].equals("ambient")) {
                    this.ambientVolume = this.parseFloat(astring[1]);
                }
                if (!astring[0].equals("ui")) continue;
                this.uiVolume = this.parseFloat(astring[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject(method={"loadOptions"}, at={@At(value="FIELD", target="Lnet/minecraft/GameSettings;gammaSetting:F", opcode=181, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void loadGammaOptions(CallbackInfo ci, BufferedReader var1, String var2, String[] var3) {
        this.gammaSetting = this.parseFloat(var3[1]);
    }

    @ModifyArg(method={"saveOptions"}, at=@At(value="INVOKE", target="Ljava/io/PrintWriter;println(Ljava/lang/String;)V"))
    private String saveOptions(String x) {
        if (((String)x).equals("gamma:0.0")) {
            x = "gamma:" + this.gammaSetting;
        }
        return x;
    }

    @Redirect(method={"saveOptions"}, at=@At(value="INVOKE", target="Ljava/io/PrintWriter;println(Ljava/lang/String;)V", ordinal=4))
    private void disableVanillaFov(PrintWriter instance, String x) {
    }

    @Redirect(method={"saveOptions"}, at=@At(value="INVOKE", target="Ljava/io/PrintWriter;println(Ljava/lang/String;)V", ordinal=6))
    private void disableVanillaViewDistance(PrintWriter instance, String x) {
    }

    @Redirect(method={"saveOptions"}, at=@At(value="INVOKE", target="Ljava/io/PrintWriter;println(Ljava/lang/String;)V", ordinal=12))
    private void disableVanillaFpsLimit(PrintWriter instance, String x) {
    }

    @Inject(method={"saveOptions"}, at={@At(value="INVOKE", target="Ljava/io/PrintWriter;println(Ljava/lang/String;)V", ordinal=40)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void saveExtraOption(CallbackInfo ci, PrintWriter printwriter) {
        printwriter.println("resourcePacks:" + gson.toJson(this.resourcePacks));
        printwriter.println("incompatibleResourcePacks:" + gson.toJson(this.incompatibleResourcePacks));
        printwriter.println("fovSetting:" + this.fovSetting);
        printwriter.println("renderDistance:" + this.renderDistance);
        printwriter.println("maxFps:" + this.limitFramerate);
        printwriter.println("record:" + this.recordVolume);
        printwriter.println("weather:" + this.weatherVolume);
        printwriter.println("block:" + this.blockVolume);
        printwriter.println("hostile:" + this.hostileVolume);
        printwriter.println("neutral:" + this.neutralVolume);
        printwriter.println("player:" + this.playerVolume);
        printwriter.println("ambient:" + this.ambientVolume);
        printwriter.println("ui:" + this.uiVolume);
        printwriter.println("forceUnicodeFont:" + this.forceUnicodeFont);
        printwriter.println("transparentBackground:" + this.transparentBackground);
        printwriter.println("highlightButtonText:" + this.highlightButtonText);
    }

    @Overwrite
    public boolean shouldRenderClouds() {
        return this.clouds && this.renderDistance >= 4 && !Main.is_MITE_DS;
    }

    @Unique
    private static String getTranslationBoolean(boolean value) {
        return value ? I18n.getString((String)"options.on") : I18n.getString((String)"options.off");
    }

    @Override
    public void setOptionKeyBinding(KeyBinding key, int keyCode) {
        key.setKeyCode(keyCode);
        this.saveOptions();
    }

    @Override
    public float getRecordVolume() {
        return this.recordVolume;
    }

    @Override
    public float getWeatherVolume() {
        return this.weatherVolume;
    }

    @Override
    public float getBlockVolume() {
        return this.blockVolume;
    }

    @Override
    public float getHostileVolume() {
        return this.hostileVolume;
    }

    @Override
    public float getNeutralVolume() {
        return this.neutralVolume;
    }

    @Override
    public float getPlayerVolume() {
        return this.playerVolume;
    }

    @Override
    public float getAmbientVolume() {
        return this.ambientVolume;
    }

    @Override
    public float getUIVolume() {
        return this.uiVolume;
    }

    @Override
    public List<String> getResourcePacks() {
        return this.resourcePacks;
    }

    @Override
    public List<String> getIncompatibleResourcePacks() {
        return this.incompatibleResourcePacks;
    }

    @Override
    public boolean isForceUnicodeFont() {
        return this.forceUnicodeFont;
    }

    @Override
    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    @Override
    public boolean isHighlightButtonText() {
        return this.highlightButtonText;
    }
}

