/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.mixin.common.client;

import moddedmite.xylose.bettergamesetting.api.IEnumOptions;
import net.minecraft.EnumOptions;
import net.minecraft.MathHelper;
import net.xiaoyu233.fml.util.ReflectHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnumOptions.class})
public abstract class EnumOptionsMixin
implements IEnumOptions {
    @Final
    @Shadow
    public static EnumOptions RENDER_DISTANCE;
    @Final
    @Shadow
    public static EnumOptions FRAMERATE_LIMIT;
    @Final
    @Shadow
    public static EnumOptions GAMMA;
    @Final
    @Shadow
    public static EnumOptions GUI_SCALE;
    @Unique
    public float valueStep;
    @Unique
    private float valueMin;
    @Unique
    private float valueMax;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void setMinMaxStepValue(CallbackInfo ci) {
        GAMMA.setValueMin(0.0f);
        GAMMA.setValueMax(1.0f);
        GAMMA.setValueStep(0.01f);
        RENDER_DISTANCE.setValueMin(2.0f);
        RENDER_DISTANCE.setValueMax(16.0f);
        RENDER_DISTANCE.setValueStep(1.0f);
        FRAMERATE_LIMIT.setValueMin(10.0f);
        FRAMERATE_LIMIT.setValueMax(260.0f);
        FRAMERATE_LIMIT.setValueStep(10.0f);
        GUI_SCALE.setValueMin(0.0f);
        GUI_SCALE.setValueMax(10.0f);
        GUI_SCALE.setValueStep(1.0f);
    }

    @Inject(method={"getEnumFloat"}, at={@At(value="HEAD")}, cancellable=true)
    private void changeToEnumFloat(CallbackInfoReturnable<Boolean> cir) {
        if (ReflectHelper.dyCast((Object)this) == RENDER_DISTANCE) {
            cir.setReturnValue((Object)true);
        }
        if (ReflectHelper.dyCast((Object)this) == FRAMERATE_LIMIT) {
            cir.setReturnValue((Object)true);
        }
        if (ReflectHelper.dyCast((Object)this) == GUI_SCALE) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public float normalizeValue(float value, EnumOptions options) {
        return MathHelper.clamp_float((float)((this.snapToStepClamp(value, options) - options.getValueMin()) / (options.getValueMax() - options.getValueMin())), (float)0.0f, (float)1.0f);
    }

    @Override
    public float denormalizeValue(float value, EnumOptions options) {
        return this.snapToStepClamp(options.getValueMin() + (options.getValueMax() - options.getValueMin()) * MathHelper.clamp_float((float)value, (float)0.0f, (float)1.0f), options);
    }

    @Unique
    public float snapToStepClamp(float value, EnumOptions options) {
        value = this.snapToStep(value, options);
        return MathHelper.clamp_float((float)value, (float)options.getValueMin(), (float)options.getValueMax());
    }

    @Unique
    protected float snapToStep(float value, EnumOptions options) {
        if (options.getValueStep() > 0.0f) {
            value = options.getValueStep() * (float)Math.round(value / options.getValueStep());
        }
        return value;
    }

    @Override
    public float getValueMax() {
        return this.valueMax;
    }

    @Override
    public void setValueMax(float valueMax) {
        this.valueMax = valueMax;
    }

    @Override
    public float getValueMin() {
        return this.valueMin;
    }

    @Override
    public void setValueMin(float valueMin) {
        this.valueMin = valueMin;
    }

    @Override
    public float getValueStep() {
        return this.valueMin;
    }

    @Override
    public void setValueStep(float valueStep) {
        this.valueStep = valueStep;
    }
}

