/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.client.gui.video;

import moddedmite.xylose.bettergamesetting.client.EnumOptionsExtra;
import moddedmite.xylose.bettergamesetting.client.gui.video.GuiOptionsRowList;
import net.minecraft.EnumOptions;
import net.minecraft.GameSettings;
import net.minecraft.GuiButton;
import net.minecraft.GuiScreen;
import net.minecraft.I18n;
import net.minecraft.ScaledResolution;

public class GuiVideoSettings
extends GuiScreen {
    public GuiScreen parentGuiScreen;
    protected String screenTitle = "Video Settings";
    private GameSettings guiGameSettings;
    private GuiOptionsRowList optionsRowList;
    private static final EnumOptions[] videoOptions = new EnumOptions[]{EnumOptions.GRAPHICS, EnumOptions.RENDER_DISTANCE, EnumOptions.AMBIENT_OCCLUSION, EnumOptions.FRAMERATE_LIMIT, EnumOptions.ANAGLYPH, EnumOptions.VIEW_BOBBING, EnumOptions.GUI_SCALE, EnumOptions.ADVANCED_OPENGL, EnumOptions.GAMMA, EnumOptions.RENDER_CLOUDS, EnumOptions.PARTICLES, EnumOptions.USE_FULLSCREEN, EnumOptions.ENABLE_VSYNC, EnumOptionsExtra.TRANSPARENT_BACKGROUND, EnumOptionsExtra.HIGHLIGHT_BUTTON_TEXT};

    public GuiVideoSettings(GuiScreen guiScreen, GameSettings gameSettings) {
        this.parentGuiScreen = guiScreen;
        this.guiGameSettings = gameSettings;
    }

    public void initGui() {
        this.screenTitle = I18n.getString((String)"options.videoTitle");
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height - 27, I18n.getString((String)"gui.done")));
        this.optionsRowList = new GuiOptionsRowList(this.mc, this.width, this.height, 32, this.height - 32, 25, videoOptions);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled && button.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parentGuiScreen);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int l = this.guiGameSettings.guiScale;
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.optionsRowList.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.guiGameSettings.guiScale != l) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
            int i1 = scaledresolution.getScaledWidth();
            int j1 = scaledresolution.getScaledHeight();
            this.setWorldAndResolution(this.mc, i1, j1);
        }
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        int l = this.guiGameSettings.guiScale;
        super.mouseMovedOrUp(mouseX, mouseY, state);
        this.optionsRowList.mouseReleased(mouseX, mouseY, state);
        if (this.guiGameSettings.guiScale != l) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
            int i1 = scaledresolution.getScaledWidth();
            int j1 = scaledresolution.getScaledHeight();
            this.setWorldAndResolution(this.mc, i1, j1);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.optionsRowList.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 5, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

