/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.client.gui.resourcepack;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import moddedmite.xylose.bettergamesetting.api.IGuiSlot;
import moddedmite.xylose.bettergamesetting.api.IResourcePackRepository;
import moddedmite.xylose.bettergamesetting.client.gui.button.GuiOptionButton;
import moddedmite.xylose.bettergamesetting.client.gui.resourcepack.GuiResourcePackAvailable;
import moddedmite.xylose.bettergamesetting.client.gui.resourcepack.GuiResourcePackSelected;
import moddedmite.xylose.bettergamesetting.client.gui.resourcepack.ResourcePackListEntry;
import moddedmite.xylose.bettergamesetting.client.gui.resourcepack.ResourcePackListEntryDefault;
import moddedmite.xylose.bettergamesetting.client.gui.resourcepack.ResourcePackListEntryFound;
import net.minecraft.EnumOS;
import net.minecraft.GuiButton;
import net.minecraft.GuiScreen;
import net.minecraft.I18n;
import net.minecraft.ResourcePackRepository;
import net.minecraft.ResourcePackRepositoryEntry;
import net.minecraft.Util;
import org.lwjgl.Sys;

public class GuiScreenResourcePacks
extends GuiScreen {
    private static final Logger logger = Logger.getLogger("");
    private final GuiScreen parentScreen;
    private List availableResourcePacks;
    private List selectedResourcePacks;
    private GuiResourcePackAvailable availableResourcePacksList;
    private GuiResourcePackSelected selectedResourcePacksList;
    private boolean changed = false;

    public GuiScreenResourcePacks(GuiScreen parentScreenIn) {
        this.parentScreen = parentScreenIn;
    }

    public void initGui() {
        this.buttonList.add(new GuiOptionButton(2, this.width / 2 - 154, this.height - 48, I18n.getString((String)"resourcePack.openFolder")));
        this.buttonList.add(new GuiOptionButton(1, this.width / 2 + 4, this.height - 48, I18n.getString((String)"gui.done")));
        if (!this.changed) {
            this.availableResourcePacks = Lists.newArrayList();
            this.selectedResourcePacks = Lists.newArrayList();
            ResourcePackRepository resourcepackrepository = this.mc.getResourcePackRepository();
            resourcepackrepository.updateRepositoryEntriesAll();
            ArrayList list = Lists.newArrayList((Iterable)resourcepackrepository.getRepositoryEntriesAll());
            list.removeAll(resourcepackrepository.getRepositoryEntries());
            for (ResourcePackRepositoryEntry resourcepackrepository$entry : list) {
                this.availableResourcePacks.add(new ResourcePackListEntryFound(this, resourcepackrepository$entry));
            }
            for (Object o : Lists.reverse((List)resourcepackrepository.getRepositoryEntries())) {
                ResourcePackRepositoryEntry resourcepackrepository$entry1 = (ResourcePackRepositoryEntry)o;
                this.selectedResourcePacks.add(new ResourcePackListEntryFound(this, resourcepackrepository$entry1));
            }
        }
        this.selectedResourcePacks.add(new ResourcePackListEntryDefault(this));
        this.availableResourcePacksList = new GuiResourcePackAvailable(this.mc, 200, this.height, this.availableResourcePacks);
        ((IGuiSlot)((Object)this.availableResourcePacksList)).setSlotXBoundsFromLeft(this.width / 2 - 4 - 200);
        this.availableResourcePacksList.registerScrollButtons(7, 8);
        this.selectedResourcePacksList = new GuiResourcePackSelected(this.mc, 200, this.height, this.selectedResourcePacks);
        ((IGuiSlot)((Object)this.selectedResourcePacksList)).setSlotXBoundsFromLeft(this.width / 2 + 4);
        this.selectedResourcePacksList.registerScrollButtons(7, 8);
    }

    public boolean hasResourcePackEntry(ResourcePackListEntry resourcePackListEntry) {
        return this.selectedResourcePacks.contains(resourcePackListEntry);
    }

    public List<ResourcePackListEntry> getListContaining(ResourcePackListEntry resourcePackListEntry) {
        return this.hasResourcePackEntry(resourcePackListEntry) ? this.selectedResourcePacks : this.availableResourcePacks;
    }

    public List<ResourcePackListEntry> getAvailableResourcePacks() {
        return this.availableResourcePacks;
    }

    public List<ResourcePackListEntry> getSelectedResourcePacks() {
        return this.selectedResourcePacks;
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == 2) {
                File file1 = this.mc.getResourcePackRepository().getDirResourcepacks();
                String s = file1.getAbsolutePath();
                if (Util.getOSType() == EnumOS.MACOS) {
                    try {
                        logger.info(s);
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                        return;
                    }
                    catch (IOException ioexception1) {
                        logger.severe("Couldn't open file");
                        logger.severe(ioexception1.getMessage());
                    }
                } else if (Util.getOSType() == EnumOS.WINDOWS) {
                    String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
                    try {
                        Runtime.getRuntime().exec(s1);
                        return;
                    }
                    catch (IOException ioexception) {
                        logger.severe("Couldn't open file");
                        logger.severe(ioexception.getMessage());
                    }
                }
                boolean flag = false;
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, file1.toURI());
                }
                catch (Throwable throwable) {
                    logger.severe("Couldn't open link");
                    logger.severe(throwable.getMessage());
                    flag = true;
                }
                if (flag) {
                    logger.info("Opening via system class!");
                    Sys.openURL((String)("file://" + s));
                }
            } else if (button.id == 1) {
                if (this.changed) {
                    ArrayList list = Lists.newArrayList();
                    for (Object o : this.selectedResourcePacks) {
                        ResourcePackListEntry resourcepacklistentry = (ResourcePackListEntry)o;
                        if (!(resourcepacklistentry instanceof ResourcePackListEntryFound)) continue;
                        list.add(((ResourcePackListEntryFound)resourcepacklistentry).func_148318_i());
                    }
                    Collections.reverse(list);
                    ((IResourcePackRepository)this.mc.getResourcePackRepository()).setRepositories(list);
                    this.mc.gameSettings.getResourcePacks().clear();
                    this.mc.gameSettings.getIncompatibleResourcePacks().clear();
                    for (ResourcePackRepositoryEntry resourcepackrepository$entry : list) {
                        this.mc.gameSettings.getResourcePacks().add(resourcepackrepository$entry.getResourcePackName());
                        if (((IResourcePackRepository)resourcepackrepository$entry).getPackFormat() == 1) continue;
                        this.mc.gameSettings.getIncompatibleResourcePacks().add(resourcepackrepository$entry.getResourcePackName());
                    }
                    this.mc.gameSettings.saveOptions();
                    this.mc.refreshResources();
                }
                this.mc.displayGuiScreen(this.parentScreen);
            }
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.availableResourcePacksList.mouseClicked(mouseX, mouseY, mouseButton);
        this.selectedResourcePacksList.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        super.mouseMovedOrUp(mouseX, mouseY, state);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(0);
        this.availableResourcePacksList.drawScreen(mouseX, mouseY, partialTicks);
        this.selectedResourcePacksList.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRenderer, I18n.getString((String)"resourcePack.title"), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, I18n.getString((String)"resourcePack.folderInfo"), this.width / 2 - 77, this.height - 26, 0x808080);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    public void markChanged() {
        this.changed = true;
    }
}

