/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.client.gui.button;

import moddedmite.xylose.bettergamesetting.client.gui.button.GuiOptionSlider;
import net.minecraft.EnumOptions;
import net.minecraft.I18n;
import net.minecraft.MathHelper;
import net.minecraft.Minecraft;
import net.minecraft.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class GuiScaleSlider
extends GuiOptionSlider {
    public int sliderValue;
    public boolean dragging;
    public final EnumOptions options;
    private final int minValue;
    private final int maxValue;
    private Minecraft client;

    public GuiScaleSlider(int buttonId, int x, int y, EnumOptions optionIn, int minValueIn, int maxValue) {
        super(buttonId, x, y, optionIn);
        this.options = optionIn;
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.client = Minecraft.getMinecraft();
        this.sliderValue = MathHelper.clamp_int((int)this.client.gameSettings.guiScale, (int)minValueIn, (int)maxValue);
        this.displayString = this.getDisplayString(this.client);
    }

    @Override
    public int getHoverState(boolean mouseOver) {
        return 0;
    }

    @Override
    protected void mouseDragged(Minecraft client, int mouseX, int mouseY) {
        if (this.enabled) {
            if (this.dragging) {
                float index = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 10);
                this.sliderValue = Math.round(client.gameSettings.guiScale > this.maxValue ? (float)client.gameSettings.guiScale * index : (float)this.maxValue * index);
                this.sliderValue = MathHelper.clamp_int((int)this.sliderValue, (int)this.minValue, (int)this.maxValue);
                this.displayString = this.getDisplayString(client);
            }
            client.getTextureManager().bindTexture(buttonTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int renderX = Math.round(this.xPosition + this.sliderValue * (this.width / this.maxValue));
            renderX = Math.max(this.xPosition, renderX);
            renderX = Math.min(this.xPosition + this.width - 8, renderX);
            this.drawTexturedModalRect(renderX, this.yPosition, 0, 66, 4, 20);
            this.drawTexturedModalRect(renderX + 4, this.yPosition, 196, 66, 4, 20);
        }
    }

    public String getDisplayString(Minecraft client) {
        String ret = I18n.getString((String)"options.guiScale") + ": ";
        if (this.sliderValue == 0) {
            return ret + I18n.getString((String)"options.guiScale.auto");
        }
        return ret + this.sliderValue + "x";
    }

    @Override
    public boolean mousePressed(Minecraft client, int mouseX, int mouseY) {
        if (super.mousePressed(client, mouseX, mouseY)) {
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
        if (this.sliderValue != this.client.gameSettings.guiScale) {
            this.client.gameSettings.guiScale = this.sliderValue;
            ScaledResolution resolution = new ScaledResolution(this.client.gameSettings, this.client.displayWidth, this.client.displayHeight);
            int scaledWidth = resolution.getScaledWidth();
            int scaledHeight = resolution.getScaledHeight();
            this.client.currentScreen.setWorldAndResolution(this.client, scaledWidth, scaledHeight);
        }
    }
}

