/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.xylose.bettergamesetting.client.gui.button;

import java.util.ArrayList;
import net.minecraft.EnumOptions;
import net.minecraft.FontRenderer;
import net.minecraft.GuiButton;
import net.minecraft.I18n;
import net.minecraft.Minecraft;
import net.minecraft.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class GuiOptionSlider
extends GuiButton {
    float sliderValue = 1.0f;
    public boolean dragging;
    public EnumOptions options;
    private final float minValue;
    private final float maxValue;

    public GuiOptionSlider(int buttonId, int x, int y, EnumOptions optionIn) {
        this(buttonId, x, y, optionIn, 0.0f, 1.0f);
    }

    public GuiOptionSlider(int buttonId, int x, int y, EnumOptions optionIn, float minValueIn, float maxValueIn) {
        super(buttonId, x, y, 150, 20, "");
        this.options = optionIn;
        this.minValue = minValueIn;
        this.maxValue = maxValueIn;
        Minecraft minecraft = Minecraft.getMinecraft();
        this.sliderValue = this.options.normalizeValue(minecraft.gameSettings.getOptionFloatValue(optionIn), this.options);
        this.displayString = minecraft.gameSettings.getKeyBinding(optionIn);
    }

    public int getHoverState(boolean mouseOver) {
        return 0;
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (this.enabled) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                float f = this.options.denormalizeValue(this.sliderValue, this.options);
                mc.gameSettings.setOptionFloatValue(this.options, f);
                this.sliderValue = this.options.normalizeValue(f, this.options);
                this.displayString = mc.gameSettings.getKeyBinding(this.options);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            mc.gameSettings.setOptionFloatValue(this.options, this.options.denormalizeValue(this.sliderValue, this.options));
            this.displayString = mc.gameSettings.getKeyBinding(this.options);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseX <= this.xPosition + this.width && mouseY >= this.yPosition && mouseY <= this.yPosition + this.height;
    }

    public void drawTooltip(String text, int mouseX, int mouseY) {
        String transText = I18n.getString((String)text);
        if (transText == null) {
            return;
        }
        ScaledResolution res = new ScaledResolution(Minecraft.getMinecraft().gameSettings, Minecraft.getMinecraft().displayWidth, Minecraft.getMinecraft().displayHeight);
        int screenWidth = res.getScaledWidth();
        int screenHeight = res.getScaledHeight();
        FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
        int maxWidth = screenWidth - mouseX - 20;
        int lineHeight = fr.FONT_HEIGHT + 2;
        ArrayList lines = new ArrayList();
        for (String rawLine : transText.split("\n")) {
            lines.addAll(fr.listFormattedStringToWidth(rawLine, Math.min(maxWidth, 300)));
        }
        int tooltipWidth = lines.stream().mapToInt(arg_0 -> ((FontRenderer)fr).getStringWidth(arg_0)).max().orElse(0);
        int tooltipHeight = lines.size() * lineHeight;
        int adjustedX = mouseX + 12;
        int adjustedY = mouseY - 10;
        if (adjustedX + tooltipWidth + 6 > screenWidth) {
            adjustedX = screenWidth - tooltipWidth - 6 - 5;
        }
        if (adjustedY + tooltipHeight > screenHeight) {
            adjustedY = screenHeight - tooltipHeight - 5;
        }
        this.drawGradientRect(adjustedX - 3, adjustedY - 3, adjustedX + tooltipWidth + 3, adjustedY + tooltipHeight + 3, -1442840576, -1442840576);
        int yPos = adjustedY;
        for (String line : lines) {
            fr.drawStringWithShadow(line, adjustedX, yPos, 0xFFFFFF);
            yPos += lineHeight;
        }
    }
}

