/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.fontfixer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.GameSettings;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import net.minecraft.Tessellator;
import net.minecraft.TextureManager;
import org.lwjgl.opengl.GL11;

public class FontFixer {
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    public static String FIXER_VERSION = "1";
    private int[] charWidth = new int[Short.MAX_VALUE];
    public int fontTextureName = 0;
    public int FONT_HEIGHT = 9;
    public Random fontRandom = new Random();
    private byte[] glyphWidth = new byte[65536];
    private final int[] glyphTextureName = new int[256];
    public int[] colorCode = new int[32];
    private int boundTextureName;
    private final TextureManager renderEngine;
    private float posX;
    private float posY;
    private boolean unicodeFlag;
    private boolean bidiFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private int textColor;
    private boolean randomStyle = false;
    private boolean boldStyle = false;
    private boolean italicStyle = false;
    private boolean underlineStyle = false;
    private boolean strikethroughStyle = false;
    private final ResourceLocation locationFontTexture;
    public final String ASCII = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";

    public FontFixer(GameSettings gameSettings, ResourceLocation resourceLocation, TextureManager renderEngine, boolean unicodeFlag) {
        int var16;
        int var15;
        int var14;
        int var13;
        int var12;
        int var11;
        int var10;
        int var9;
        BufferedImage bufferedImage;
        this.locationFontTexture = resourceLocation;
        this.renderEngine = renderEngine;
        this.unicodeFlag = unicodeFlag;
        renderEngine.bindTexture(this.locationFontTexture);
        this.readGlyphSizes();
        try {
            bufferedImage = ImageIO.read(Minecraft.getMinecraft().getResourceManager().getResource(this.locationFontTexture).getInputStream());
        }
        catch (IOException var17) {
            throw new RuntimeException(var17);
        }
        int var19 = bufferedImage.getWidth();
        int var7 = bufferedImage.getHeight();
        int[] var8 = new int[var19 * var7];
        bufferedImage.getRGB(0, 0, var19, var7, var8, 0, var19);
        for (var9 = 0; var9 < 256; ++var9) {
            var10 = var9 % 16;
            var11 = var9 / 16;
            for (var12 = 7; var12 >= 0; --var12) {
                var13 = var10 * 8 + var12;
                var14 = 1;
                for (var15 = 0; var15 < 8 && var14 != 0; ++var15) {
                    var16 = (var11 * 8 + var15) * var19;
                    int var17 = var8[var13 + var16] & 0xFF;
                    if (var17 <= 0) continue;
                    var14 = 0;
                }
                if (var14 == 0) break;
            }
            if (var9 == 32) {
                var12 = 2;
            }
            this.charWidth[var9] = var12 + 2;
        }
        this.fontTextureName = 1;
        for (var9 = 0; var9 < 32; ++var9) {
            var10 = (var9 >> 3 & 1) * 85;
            var11 = (var9 >> 2 & 1) * 170 + var10;
            var12 = (var9 >> 1 & 1) * 170 + var10;
            var13 = (var9 & 1) * 170 + var10;
            if (var9 == 6) {
                var11 += 85;
            }
            if (gameSettings.anaglyph) {
                int var20 = (var11 * 30 + var12 * 59 + var13 * 11) / 100;
                var15 = (var11 * 30 + var12 * 70) / 100;
                var16 = (var11 * 30 + var13 * 70) / 100;
                var11 = var20;
                var12 = var15;
                var13 = var16;
            }
            if (var9 >= 16) {
                var11 /= 4;
                var12 /= 4;
                var13 /= 4;
            }
            this.colorCode[var9] = (var11 & 0xFF) << 16 | (var12 & 0xFF) << 8 | var13 & 0xFF;
        }
        for (var14 = 0; var14 < 32; ++var14) {
            int var6 = (var14 >> 3 & 1) * 85;
            int var20 = (var14 >> 2 & 1) * 170 + var6;
            int var21 = (var14 >> 1 & 1) * 170 + var6;
            int var22 = (var14 >> 0 & 1) * 170 + var6;
            if (var14 == 6) {
                var20 += 85;
            }
            if (gameSettings.anaglyph) {
                int var23 = (var20 * 30 + var21 * 59 + var22 * 11) / 100;
                int var24 = (var20 * 30 + var21 * 70) / 100;
                int var25 = (var20 * 30 + var22 * 70) / 100;
                var20 = var23;
                var21 = var24;
                var22 = var25;
            }
            if (var14 >= 16) {
                var20 /= 4;
                var21 /= 4;
                var22 /= 4;
            }
            this.colorCode[var14] = (var20 & 0xFF) << 16 | (var21 & 0xFF) << 8 | var22 & 0xFF;
        }
    }

    private void readGlyphSizes() {
        try {
            InputStream stream = Minecraft.getMinecraft().getResourceManager().getResource(new ResourceLocation("font/glyph_sizes.bin")).getInputStream();
            stream.read(this.glyphWidth);
            this.glyphWidth[65288] = 127;
        }
        catch (IOException var2) {
            throw new RuntimeException(var2);
        }
    }

    public float renderCharAtPos(int charWidth, char glyphWidth, boolean par3) {
        if (glyphWidth == ' ') {
            return 4.0f;
        }
        return this.ASCII.indexOf(glyphWidth) != -1 && !Minecraft.getMinecraft().gameSettings.isForceUnicodeFont() ? this.renderDefaultChar(charWidth, par3) : this.renderUnicodeChar(glyphWidth, par3);
    }

    private float renderDefaultChar(int par1, boolean par2) {
        float var3 = par1 % 16 * 8;
        float var4 = par1 / 16 * 8;
        float var5 = par2 ? 1.0f : 0.0f;
        this.renderEngine.bindTexture(this.locationFontTexture);
        float var6 = (float)this.charWidth[par1] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(var3 / 128.0f), (float)(var4 / 128.0f));
        GL11.glVertex3f((float)(this.posX + var5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(var3 / 128.0f), (float)((var4 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - var5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((var3 + var6) / 128.0f), (float)(var4 / 128.0f));
        GL11.glVertex3f((float)(this.posX + var6 + var5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((var3 + var6) / 128.0f), (float)((var4 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + var6 - var5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.charWidth[par1];
    }

    private ResourceLocation getUnicodePageLocation(int page) {
        if (unicodePageLocations[page] == null) {
            FontFixer.unicodePageLocations[page] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
        }
        return unicodePageLocations[page];
    }

    public final void loadGlyphTexture(int page) {
        this.renderEngine.bindTexture(this.getUnicodePageLocation(page));
    }

    private float renderUnicodeChar(char glyphWidth, boolean par2) {
        if (this.glyphWidth[glyphWidth] == 0) {
            return 0.0f;
        }
        int var3 = glyphWidth / 256;
        this.loadGlyphTexture(var3);
        int var4 = this.glyphWidth[glyphWidth] >>> 4;
        int var5 = this.glyphWidth[glyphWidth] & 0xF;
        float var6 = var4;
        float var7 = var5 + 1;
        float var8 = (float)(glyphWidth % 16 * 16) + var6;
        float var9 = (glyphWidth & 0xFF) / 16 * 16;
        float var10 = var7 - var6 - 0.02f;
        float var11 = par2 ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(var8 / 256.0f), (float)(var9 / 256.0f));
        GL11.glVertex3f((float)(this.posX + var11), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(var8 / 256.0f), (float)((var9 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX - var11), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((var8 + var10) / 256.0f), (float)(var9 / 256.0f));
        GL11.glVertex3f((float)(this.posX + var10 / 2.0f + var11), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((var8 + var10) / 256.0f), (float)((var9 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX + var10 / 2.0f - var11), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (var7 - var6) / 2.0f + 1.0f;
    }

    public int drawStringWithShadow(String text, int x, int y, int textColor) {
        return this.drawString(text, x, y, textColor, true);
    }

    public int drawString(String text, int x, int y, int textColor) {
        return this.drawString(text, x, y, textColor, false);
    }

    public int drawString(String text, int x, int y, int textColor, boolean shadow) {
        int length;
        GL11.glEnable((int)3008);
        this.resetStyles();
        if (this.bidiFlag) {
            text = this.bidiReorder(text);
        }
        if (shadow) {
            float shadowDeviation = Minecraft.getMinecraft().gameSettings.isForceUnicodeFont() ? 0.5f : 1.0f;
            length = this.renderString(text, (float)x + shadowDeviation, (float)y + shadowDeviation, textColor, true);
            length = Math.max(length, this.renderString(text, x, y, textColor, false));
        } else {
            length = this.renderString(text, x, y, textColor, false);
        }
        return length;
    }

    private String bidiReorder(String text) {
        if (text != null && Bidi.requiresBidi(text.toCharArray(), 0, text.length())) {
            int var7;
            Bidi var2 = new Bidi(text, -2);
            byte[] var3 = new byte[var2.getRunCount()];
            Object[] var4 = new String[var3.length];
            for (int var5 = 0; var5 < var3.length; ++var5) {
                int var6 = var2.getRunStart(var5);
                var7 = var2.getRunLimit(var5);
                int var8 = var2.getRunLevel(var5);
                String var9 = text.substring(var6, var7);
                var3[var5] = (byte)var8;
                var4[var5] = var9;
            }
            String[] var11 = (String[])var4.clone();
            Bidi.reorderVisually(var3, 0, var4, 0, var3.length);
            StringBuilder var12 = new StringBuilder();
            for (var7 = 0; var7 < var4.length; ++var7) {
                int var14;
                byte var13 = var3[var7];
                for (var14 = 0; var14 < var11.length; ++var14) {
                    if (!var11[var14].equals(var4[var7])) continue;
                    var13 = var3[var14];
                    break;
                }
                if ((var13 & 1) == 0) {
                    var12.append((String)var4[var7]);
                    continue;
                }
                for (var14 = ((String)var4[var7]).length() - 1; var14 >= 0; --var14) {
                    char var10 = ((String)var4[var7]).charAt(var14);
                    if (var10 == '(') {
                        var10 = ')';
                    } else if (var10 == ')') {
                        var10 = '(';
                    }
                    var12.append(var10);
                }
            }
            return var12.toString();
        }
        return text;
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    public void renderStringAtPos(String text, boolean shadow) {
        for (int charIndex = 0; charIndex < text.length(); ++charIndex) {
            Tessellator tessellator;
            boolean isUnicodeFlag;
            int colorIndex;
            char currentChar = text.charAt(charIndex);
            if (currentChar == '\u00a7' && charIndex + 1 < text.length()) {
                colorIndex = "0123456789abcdefklmnor".indexOf(text.toLowerCase().charAt(charIndex + 1));
                if (colorIndex < 16) {
                    int colorValue;
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    if (colorIndex < 0 || colorIndex > 15) {
                        colorIndex = 15;
                    }
                    if (shadow) {
                        colorIndex += 16;
                    }
                    this.textColor = colorValue = this.colorCode[colorIndex];
                    GL11.glColor4f((float)((float)(colorValue >> 16) / 255.0f), (float)((float)(colorValue >> 8 & 0xFF) / 255.0f), (float)((float)(colorValue & 0xFF) / 255.0f), (float)this.alpha);
                    charIndex = FontFixer.applyCustomFormatCodes(this, text, shadow, charIndex);
                } else if (colorIndex == 16) {
                    this.randomStyle = true;
                } else if (colorIndex == 17) {
                    this.boldStyle = true;
                } else if (colorIndex == 18) {
                    this.strikethroughStyle = true;
                } else if (colorIndex == 19) {
                    this.underlineStyle = true;
                } else if (colorIndex == 20) {
                    this.italicStyle = true;
                } else if (colorIndex == 21) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
                }
                ++charIndex;
                continue;
            }
            colorIndex = this.ASCII.indexOf(currentChar);
            if (this.randomStyle && colorIndex != -1) {
                int randomCharIndex;
                while (this.charWidth[colorIndex] != this.charWidth[randomCharIndex = this.fontRandom.nextInt(this.charWidth.length)]) {
                }
                colorIndex = randomCharIndex;
            }
            float charWidthFactor = colorIndex == -1 ? 0.5f : 1.0f;
            boolean bl = isUnicodeFlag = (currentChar == '\u0000' || colorIndex == -1) && shadow;
            if (isUnicodeFlag) {
                this.posX -= charWidthFactor;
                this.posY -= charWidthFactor;
            }
            float renderedWidth = this.renderCharAtPos(colorIndex, currentChar, this.italicStyle);
            if (isUnicodeFlag) {
                this.posX += charWidthFactor;
                this.posY += charWidthFactor;
            }
            if (this.boldStyle) {
                this.posX += charWidthFactor;
                if (isUnicodeFlag) {
                    this.posX -= charWidthFactor;
                    this.posY -= charWidthFactor;
                }
                this.renderCharAtPos(colorIndex, currentChar, this.italicStyle);
                this.posX -= charWidthFactor;
                if (isUnicodeFlag) {
                    this.posX += charWidthFactor;
                    this.posY += charWidthFactor;
                }
                renderedWidth += 1.0f;
            }
            if (this.strikethroughStyle) {
                tessellator = Tessellator.instance;
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.addVertex((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0);
                tessellator.addVertex((double)(this.posX + renderedWidth), (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0);
                tessellator.addVertex((double)(this.posX + renderedWidth), (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0);
                tessellator.addVertex((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            if (this.underlineStyle) {
                tessellator = Tessellator.instance;
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                int underlineOffset = this.underlineStyle ? -1 : 0;
                tessellator.addVertex((double)(this.posX + (float)underlineOffset), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0);
                tessellator.addVertex((double)(this.posX + renderedWidth), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0);
                tessellator.addVertex((double)(this.posX + renderedWidth), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0);
                tessellator.addVertex((double)(this.posX + (float)underlineOffset), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            this.posX += (float)((int)renderedWidth);
        }
    }

    public static int applyCustomFormatCodes(FontFixer subject, String text, boolean shadow, int i) {
        int next;
        if (text.charAt(i + 1) == 'x' && (next = text.indexOf(String.valueOf('\u00a7') + "x", i + 1)) != -1) {
            String s = text.substring(i + 1, next);
            int color = Integer.parseInt(s.replace(String.valueOf('\u00a7'), "").substring(1), 16);
            if (shadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            subject.textColor = color;
            GL11.glColor4f((float)((float)(color >> 16) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)subject.alpha);
            i += s.length() + 1;
        }
        return i;
    }

    private int renderStringAligned(String text, int x, int y, int width, int textColor, boolean shadow) {
        if (this.bidiFlag) {
            text = this.bidiReorder(text);
            int var7 = this.getStringWidth(text);
            x = x + width - var7;
        }
        return this.renderString(text, x, y, textColor, shadow);
    }

    private int renderString(String text, float x, float y, int textColor, boolean shadow) {
        if (text != null && this.bidiFlag) {
            text = this.bidiReorder(text);
        }
        if (text == null) {
            return 0;
        }
        this.boundTextureName = 0;
        if ((textColor & 0xFC000000) == 0) {
            textColor |= 0xFF000000;
        }
        if (shadow) {
            textColor = (textColor & 0xFCFCFC) >> 2 | textColor & 0xFF000000;
        }
        this.red = (float)(textColor >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(textColor >> 8 & 0xFF) / 255.0f;
        this.green = (float)(textColor & 0xFF) / 255.0f;
        this.alpha = (float)(textColor >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
        this.posX = x;
        this.posY = y;
        this.renderStringAtPos(text, shadow);
        return (int)this.posX;
    }

    public int getStringWidth(String text) {
        if (text == null) {
            return 0;
        }
        int var2 = 0;
        boolean var3 = false;
        for (int var4 = 0; var4 < text.length(); ++var4) {
            char var5 = text.charAt(var4);
            int var6 = this.getCharWidth(var5);
            if (var6 < 0 && var4 < text.length() - 1) {
                if ((var5 = text.charAt(++var4)) != 'l' && var5 != 'L') {
                    if (var5 == 'r' || var5 == 'R') {
                        var3 = false;
                    }
                } else {
                    var3 = true;
                }
                var6 = 0;
            }
            var2 += var6;
            if (!var3) continue;
            ++var2;
        }
        return var2;
    }

    public int getCharWidth(char glyphWidth) {
        if (glyphWidth == '\u00a7') {
            return -1;
        }
        if (glyphWidth == ' ') {
            return 4;
        }
        int var2 = this.ASCII.indexOf(glyphWidth);
        if (glyphWidth > '\u0000' && var2 != -1 && !Minecraft.getMinecraft().gameSettings.isForceUnicodeFont()) {
            return this.charWidth[var2];
        }
        if (this.glyphWidth[glyphWidth] != 0) {
            int var3 = this.glyphWidth[glyphWidth] >>> 4;
            int var4 = this.glyphWidth[glyphWidth] & 0xF;
            if (var4 > 7) {
                var4 = 15;
                var3 = 0;
            }
            return (++var4 - var3) / 2 + 1;
        }
        return 0;
    }

    public String trimStringToWidth(String text, int width) {
        return this.trimStringToWidth(text, width, false);
    }

    public String trimStringToWidth(String text, int width, boolean par3) {
        StringBuilder var4 = new StringBuilder();
        int var5 = 0;
        int var6 = par3 ? text.length() - 1 : 0;
        int var7 = par3 ? -1 : 1;
        boolean var8 = false;
        boolean var9 = false;
        for (int var10 = var6; var10 >= 0 && var10 < text.length() && var5 < width; var10 += var7) {
            char var11 = text.charAt(var10);
            int var12 = this.getCharWidth(var11);
            if (var8) {
                var8 = false;
                if (var11 != 'l' && var11 != 'L') {
                    if (var11 == 'r' || var11 == 'R') {
                        var9 = false;
                    }
                } else {
                    var9 = true;
                }
            } else if (var12 < 0) {
                var8 = true;
            } else {
                var5 += var12;
                if (var9) {
                    ++var5;
                }
            }
            if (var5 > width) break;
            if (par3) {
                var4.insert(0, var11);
                continue;
            }
            var4.append(var11);
        }
        return var4.toString();
    }

    private String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public void drawSplitString(String text, int x, int y, int width, int textColor) {
        this.resetStyles();
        this.textColor = textColor;
        text = this.trimStringNewline(text);
        this.renderSplitString(text, x, y, width, false);
    }

    private void renderSplitString(String text, int x, int y, int width, boolean shadow) {
        List textList = this.listFormattedStringToWidth(text, width);
        for (String var8 : textList) {
            this.renderStringAligned(var8, x, y, width, this.textColor, shadow);
            y += this.FONT_HEIGHT;
        }
    }

    public int splitStringWidth(String text, int width) {
        return this.FONT_HEIGHT * this.listFormattedStringToWidth(text, width).size();
    }

    public void setUnicodeFlag(boolean unicodeFlag) {
        this.unicodeFlag = unicodeFlag;
    }

    public boolean getUnicodeFlag() {
        return this.unicodeFlag;
    }

    public void setBidiFlag(boolean bidiFlag) {
        this.bidiFlag = bidiFlag;
    }

    public boolean getBidiFlag() {
        return this.bidiFlag;
    }

    public List listFormattedStringToWidth(String text, int width) {
        return Arrays.asList(this.wrapFormattedStringToWidth(text, width).split("\n"));
    }

    public String wrapFormattedStringToWidth(String text, int width) {
        int var3 = this.sizeStringToWidth(text, width);
        if (text.length() <= var3) {
            return text;
        }
        String var4 = text.substring(0, var3);
        char var5 = text.charAt(var3);
        boolean var6 = var5 == ' ' || var5 == '\n';
        String var7 = FontFixer.getFormatFromString(var4) + text.substring(var3 + (var6 ? 1 : 0));
        return var4 + "\n" + this.wrapFormattedStringToWidth(var7, width);
    }

    private int sizeStringToWidth(String text, int width) {
        int var5;
        int var3 = text.length();
        int var4 = 0;
        int var6 = -1;
        boolean var7 = false;
        for (var5 = 0; var5 < var3; ++var5) {
            char var8 = text.charAt(var5);
            switch (var8) {
                case '\n': {
                    --var5;
                    break;
                }
                case ' ': {
                    var6 = var5;
                }
                default: {
                    var4 += this.getCharWidth(var8);
                    if (!var7) break;
                    ++var4;
                    break;
                }
                case '\u00a7': {
                    char var9;
                    if (var5 >= var3 - 1) break;
                    if ((var9 = text.charAt(++var5)) != 'l' && var9 != 'L') {
                        if (var9 != 'r' && var9 != 'R' && !FontFixer.isFormatColor(var9)) break;
                        var7 = false;
                        break;
                    }
                    var7 = true;
                }
            }
            if (var8 == '\n') {
                var6 = ++var5;
                break;
            }
            if (var4 > width) break;
        }
        return var5 != var3 && var6 != -1 && var6 < var5 ? var6 : var5;
    }

    private static boolean isFormatColor(char textChar) {
        return textChar >= '0' && textChar <= '9' || textChar >= 'a' && textChar <= 'f' || textChar >= 'A' && textChar <= 'F';
    }

    private static boolean isFormatSpecial(char textChar) {
        return textChar >= 'k' && textChar <= 'o' || textChar >= 'K' && textChar <= 'O' || textChar == 'r' || textChar == 'R';
    }

    private static String getFormatFromString(String text) {
        StringBuilder var1 = new StringBuilder();
        int var2 = -1;
        int var3 = text.length();
        while ((var2 = text.indexOf(167, var2 + 1)) != -1) {
            if (var2 >= var3 - 1) continue;
            char var4 = text.charAt(var2 + 1);
            if (FontFixer.isFormatColor(var4)) {
                var1 = new StringBuilder("\u00a7" + var4);
                continue;
            }
            if (!FontFixer.isFormatSpecial(var4)) continue;
            var1.append("\u00a7").append(var4);
        }
        return var1.toString();
    }
}

