
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var e;e||(e=typeof Module !== 'undefined' ? Module : {});"use strict";
e.onRuntimeInitialized=function(){function a(l,m){switch(typeof m){case "boolean":ac(l,m?1:0);break;case "number":bc(l,m);break;case "string":cc(l,m,-1,-1);break;case "object":if(null===m)tb(l);else if(null!=m.length){var u=aa(m);dc(l,u,m.length,-1);da(u)}else Ga(l,"Wrong API use : tried to return a value of an unknown type ("+m+").",-1);break;default:tb(l)}}function b(l,m){for(var u=[],x=0;x<l;x+=1){var z=h(m+4*x,"i32"),E=ec(z);if(1===E||2===E)z=fc(z);else if(3===E)z=gc(z);else if(4===E){E=z;z=hc(E);
E=ic(E);for(var V=new Uint8Array(z),T=0;T<z;T+=1)V[T]=r[E+T];z=V}else z=null;u.push(z)}return u}function c(l,m){this.Oa=l;this.db=m;this.La=1;this.xb=[]}function d(l,m){this.db=m;m=ea(l)+1;this.mb=fa(m);if(null===this.mb)throw Error("Unable to allocate memory for the SQL string");ha(l,t,this.mb,m);this.ub=this.mb;this.jb=this.Gb=null}function f(l,m){this.filename=l||"dbfile_"+(4294967295*Math.random()>>>0);null!=m&&ia("/",this.filename,m,!0,!0);this.handleError(n(this.filename,g));this.db=h(g,"i32");
jc(this.db);this.pb={};this.Ra={}}var g=ja(4),k=e.cwrap,n=k("sqlite3_open","number",["string","number"]),y=k("sqlite3_close_v2","number",["number"]),p=k("sqlite3_exec","number",["number","string","number","number","number"]),A=k("sqlite3_changes","number",["number"]),q=k("sqlite3_prepare_v2","number",["number","string","number","number","number"]),C=k("sqlite3_sql","string",["number"]),N=k("sqlite3_normalized_sql","string",["number"]),K=k("sqlite3_prepare_v2","number",["number","number","number",
"number","number"]),O=k("sqlite3_bind_text","number",["number","number","number","number","number"]),L=k("sqlite3_bind_blob","number",["number","number","number","number","number"]),ba=k("sqlite3_bind_double","number",["number","number","number"]),la=k("sqlite3_bind_int","number",["number","number","number"]),ca=k("sqlite3_bind_parameter_index","number",["number","string"]),Za=k("sqlite3_step","number",["number"]),Q=k("sqlite3_errmsg","string",["number"]),kc=k("sqlite3_column_count","number",["number"]),
lc=k("sqlite3_data_count","number",["number"]),mc=k("sqlite3_column_double","number",["number","number"]),vb=k("sqlite3_column_text","string",["number","number"]),nc=k("sqlite3_column_blob","number",["number","number"]),oc=k("sqlite3_column_bytes","number",["number","number"]),pc=k("sqlite3_column_type","number",["number","number"]),qc=k("sqlite3_column_name","string",["number","number"]),rc=k("sqlite3_reset","number",["number"]),sc=k("sqlite3_clear_bindings","number",["number"]),tc=k("sqlite3_finalize",
"number",["number"]),wb=k("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),ec=k("sqlite3_value_type","number",["number"]),hc=k("sqlite3_value_bytes","number",["number"]),gc=k("sqlite3_value_text","string",["number"]),ic=k("sqlite3_value_blob","number",["number"]),fc=k("sqlite3_value_double","number",["number"]),bc=k("sqlite3_result_double","",["number","number"]),tb=k("sqlite3_result_null","",["number"]),cc=k("sqlite3_result_text",
"",["number","string","number","number"]),dc=k("sqlite3_result_blob","",["number","number","number","number"]),ac=k("sqlite3_result_int","",["number","number"]),Ga=k("sqlite3_result_error","",["number","string","number"]),xb=k("sqlite3_aggregate_context","number",["number","number"]),jc=k("RegisterExtensionFunctions","number",["number"]),uc=k("sqlite3_db_cacheflush","number",["number"]);c.prototype.bind=function(l){if(!this.Oa)throw"Statement closed";this.reset();return Array.isArray(l)?this.kc(l):
null!=l&&"object"===typeof l?this.lc(l):!0};c.prototype.step=function(){if(!this.Oa)throw"Statement closed";this.La=1;var l=Za(this.Oa);switch(l){case 100:return!0;case 101:return!1;default:throw this.db.handleError(l);}};c.prototype.Xb=function(l){null==l&&(l=this.La,this.La+=1);return mc(this.Oa,l)};c.prototype.rc=function(l){null==l&&(l=this.La,this.La+=1);l=vb(this.Oa,l);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(l)};c.prototype.uc=function(l){null==l&&
(l=this.La,this.La+=1);return vb(this.Oa,l)};c.prototype.getBlob=function(l){null==l&&(l=this.La,this.La+=1);var m=oc(this.Oa,l);l=nc(this.Oa,l);for(var u=new Uint8Array(m),x=0;x<m;x+=1)u[x]=r[l+x];return u};c.prototype.get=function(l,m){m=m||{};null!=l&&this.bind(l)&&this.step();l=[];for(var u=lc(this.Oa),x=0;x<u;x+=1)switch(pc(this.Oa,x)){case 1:var z=m.useBigInt?this.rc(x):this.Xb(x);l.push(z);break;case 2:l.push(this.Xb(x));break;case 3:l.push(this.uc(x));break;case 4:l.push(this.getBlob(x));
break;default:l.push(null)}return l};c.prototype.getColumnNames=function(){for(var l=[],m=kc(this.Oa),u=0;u<m;u+=1)l.push(qc(this.Oa,u));return l};c.prototype.getAsObject=function(l,m){l=this.get(l,m);m=this.getColumnNames();for(var u={},x=0;x<m.length;x+=1)u[m[x]]=l[x];return u};c.prototype.getSQL=function(){return C(this.Oa)};c.prototype.getNormalizedSQL=function(){return N(this.Oa)};c.prototype.run=function(l){null!=l&&this.bind(l);this.step();return this.reset()};c.prototype.Ob=function(l,m){null==
m&&(m=this.La,this.La+=1);l=ka(l);var u=aa(l);this.xb.push(u);this.db.handleError(O(this.Oa,m,u,l.length-1,0))};c.prototype.jc=function(l,m){null==m&&(m=this.La,this.La+=1);var u=aa(l);this.xb.push(u);this.db.handleError(L(this.Oa,m,u,l.length,0))};c.prototype.Nb=function(l,m){null==m&&(m=this.La,this.La+=1);this.db.handleError((l===(l|0)?la:ba)(this.Oa,m,l))};c.prototype.mc=function(l){null==l&&(l=this.La,this.La+=1);L(this.Oa,l,0,0,0)};c.prototype.Pb=function(l,m){null==m&&(m=this.La,this.La+=1);
switch(typeof l){case "string":this.Ob(l,m);return;case "number":this.Nb(l+0,m);return;case "bigint":this.Ob(l.toString(),m);return;case "boolean":this.Nb(l+0,m);return;case "object":if(null===l){this.mc(m);return}if(null!=l.length){this.jc(l,m);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+l+").";};c.prototype.lc=function(l){var m=this;Object.keys(l).forEach(function(u){var x=ca(m.Oa,u);0!==x&&m.Pb(l[u],x)});return!0};c.prototype.kc=function(l){for(var m=0;m<l.length;m+=
1)this.Pb(l[m],m+1);return!0};c.prototype.reset=function(){this.freemem();return 0===sc(this.Oa)&&0===rc(this.Oa)};c.prototype.freemem=function(){for(var l;void 0!==(l=this.xb.pop());)da(l)};c.prototype.free=function(){this.freemem();var l=0===tc(this.Oa);delete this.db.pb[this.Oa];this.Oa=0;return l};d.prototype.next=function(){if(null===this.mb)return{done:!0};null!==this.jb&&(this.jb.free(),this.jb=null);if(!this.db.db)throw this.yb(),Error("Database closed");var l=na(),m=ja(4);oa(g);oa(m);try{this.db.handleError(K(this.db.db,
this.ub,-1,g,m));this.ub=h(m,"i32");var u=h(g,"i32");if(0===u)return this.yb(),{done:!0};this.jb=new c(u,this.db);this.db.pb[u]=this.jb;return{value:this.jb,done:!1}}catch(x){throw this.Gb=pa(this.ub),this.yb(),x;}finally{qa(l)}};d.prototype.yb=function(){da(this.mb);this.mb=null};d.prototype.getRemainingSQL=function(){return null!==this.Gb?this.Gb:pa(this.ub)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});f.prototype.run=function(l,
m){if(!this.db)throw"Database closed";if(m){l=this.prepare(l,m);try{l.step()}finally{l.free()}}else this.handleError(p(this.db,l,0,0,g));return this};f.prototype.exec=function(l,m,u){if(!this.db)throw"Database closed";var x=na(),z=null;try{var E=ra(l),V=ja(4);for(l=[];0!==h(E,"i8");){oa(g);oa(V);this.handleError(K(this.db,E,-1,g,V));var T=h(g,"i32");E=h(V,"i32");if(0!==T){var S=null;z=new c(T,this);for(null!=m&&z.bind(m);z.step();)null===S&&(S={columns:z.getColumnNames(),values:[]},l.push(S)),S.values.push(z.get(null,
u));z.free()}}return l}catch(W){throw z&&z.free(),W;}finally{qa(x)}};f.prototype.each=function(l,m,u,x,z){"function"===typeof m&&(x=u,u=m,m=void 0);l=this.prepare(l,m);try{for(;l.step();)u(l.getAsObject(null,z))}finally{l.free()}if("function"===typeof x)return x()};f.prototype.prepare=function(l,m){oa(g);this.handleError(q(this.db,l,-1,g,0));l=h(g,"i32");if(0===l)throw"Nothing to prepare";var u=new c(l,this);null!=m&&u.bind(m);return this.pb[l]=u};f.prototype.iterateStatements=function(l){return new d(l,
this)};f.prototype["export"]=function(){Object.values(this.pb).forEach(function(m){m.free()});Object.values(this.Ra).forEach(sa);this.Ra={};this.handleError(y(this.db));var l=v.readFile(this.filename,{encoding:"binary"});this.handleError(n(this.filename,g));this.db=h(g,"i32");return l};f.prototype.close=function(){null!==this.db&&(Object.values(this.pb).forEach(function(l){l.free()}),Object.values(this.Ra).forEach(sa),this.Ra={},this.handleError(y(this.db)),this.db=null)};f.prototype.handleError=
function(l){if(0===l)return null;l=Q(this.db);throw Error(l);};f.prototype.getRowsModified=function(){return A(this.db)};f.prototype.create_function=function(l,m){Object.prototype.hasOwnProperty.call(this.Ra,l)&&(sa(this.Ra[l]),delete this.Ra[l]);var u=ta(function(x,z,E){z=b(z,E);try{var V=m.apply(null,z)}catch(T){Ga(x,T,-1);return}a(x,V)},"viii");this.Ra[l]=u;this.handleError(wb(this.db,l,m.length,1,0,u,0,0,0));return this};f.prototype.create_aggregate=function(l,m){var u=m.init||function(){return null},
x=m.finalize||function(S){return S},z=m.step;if(!z)throw"An aggregate function must have a step function in "+l;var E={};Object.hasOwnProperty.call(this.Ra,l)&&(sa(this.Ra[l]),delete this.Ra[l]);m=l+"__finalize";Object.hasOwnProperty.call(this.Ra,m)&&(sa(this.Ra[m]),delete this.Ra[m]);var V=ta(function(S,W,cb){var ma=xb(S,1);Object.hasOwnProperty.call(E,ma)||(E[ma]=u());W=b(W,cb);W=[E[ma]].concat(W);try{E[ma]=z.apply(null,W)}catch(vc){delete E[ma],Ga(S,vc,-1)}},"viii"),T=ta(function(S){var W=xb(S,
1);try{var cb=x(E[W])}catch(ma){delete E[W];Ga(S,ma,-1);return}a(S,cb);delete E[W]},"vi");this.Ra[l]=V;this.Ra[m]=T;this.handleError(wb(this.db,l,z.length-1,1,0,0,V,T,0));return this};f.prototype.flush=function(){if(!this.db)throw Error("Database closed");this.handleError(uc(this.db))};f.prototype.size=function(){this.flush();return v.stat(this.filename).size};e.Database=f};
var ua=Object.assign({},e),va="./this.program",wa="object"==typeof window,xa="function"==typeof importScripts,ya="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,w="",za,Aa,Ba;
if(ya){var fs=require("fs"),B=require("path");w=xa?B.dirname(w)+"/":__dirname+"/";za=(a,b)=>{a=a.startsWith("file://")?new URL(a):B.normalize(a);return fs.readFileSync(a,b?void 0:"utf8")};Ba=a=>{a=za(a,!0);a.buffer||(a=new Uint8Array(a));return a};Aa=(a,b,c,d=!0)=>{a=a.startsWith("file://")?new URL(a):B.normalize(a);fs.readFile(a,d?void 0:"utf8",(f,g)=>{f?c(f):b(d?g.buffer:g)})};!e.thisProgram&&1<process.argv.length&&(va=process.argv[1].replace(/\\/g,"/"));process.argv.slice(2);"undefined"!=typeof module&&
(module.exports=e);e.inspect=()=>"[Emscripten Module object]"}else if(wa||xa)xa?w=self.location.href:"undefined"!=typeof document&&document.currentScript&&(w=document.currentScript.src),w=0!==w.indexOf("blob:")?w.substr(0,w.replace(/[?#].*/,"").lastIndexOf("/")+1):"",za=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.send(null);return b.responseText},xa&&(Ba=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}),Aa=(a,b,c)=>
{var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=()=>{200==d.status||0==d.status&&d.response?b(d.response):c()};d.onerror=c;d.send(null)};var Ca=e.print||console.log.bind(console),Da=e.printErr||console.error.bind(console);Object.assign(e,ua);ua=null;e.thisProgram&&(va=e.thisProgram);var Ea;e.wasmBinary&&(Ea=e.wasmBinary);var noExitRuntime=e.noExitRuntime||!0;"object"!=typeof WebAssembly&&D("no native wasm support detected");var Fa,Ha=!1,r,t,Ia,F,G,Ja,Ka;
function La(){var a=Fa.buffer;e.HEAP8=r=new Int8Array(a);e.HEAP16=Ia=new Int16Array(a);e.HEAPU8=t=new Uint8Array(a);e.HEAPU16=new Uint16Array(a);e.HEAP32=F=new Int32Array(a);e.HEAPU32=G=new Uint32Array(a);e.HEAPF32=Ja=new Float32Array(a);e.HEAPF64=Ka=new Float64Array(a)}var Ma,Na=[],Oa=[],Pa=[];function Qa(){var a=e.preRun.shift();Na.unshift(a)}var Ra=0,Sa=null,Ta=null;function Ua(){Ra++;e.monitorRunDependencies&&e.monitorRunDependencies(Ra)}
function Va(){Ra--;e.monitorRunDependencies&&e.monitorRunDependencies(Ra);if(0==Ra&&(null!==Sa&&(clearInterval(Sa),Sa=null),Ta)){var a=Ta;Ta=null;a()}}function D(a){if(e.onAbort)e.onAbort(a);a="Aborted("+a+")";Da(a);Ha=!0;throw new WebAssembly.RuntimeError(a+". Build with -sASSERTIONS for more info.");}function Wa(a){return a.startsWith("data:application/octet-stream;base64,")}var Xa;Xa="sql-wasm.wasm";if(!Wa(Xa)){var Ya=Xa;Xa=e.locateFile?e.locateFile(Ya,w):w+Ya}
function $a(a){if(a==Xa&&Ea)return new Uint8Array(Ea);if(Ba)return Ba(a);throw"both async and sync fetching of the wasm failed";}function ab(a){if(!Ea&&(wa||xa)){if("function"==typeof fetch&&!a.startsWith("file://"))return fetch(a,{credentials:"same-origin"}).then(b=>{if(!b.ok)throw"failed to load wasm binary file at '"+a+"'";return b.arrayBuffer()}).catch(()=>$a(a));if(Aa)return new Promise((b,c)=>{Aa(a,d=>b(new Uint8Array(d)),c)})}return Promise.resolve().then(()=>$a(a))}
function bb(a,b,c){return ab(a).then(d=>WebAssembly.instantiate(d,b)).then(d=>d).then(c,d=>{Da(`failed to asynchronously prepare wasm: ${d}`);D(d)})}
function db(a,b){var c=Xa;Ea||"function"!=typeof WebAssembly.instantiateStreaming||Wa(c)||c.startsWith("file://")||ya||"function"!=typeof fetch?bb(c,a,b):fetch(c,{credentials:"same-origin"}).then(d=>WebAssembly.instantiateStreaming(d,a).then(b,function(f){Da(`wasm streaming compile failed: ${f}`);Da("falling back to ArrayBuffer instantiation");return bb(c,a,b)}))}var H,I,eb=a=>{for(;0<a.length;)a.shift()(e)};
function h(a,b="i8"){b.endsWith("*")&&(b="*");switch(b){case "i1":return r[a>>0];case "i8":return r[a>>0];case "i16":return Ia[a>>1];case "i32":return F[a>>2];case "i64":D("to do getValue(i64) use WASM_BIGINT");case "float":return Ja[a>>2];case "double":return Ka[a>>3];case "*":return G[a>>2];default:D(`invalid type for getValue: ${b}`)}}
function oa(a){var b="i32";b.endsWith("*")&&(b="*");switch(b){case "i1":r[a>>0]=0;break;case "i8":r[a>>0]=0;break;case "i16":Ia[a>>1]=0;break;case "i32":F[a>>2]=0;break;case "i64":D("to do setValue(i64) use WASM_BIGINT");case "float":Ja[a>>2]=0;break;case "double":Ka[a>>3]=0;break;case "*":G[a>>2]=0;break;default:D(`invalid type for setValue: ${b}`)}}
var fb="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0,J=(a,b,c)=>{var d=b+c;for(c=b;a[c]&&!(c>=d);)++c;if(16<c-b&&a.buffer&&fb)return fb.decode(a.subarray(b,c));for(d="";b<c;){var f=a[b++];if(f&128){var g=a[b++]&63;if(192==(f&224))d+=String.fromCharCode((f&31)<<6|g);else{var k=a[b++]&63;f=224==(f&240)?(f&15)<<12|g<<6|k:(f&7)<<18|g<<12|k<<6|a[b++]&63;65536>f?d+=String.fromCharCode(f):(f-=65536,d+=String.fromCharCode(55296|f>>10,56320|f&1023))}}else d+=String.fromCharCode(f)}return d},
pa=(a,b)=>a?J(t,a,b):"";function gb(){return B.join.apply(null,arguments)}var hb=(a,b)=>B.join(a,b),ib=()=>{if("object"==typeof crypto&&"function"==typeof crypto.getRandomValues)return c=>crypto.getRandomValues(c);if(ya)try{var a=require("crypto");if(a.randomFillSync)return c=>a.randomFillSync(c);var b=a.randomBytes;return c=>(c.set(b(c.byteLength)),c)}catch(c){}D("initRandomDevice")},jb=a=>(jb=ib())(a);
function kb(){var a=Array.prototype.slice.call(arguments,0);a.unshift(v.cwd());return B.posix.resolve.apply(null,a)}
var lb=[],ea=a=>{for(var b=0,c=0;c<a.length;++c){var d=a.charCodeAt(c);127>=d?b++:2047>=d?b+=2:55296<=d&&57343>=d?(b+=4,++c):b+=3}return b},ha=(a,b,c,d)=>{if(!(0<d))return 0;var f=c;d=c+d-1;for(var g=0;g<a.length;++g){var k=a.charCodeAt(g);if(55296<=k&&57343>=k){var n=a.charCodeAt(++g);k=65536+((k&1023)<<10)|n&1023}if(127>=k){if(c>=d)break;b[c++]=k}else{if(2047>=k){if(c+1>=d)break;b[c++]=192|k>>6}else{if(65535>=k){if(c+2>=d)break;b[c++]=224|k>>12}else{if(c+3>=d)break;b[c++]=240|k>>18;b[c++]=128|k>>
12&63}b[c++]=128|k>>6&63}b[c++]=128|k&63}}b[c]=0;return c-f};function ka(a,b){var c=Array(ea(a)+1);a=ha(a,c,0,c.length);b&&(c.length=a);return c}var mb=[];function nb(a,b){mb[a]={input:[],output:[],lb:b};ob(a,pb)}
var pb={open(a){var b=mb[a.node.rdev];if(!b)throw new v.Ha(43);a.tty=b;a.seekable=!1},close(a){a.tty.lb.fsync(a.tty)},fsync(a){a.tty.lb.fsync(a.tty)},read(a,b,c,d){if(!a.tty||!a.tty.lb.Yb)throw new v.Ha(60);for(var f=0,g=0;g<d;g++){try{var k=a.tty.lb.Yb(a.tty)}catch(n){throw new v.Ha(29);}if(void 0===k&&0===f)throw new v.Ha(6);if(null===k||void 0===k)break;f++;b[c+g]=k}f&&(a.node.timestamp=Date.now());return f},write(a,b,c,d){if(!a.tty||!a.tty.lb.Ib)throw new v.Ha(60);try{for(var f=0;f<d;f++)a.tty.lb.Ib(a.tty,
b[c+f])}catch(g){throw new v.Ha(29);}d&&(a.node.timestamp=Date.now());return f}},qb={Yb(){a:{if(!lb.length){var a=null;if(ya){a=Buffer.alloc(256);var b=0,c=process.stdin.fd;try{b=fs.readSync(c,a)}catch(d){if(d.toString().includes("EOF"))b=0;else throw d;}a=0<b?a.slice(0,b).toString("utf-8"):null}else"undefined"!=typeof window&&"function"==typeof window.prompt?(a=window.prompt("Input: "),null!==a&&(a+="\n")):"function"==typeof readline&&(a=readline(),null!==a&&(a+="\n"));if(!a){a=null;break a}lb=ka(a,
!0)}a=lb.shift()}return a},Ib(a,b){null===b||10===b?(Ca(J(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},fsync(a){a.output&&0<a.output.length&&(Ca(J(a.output,0)),a.output=[])},Oc(){return{Gc:25856,Ic:5,Fc:191,Hc:35387,Ec:[3,28,127,21,4,0,1,0,17,19,26,0,18,15,23,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}},Pc(){return 0},Qc(){return[24,80]}},rb={Ib(a,b){null===b||10===b?(Da(J(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},fsync(a){a.output&&0<a.output.length&&(Da(J(a.output,0)),a.output=[])}},ub=a=>
{a=65536*Math.ceil(a/65536);var b=sb(65536,a);b?(t.fill(0,b,b+a),a=b):a=0;return a};function yb(a,b){var c=a.Ka?a.Ka.length:0;c>=b||(b=Math.max(b,c*(1048576>c?2:1.125)>>>0),0!=c&&(b=Math.max(b,256)),c=a.Ka,a.Ka=new Uint8Array(b),0<a.Qa&&a.Ka.set(c.subarray(0,a.Qa),0))}
var M={ab:null,Pa(){return M.createNode(null,"/",16895,0)},createNode(a,b,c,d){if(24576===(c&61440)||v.isFIFO(c))throw new v.Ha(63);M.ab||(M.ab={dir:{node:{Wa:M.Ja.Wa,Sa:M.Ja.Sa,lookup:M.Ja.lookup,Xa:M.Ja.Xa,rename:M.Ja.rename,unlink:M.Ja.unlink,rmdir:M.Ja.rmdir,readdir:M.Ja.readdir,symlink:M.Ja.symlink},stream:{Ua:M.Ia.Ua}},file:{node:{Wa:M.Ja.Wa,Sa:M.Ja.Sa},stream:{Ua:M.Ia.Ua,read:M.Ia.read,write:M.Ia.write,kb:M.Ia.kb,Za:M.Ia.Za,bb:M.Ia.bb}},link:{node:{Wa:M.Ja.Wa,Sa:M.Ja.Sa,readlink:M.Ja.readlink},
stream:{}},Rb:{node:{Wa:M.Ja.Wa,Sa:M.Ja.Sa},stream:v.oc}});c=v.createNode(a,b,c,d);P(c.mode)?(c.Ja=M.ab.dir.node,c.Ia=M.ab.dir.stream,c.Ka={}):v.isFile(c.mode)?(c.Ja=M.ab.file.node,c.Ia=M.ab.file.stream,c.Qa=0,c.Ka=null):40960===(c.mode&61440)?(c.Ja=M.ab.link.node,c.Ia=M.ab.link.stream):8192===(c.mode&61440)&&(c.Ja=M.ab.Rb.node,c.Ia=M.ab.Rb.stream);c.timestamp=Date.now();a&&(a.Ka[b]=c,a.timestamp=c.timestamp);return c},Nc(a){return a.Ka?a.Ka.subarray?a.Ka.subarray(0,a.Qa):new Uint8Array(a.Ka):new Uint8Array(0)},
Ja:{Wa(a){var b={};b.dev=8192===(a.mode&61440)?a.id:1;b.ino=a.id;b.mode=a.mode;b.nlink=1;b.uid=0;b.gid=0;b.rdev=a.rdev;P(a.mode)?b.size=4096:v.isFile(a.mode)?b.size=a.Qa:b.size=40960===(a.mode&61440)?a.link.length:0;b.atime=new Date(a.timestamp);b.mtime=new Date(a.timestamp);b.ctime=new Date(a.timestamp);b.fb=4096;b.blocks=Math.ceil(b.size/b.fb);return b},Sa(a,b){void 0!==b.mode&&(a.mode=b.mode);void 0!==b.timestamp&&(a.timestamp=b.timestamp);if(void 0!==b.size&&(b=b.size,a.Qa!=b))if(0==b)a.Ka=null,
a.Qa=0;else{var c=a.Ka;a.Ka=new Uint8Array(b);c&&a.Ka.set(c.subarray(0,Math.min(b,a.Qa)));a.Qa=b}},lookup(){throw v.Ab[44];},Xa(a,b,c,d){return M.createNode(a,b,c,d)},rename(a,b,c){if(P(a.mode)){try{var d=zb(b,c)}catch(g){}if(d)for(var f in d.Ka)throw new v.Ha(55);}delete a.parent.Ka[a.name];a.parent.timestamp=Date.now();a.name=c;b.Ka[c]=a;b.timestamp=a.parent.timestamp;a.parent=b},unlink(a,b){delete a.Ka[b];a.timestamp=Date.now()},rmdir(a,b){var c=zb(a,b),d;for(d in c.Ka)throw new v.Ha(55);delete a.Ka[b];
a.timestamp=Date.now()},readdir(a){var b=[".",".."],c;for(c in a.Ka)a.Ka.hasOwnProperty(c)&&b.push(c);return b},symlink(a,b,c){a=M.createNode(a,b,41471,0);a.link=c;return a},readlink(a){if(40960!==(a.mode&61440))throw new v.Ha(28);return a.link}},Ia:{read(a,b,c,d,f){var g=a.node.Ka;if(f>=a.node.Qa)return 0;a=Math.min(a.node.Qa-f,d);if(8<a&&g.subarray)b.set(g.subarray(f,f+a),c);else for(d=0;d<a;d++)b[c+d]=g[f+d];return a},write(a,b,c,d,f,g){b.buffer===r.buffer&&(g=!1);if(!d)return 0;a=a.node;a.timestamp=
Date.now();if(b.subarray&&(!a.Ka||a.Ka.subarray)){if(g)return a.Ka=b.subarray(c,c+d),a.Qa=d;if(0===a.Qa&&0===f)return a.Ka=b.slice(c,c+d),a.Qa=d;if(f+d<=a.Qa)return a.Ka.set(b.subarray(c,c+d),f),d}yb(a,f+d);if(a.Ka.subarray&&b.subarray)a.Ka.set(b.subarray(c,c+d),f);else for(g=0;g<d;g++)a.Ka[f+g]=b[c+g];a.Qa=Math.max(a.Qa,f+d);return d},Ua(a,b,c){1===c?b+=a.position:2===c&&v.isFile(a.node.mode)&&(b+=a.node.Qa);if(0>b)throw new v.Ha(28);return b},kb(a,b,c){yb(a.node,b+c);a.node.Qa=Math.max(a.node.Qa,
b+c)},Za(a,b,c,d,f){if(!v.isFile(a.node.mode))throw new v.Ha(43);a=a.node.Ka;if(f&2||a.buffer!==r.buffer){if(0<c||c+b<a.length)a=a.subarray?a.subarray(c,c+b):Array.prototype.slice.call(a,c,c+b);c=!0;b=ub(b);if(!b)throw new v.Ha(48);r.set(a,b)}else c=!1,b=a.byteOffset;return{vb:b,rb:c}},bb(a,b,c,d){M.Ia.write(a,b,0,d,c,!1);return 0}}},Ab=(a,b,c)=>{var d=`al ${a}`;Aa(a,f=>{f||D(`Loading data file "${a}" failed (no arrayBuffer).`);b(new Uint8Array(f));d&&Va()},()=>{if(c)c();else throw`Loading data file "${a}" failed.`;
});d&&Ua()},Bb=e.preloadPlugins||[],Cb=(a,b,c,d)=>{"undefined"!=typeof Browser&&Browser.nb();var f=!1;Bb.forEach(g=>{!f&&g.canHandle(b)&&(g.handle(a,b,c,d),f=!0)});return f},Db=a=>{var b={r:0,"r+":2,w:577,"w+":578,a:1089,"a+":1090}[a];if("undefined"==typeof b)throw Error(`Unknown file open mode: ${a}`);return b},Eb=(a,b)=>{var c=0;a&&(c|=365);b&&(c|=146);return c},Fb={};function R(a){return Fb[a.code]}
function Gb(a){try{var b=fs.lstatSync(a);U.tb&&(b.mode|=(b.mode&292)>>2)}catch(c){if(!c.code)throw c;throw new v.Ha(R(c));}return b.mode}function X(a){for(var b=[];a.parent!==a;)b.push(a.name),a=a.parent;b.push(a.Pa.Hb.root);b.reverse();return gb.apply(null,b)}function Hb(a){a&=-2721793;var b=0,c;for(c in U.Vb)a&c&&(b|=U.Vb[c],a^=c);if(a)throw new v.Ha(28);return b}
var U={tb:!1,Mb(){U.tb=!!process.platform.match(/^win/);var a=process.binding("constants");a.fs&&(a=a.fs);U.Vb={1024:a.O_APPEND,64:a.O_CREAT,128:a.O_EXCL,256:a.O_NOCTTY,0:a.O_RDONLY,2:a.O_RDWR,4096:a.O_SYNC,512:a.O_TRUNC,1:a.O_WRONLY,131072:a.O_NOFOLLOW}},Pa(a){return U.createNode(null,"/",Gb(a.Hb.root),0)},createNode(a,b,c){if(!P(c)&&!v.isFile(c)&&40960!==(c&61440))throw new v.Ha(28);a=v.createNode(a,b,c);a.Ja=U.Ja;a.Ia=U.Ia;return a},Ja:{Wa(a){a=X(a);try{var b=fs.lstatSync(a)}catch(c){if(!c.code)throw c;
throw new v.Ha(R(c));}U.tb&&!b.fb&&(b.fb=4096);U.tb&&!b.blocks&&(b.blocks=(b.size+b.fb-1)/b.fb|0);return{dev:b.dev,ino:b.ino,mode:b.mode,nlink:b.nlink,uid:b.uid,gid:b.gid,rdev:b.rdev,size:b.size,atime:b.atime,mtime:b.mtime,ctime:b.ctime,fb:b.fb,blocks:b.blocks}},Sa(a,b){var c=X(a);try{void 0!==b.mode&&(fs.chmodSync(c,b.mode),a.mode=b.mode),void 0!==b.size&&fs.truncateSync(c,b.size)}catch(d){if(!d.code)throw d;throw new v.Ha(R(d));}},lookup(a,b){var c=hb(X(a),b);c=Gb(c);return U.createNode(a,b,c)},
Xa(a,b,c,d){a=U.createNode(a,b,c,d);b=X(a);try{P(a.mode)?fs.mkdirSync(b,a.mode):fs.writeFileSync(b,"",{mode:a.mode})}catch(f){if(!f.code)throw f;throw new v.Ha(R(f));}return a},rename(a,b,c){var d=X(a);b=hb(X(b),c);try{fs.renameSync(d,b)}catch(f){if(!f.code)throw f;throw new v.Ha(R(f));}a.name=c},unlink(a,b){a=hb(X(a),b);try{fs.unlinkSync(a)}catch(c){if(!c.code)throw c;throw new v.Ha(R(c));}},rmdir(a,b){a=hb(X(a),b);try{fs.rmdirSync(a)}catch(c){if(!c.code)throw c;throw new v.Ha(R(c));}},readdir(a){a=
X(a);try{return fs.readdirSync(a)}catch(b){if(!b.code)throw b;throw new v.Ha(R(b));}},symlink(a,b,c){a=hb(X(a),b);try{fs.symlinkSync(c,a)}catch(d){if(!d.code)throw d;throw new v.Ha(R(d));}},readlink(a){var b=X(a);try{return b=fs.readlinkSync(b),b=B.relative(B.resolve(a.Pa.Hb.root),b)}catch(c){if(!c.code)throw c;if("UNKNOWN"===c.code)throw new v.Ha(28);throw new v.Ha(R(c));}}},Ia:{open(a){var b=X(a.node);try{v.isFile(a.node.mode)&&(a.Ta=fs.openSync(b,Hb(a.flags)))}catch(c){if(!c.code)throw c;throw new v.Ha(R(c));
}},close(a){try{v.isFile(a.node.mode)&&a.Ta&&fs.closeSync(a.Ta)}catch(b){if(!b.code)throw b;throw new v.Ha(R(b));}},read(a,b,c,d,f){if(0===d)return 0;try{return fs.readSync(a.Ta,new Int8Array(b.buffer,c,d),{position:f})}catch(g){throw new v.Ha(R(g));}},write(a,b,c,d,f){try{return fs.writeSync(a.Ta,new Int8Array(b.buffer,c,d),{position:f})}catch(g){throw new v.Ha(R(g));}},Ua(a,b,c){if(1===c)b+=a.position;else if(2===c&&v.isFile(a.node.mode))try{b+=fs.fstatSync(a.Ta).size}catch(d){throw new v.Ha(R(d));
}if(0>b)throw new v.Ha(28);return b},Za(a,b,c){if(!v.isFile(a.node.mode))throw new v.Ha(43);var d=ub(b);U.Ia.read(a,r,d,b,c);return{vb:d,rb:!0}},bb(a,b,c,d){U.Ia.write(a,b,0,d,c,!1);return 0}}},Ib={lookup(a,b){return v.Na(`${a.path}/${b}`).node},Na(a,b={}){b.parent&&(a=B.dirname(a));b=fs.lstatSync(a);var c=Gb(a);return{path:a,node:{id:b.ino,mode:c,Ja:Ib,path:a}}},Sb(){v.gb({Ta:0,position:0,path:"",flags:0,tty:!0,seekable:!1},0);for(var a=1;3>a;a++)v.gb({Ta:a,position:0,path:"",flags:577,tty:!0,seekable:!1},
a)},cwd(){return process.cwd()},chdir(){process.chdir.apply(void 0,arguments)},Xa(a,b){P(a)?fs.mkdirSync(a,b):fs.writeFileSync(a,"",{mode:b})},mkdir(){fs.mkdirSync.apply(void 0,arguments)},symlink(){fs.symlinkSync.apply(void 0,arguments)},rename(){fs.renameSync.apply(void 0,arguments)},rmdir(){fs.rmdirSync.apply(void 0,arguments)},readdir(){return[".",".."].concat(fs.readdirSync.apply(void 0,arguments))},unlink(){fs.unlinkSync.apply(void 0,arguments)},readlink(){return fs.readlinkSync.apply(void 0,
arguments)},stat(){return fs.statSync.apply(void 0,arguments)},lstat(){return fs.lstatSync.apply(void 0,arguments)},chmod(){fs.chmodSync.apply(void 0,arguments)},fchmod(a,b){a=Y(a);fs.fchmodSync(a.Ta,b)},chown(){fs.chownSync.apply(void 0,arguments)},fchown(a,b,c){a=Y(a);fs.fchownSync(a.Ta,b,c)},truncate(){fs.truncateSync.apply(void 0,arguments)},Wb(a,b){if(0>b)throw new v.Ha(28);a=Y(a);fs.ftruncateSync(a.Ta,b)},dc(){},open(a,b,c){"string"==typeof b&&(b=Db(b));var d=a.split("/").map(function(g){return g.substr(0,
255)}).join("/");c=fs.openSync(d,Hb(b),c);var f=fs.fstatSync(c);if(b&65536&&!f.isDirectory())throw fs.closeSync(c),new v.Ha(Fb.Cc);d=Gb(d);return v.gb({Ta:c,position:0,path:a,flags:b,node:{id:f.ino,mode:d,Ja:Ib,path:a},seekable:!0})},gb(a,b){a=Jb.gb(a,b);"undefined"==typeof a.eb.Lb?a.eb.Lb=1:a.eb.Lb++;return a},close(a){v.streams[a.fd]=null;a.Ia||0!==--a.eb.Lb||fs.closeSync(a.Ta)},Ua(a,b,c){if(a.Ia)return Jb.Ua(a,b,c);if(1===c)b+=a.position;else if(2===c)b+=fs.fstatSync(a.Ta).size;else if(0!==c)throw new v.Ha(28);
if(0>b)throw new v.Ha(28);return a.position=b},read(a,b,c,d,f){if(a.Ia)return Jb.read(a,b,c,d,f);var g="undefined"!=typeof f;!g&&a.seekable&&(f=a.position);b=fs.readSync(a.Ta,new Int8Array(b.buffer,c,d),{position:f});g||(a.position+=b);return b},write(a,b,c,d,f){if(a.Ia)return Jb.write(a,b,c,d,f);a.flags&1024&&v.Ua(a,0,2);var g="undefined"!=typeof f;!g&&a.seekable&&(f=a.position);b=fs.writeSync(a.Ta,new Int8Array(b.buffer,c,d),{position:f});g||(a.position+=b);return b},kb(){throw new v.Ha(138);},
Za(a,b,c,d,f){if(a.Ia)return Jb.Za(a,b,c,d,f);d=ub(b);v.read(a,r,d,b,c);return{vb:d,rb:!0}},bb(a,b,c,d,f){if(a.Ia)return Jb.bb(a,b,c,d,f);v.write(a,b,0,d,c);return 0},xc(){return 0},Db(){throw new v.Ha(59);}};
function ia(a,b,c,d,f,g){var k=b;a&&(a="string"==typeof a?a:Kb(a),k=b?B.join(a,b):a);a=Eb(d,f);k=v.create(k,a);if(c){if("string"==typeof c){b=Array(c.length);d=0;for(f=c.length;d<f;++d)b[d]=c.charCodeAt(d);c=b}v.chmod(k,a|146);b=v.open(k,577);v.write(b,c,0,c.length,0,g);v.close(b);v.chmod(k,a)}}function ob(a,b){v.Ub[a]={Ia:b}}function P(a){return 16384===(a&61440)}
function zb(a,b){var c;if(c=(c=Lb(a,"x"))?c:a.Ja.lookup?0:2)throw new v.Ha(c,a);for(c=v.$a[Mb(a.id,b)];c;c=c.ib){var d=c.name;if(c.parent.id===a.id&&d===b)return c}return v.lookup(a,b)}function Y(a){a=v.tc(a);if(!a)throw new v.Ha(8);return a}function Kb(a){for(var b;;){if(v.ac(a))return a=a.Pa.bc,b?"/"!==a[a.length-1]?`${a}/${b}`:a+b:a;b=b?`${a.name}/${b}`:a.name;a=a.parent}}function Mb(a,b){for(var c=0,d=0;d<b.length;d++)c=(c<<5)-c+b.charCodeAt(d)|0;return(a+c>>>0)%v.$a.length}
function Nb(a){var b=Mb(a.parent.id,a.name);a.ib=v.$a[b];v.$a[b]=a}function Ob(a){var b=Mb(a.parent.id,a.name);if(v.$a[b]===a)v.$a[b]=a.ib;else for(b=v.$a[b];b;){if(b.ib===a){b.ib=a.ib;break}b=b.ib}}function Pb(a){var b=["r","w","rw"][a&3];a&512&&(b+="w");return b}function Lb(a,b){if(v.$b)return 0;if(!b.includes("r")||a.mode&292){if(b.includes("w")&&!(a.mode&146)||b.includes("x")&&!(a.mode&73))return 2}else return 2;return 0}function Qb(a,b){try{return zb(a,b),20}catch(c){}return Lb(a,"wx")}
function Rb(a,b,c){try{var d=zb(a,b)}catch(f){return f.Ma}if(a=Lb(a,"wx"))return a;if(c){if(!P(d.mode))return 54;if(v.ac(d)||Kb(d)===v.cwd())return 10}else if(P(d.mode))return 31;return 0}function Sb(){for(var a=0;a<=v.fc;a++)if(!v.streams[a])return a;throw new v.Ha(33);}function Tb(a){var b=[];for(a=[a];a.length;){var c=a.pop();b.push(c);a.push.apply(a,c.ob)}return b}function Ub(a,b,c){"undefined"==typeof c&&(c=b,b=438);return v.Xa(a,b|8192,c)}
function Vb(){v.mkdir("/dev");ob(v.hb(1,3),{read:()=>0,write:(d,f,g,k)=>k});Ub("/dev/null",v.hb(1,3));nb(v.hb(5,0),qb);nb(v.hb(6,0),rb);Ub("/dev/tty",v.hb(5,0));Ub("/dev/tty1",v.hb(6,0));var a=new Uint8Array(1024),b=0,c=()=>{0===b&&(b=jb(a).byteLength);return a[--b]};v.cb("/dev","random",c);v.cb("/dev","urandom",c);v.mkdir("/dev/shm");v.mkdir("/dev/shm/tmp")}
function Wb(){v.mkdir("/proc");var a=v.mkdir("/proc/self");v.mkdir("/proc/self/fd");v.Pa({Pa(){var b=v.createNode(a,"fd",16895,73);b.Ja={lookup(c,d){var f=Y(+d);c={parent:null,Pa:{bc:"fake"},Ja:{readlink:()=>f.path}};return c.parent=c}};return b}},{},"/proc/self/fd")}
function Xb(){v.Ha||(v.Ha=function(a,b){this.name="ErrnoError";this.node=b;this.Ac=function(c){this.Ma=c};this.Ac(a);this.message="FS error"},v.Ha.prototype=Error(),v.Ha.prototype.constructor=v.Ha,[44].forEach(a=>{v.Ab[a]=new v.Ha(a);v.Ab[a].stack="<generic error, no stack>"}))}function Yb(a,b,c,d){a=hb("string"==typeof a?a:Kb(a),b);return v.create(a,Eb(c,d))}
function Zb(a){if(!(a.vc||a.wc||a.link||a.Ka)){if("undefined"!=typeof XMLHttpRequest)throw Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");if(za)try{a.Ka=ka(za(a.url),!0),a.Qa=a.Ka.length}catch(b){throw new v.Ha(29);}else throw Error("Cannot load without read() or XMLHttpRequest.");}}
var v={root:null,ob:[],Ub:{},streams:[],yc:1,$a:null,Tb:"/",Cb:!1,$b:!0,Ha:null,Ab:{},qc:null,wb:0,Na(a,b={}){a=kb(a);if(!a)return{path:"",node:null};b=Object.assign({zb:!0,Kb:0},b);if(8<b.Kb)throw new v.Ha(32);a=a.split("/").filter(k=>!!k);for(var c=v.root,d="/",f=0;f<a.length;f++){var g=f===a.length-1;if(g&&b.parent)break;c=zb(c,a[f]);d=B.join(d,a[f]);c.Ya&&(!g||g&&b.zb)&&(c=c.Ya.root);if(!g||b.Va)for(g=0;40960===(c.mode&61440);)if(c=v.readlink(d),d=kb(B.dirname(d),c),c=v.Na(d,{Kb:b.Kb+1}).node,
40<g++)throw new v.Ha(32);}return{path:d,node:c}},createNode(a,b,c,d){a=new v.ec(a,b,c,d);Nb(a);return a},ac(a){return a===a.parent},isFile(a){return 32768===(a&61440)},isFIFO(a){return 4096===(a&61440)},isSocket(a){return 49152===(a&49152)},fc:4096,tc:a=>v.streams[a],gb(a,b=-1){v.qb||(v.qb=function(){this.eb={}},v.qb.prototype={},Object.defineProperties(v.qb.prototype,{object:{get(){return this.node},set(c){this.node=c}},flags:{get(){return this.eb.flags},set(c){this.eb.flags=c}},position:{get(){return this.eb.position},
set(c){this.eb.position=c}}}));a=Object.assign(new v.qb,a);-1==b&&(b=Sb());a.fd=b;return v.streams[b]=a},oc:{open(a){a.Ia=v.sc(a.node.rdev).Ia;a.Ia.open&&a.Ia.open(a)},Ua(){throw new v.Ha(70);}},Fb:a=>a>>8,Rc:a=>a&255,hb:(a,b)=>a<<8|b,sc:a=>v.Ub[a],cc(a,b){function c(k){v.wb--;return b(k)}function d(k){if(k){if(!d.pc)return d.pc=!0,c(k)}else++g>=f.length&&c(null)}"function"==typeof a&&(b=a,a=!1);v.wb++;1<v.wb&&Da(`warning: ${v.wb} FS.syncfs operations in flight at once, probably just doing extra work`);
var f=Tb(v.root.Pa),g=0;f.forEach(k=>{if(!k.type.cc)return d(null);k.type.cc(k,a,d)})},Pa(a,b,c){var d="/"===c,f=!c;if(d&&v.root)throw new v.Ha(10);if(!d&&!f){var g=v.Na(c,{zb:!1});c=g.path;g=g.node;if(g.Ya)throw new v.Ha(10);if(!P(g.mode))throw new v.Ha(54);}b={type:a,Hb:b,bc:c,ob:[]};a=a.Pa(b);a.Pa=b;b.root=a;d?v.root=a:g&&(g.Ya=b,g.Pa&&g.Pa.ob.push(b));return a},Uc(a){a=v.Na(a,{zb:!1});if(!a.node.Ya)throw new v.Ha(28);a=a.node;var b=a.Ya,c=Tb(b);Object.keys(v.$a).forEach(d=>{for(d=v.$a[d];d;){var f=
d.ib;c.includes(d.Pa)&&Ob(d);d=f}});a.Ya=null;a.Pa.ob.splice(a.Pa.ob.indexOf(b),1)},lookup(a,b){return a.Ja.lookup(a,b)},Xa(a,b,c){var d=v.Na(a,{parent:!0}).node;a=B.basename(a);if(!a||"."===a||".."===a)throw new v.Ha(28);var f=Qb(d,a);if(f)throw new v.Ha(f);if(!d.Ja.Xa)throw new v.Ha(63);return d.Ja.Xa(d,a,b,c)},create(a,b){return v.Xa(a,(void 0!==b?b:438)&4095|32768,0)},mkdir(a,b){return v.Xa(a,(void 0!==b?b:511)&1023|16384,0)},Sc(a,b){a=a.split("/");for(var c="",d=0;d<a.length;++d)if(a[d]){c+=
"/"+a[d];try{v.mkdir(c,b)}catch(f){if(20!=f.Ma)throw f;}}},symlink(a,b){if(!kb(a))throw new v.Ha(44);var c=v.Na(b,{parent:!0}).node;if(!c)throw new v.Ha(44);b=B.basename(b);var d=Qb(c,b);if(d)throw new v.Ha(d);if(!c.Ja.symlink)throw new v.Ha(63);return c.Ja.symlink(c,b,a)},rename(a,b){var c=B.dirname(a),d=B.dirname(b),f=B.basename(a),g=B.basename(b);var k=v.Na(a,{parent:!0});var n=k.node;k=v.Na(b,{parent:!0});k=k.node;if(!n||!k)throw new v.Ha(44);if(n.Pa!==k.Pa)throw new v.Ha(75);var y=zb(n,f);a=
B.posix.relative(a||v.cwd(),d||v.cwd());if("."!==a.charAt(0))throw new v.Ha(28);a=B.posix.relative(b||v.cwd(),c||v.cwd());if("."!==a.charAt(0))throw new v.Ha(55);try{var p=zb(k,g)}catch(A){}if(y!==p){b=P(y.mode);if(f=Rb(n,f,b))throw new v.Ha(f);if(f=p?Rb(k,g,b):Qb(k,g))throw new v.Ha(f);if(!n.Ja.rename)throw new v.Ha(63);if(y.Ya||p&&p.Ya)throw new v.Ha(10);if(k!==n&&(f=Lb(n,"w")))throw new v.Ha(f);Ob(y);try{n.Ja.rename(y,k,g)}catch(A){throw A;}finally{Nb(y)}}},rmdir(a){var b=v.Na(a,{parent:!0}).node;
a=B.basename(a);var c=zb(b,a),d=Rb(b,a,!0);if(d)throw new v.Ha(d);if(!b.Ja.rmdir)throw new v.Ha(63);if(c.Ya)throw new v.Ha(10);b.Ja.rmdir(b,a);Ob(c)},readdir(a){a=v.Na(a,{Va:!0}).node;if(!a.Ja.readdir)throw new v.Ha(54);return a.Ja.readdir(a)},unlink(a){var b=v.Na(a,{parent:!0}).node;if(!b)throw new v.Ha(44);a=B.basename(a);var c=zb(b,a),d=Rb(b,a,!1);if(d)throw new v.Ha(d);if(!b.Ja.unlink)throw new v.Ha(63);if(c.Ya)throw new v.Ha(10);b.Ja.unlink(b,a);Ob(c)},readlink(a){a=v.Na(a).node;if(!a)throw new v.Ha(44);
if(!a.Ja.readlink)throw new v.Ha(28);return kb(Kb(a.parent),a.Ja.readlink(a))},stat(a,b){a=v.Na(a,{Va:!b}).node;if(!a)throw new v.Ha(44);if(!a.Ja.Wa)throw new v.Ha(63);return a.Ja.Wa(a)},lstat(a){return v.stat(a,!0)},chmod(a,b,c){a="string"==typeof a?v.Na(a,{Va:!c}).node:a;if(!a.Ja.Sa)throw new v.Ha(63);a.Ja.Sa(a,{mode:b&4095|a.mode&-4096,timestamp:Date.now()})},lchmod(a,b){v.chmod(a,b,!0)},fchmod(a,b){a=Y(a);v.chmod(a.node,b)},chown(a,b,c,d){a="string"==typeof a?v.Na(a,{Va:!d}).node:a;if(!a.Ja.Sa)throw new v.Ha(63);
a.Ja.Sa(a,{timestamp:Date.now()})},lchown(a,b,c){v.chown(a,b,c,!0)},fchown(a,b,c){a=Y(a);v.chown(a.node,b,c)},truncate(a,b){if(0>b)throw new v.Ha(28);a="string"==typeof a?v.Na(a,{Va:!0}).node:a;if(!a.Ja.Sa)throw new v.Ha(63);if(P(a.mode))throw new v.Ha(31);if(!v.isFile(a.mode))throw new v.Ha(28);var c=Lb(a,"w");if(c)throw new v.Ha(c);a.Ja.Sa(a,{size:b,timestamp:Date.now()})},Wb(a,b){a=Y(a);if(0===(a.flags&2097155))throw new v.Ha(28);v.truncate(a.node,b)},dc(a,b,c){a=v.Na(a,{Va:!0}).node;a.Ja.Sa(a,
{timestamp:Math.max(b,c)})},open(a,b,c){if(""===a)throw new v.Ha(44);b="string"==typeof b?Db(b):b;c=b&64?("undefined"==typeof c?438:c)&4095|32768:0;if("object"==typeof a)var d=a;else{a=B.normalize(a);try{d=v.Na(a,{Va:!(b&131072)}).node}catch(g){}}var f=!1;if(b&64)if(d){if(b&128)throw new v.Ha(20);}else d=v.Xa(a,c,0),f=!0;if(!d)throw new v.Ha(44);8192===(d.mode&61440)&&(b&=-513);if(b&65536&&!P(d.mode))throw new v.Ha(54);if(!f&&(c=d?40960===(d.mode&61440)?32:P(d.mode)&&("r"!==Pb(b)||b&512)?31:Lb(d,
Pb(b)):44))throw new v.Ha(c);b&512&&!f&&v.truncate(d,0);b&=-131713;d=v.gb({node:d,path:Kb(d),flags:b,seekable:!0,position:0,Ia:d.Ia,Bc:[],error:!1});d.Ia.open&&d.Ia.open(d);!e.logReadFiles||b&1||(v.Jb||(v.Jb={}),a in v.Jb||(v.Jb[a]=1));return d},close(a){if(null===a.fd)throw new v.Ha(8);a.Bb&&(a.Bb=null);try{a.Ia.close&&a.Ia.close(a)}catch(b){throw b;}finally{v.streams[a.fd]=null}a.fd=null},Ua(a,b,c){if(null===a.fd)throw new v.Ha(8);if(!a.seekable||!a.Ia.Ua)throw new v.Ha(70);if(0!=c&&1!=c&&2!=c)throw new v.Ha(28);
a.position=a.Ia.Ua(a,b,c);a.Bc=[];return a.position},read(a,b,c,d,f){if(0>d||0>f)throw new v.Ha(28);if(null===a.fd)throw new v.Ha(8);if(1===(a.flags&2097155))throw new v.Ha(8);if(P(a.node.mode))throw new v.Ha(31);if(!a.Ia.read)throw new v.Ha(28);var g="undefined"!=typeof f;if(!g)f=a.position;else if(!a.seekable)throw new v.Ha(70);b=a.Ia.read(a,b,c,d,f);g||(a.position+=b);return b},write(a,b,c,d,f,g){if(0>d||0>f)throw new v.Ha(28);if(null===a.fd)throw new v.Ha(8);if(0===(a.flags&2097155))throw new v.Ha(8);
if(P(a.node.mode))throw new v.Ha(31);if(!a.Ia.write)throw new v.Ha(28);a.seekable&&a.flags&1024&&v.Ua(a,0,2);var k="undefined"!=typeof f;if(!k)f=a.position;else if(!a.seekable)throw new v.Ha(70);b=a.Ia.write(a,b,c,d,f,g);k||(a.position+=b);return b},kb(a,b,c){if(null===a.fd)throw new v.Ha(8);if(0>b||0>=c)throw new v.Ha(28);if(0===(a.flags&2097155))throw new v.Ha(8);if(!v.isFile(a.node.mode)&&!P(a.node.mode))throw new v.Ha(43);if(!a.Ia.kb)throw new v.Ha(138);a.Ia.kb(a,b,c)},Za(a,b,c,d,f){if(0!==(d&
2)&&0===(f&2)&&2!==(a.flags&2097155))throw new v.Ha(2);if(1===(a.flags&2097155))throw new v.Ha(2);if(!a.Ia.Za)throw new v.Ha(43);return a.Ia.Za(a,b,c,d,f)},bb(a,b,c,d,f){return a.Ia.bb?a.Ia.bb(a,b,c,d,f):0},xc:()=>0,Db(a,b,c){if(!a.Ia.Db)throw new v.Ha(59);return a.Ia.Db(a,b,c)},readFile(a,b={}){b.flags=b.flags||0;b.encoding=b.encoding||"binary";if("utf8"!==b.encoding&&"binary"!==b.encoding)throw Error(`Invalid encoding type "${b.encoding}"`);var c,d=v.open(a,b.flags);a=v.stat(a).size;var f=new Uint8Array(a);
v.read(d,f,0,a,0);"utf8"===b.encoding?c=J(f,0):"binary"===b.encoding&&(c=f);v.close(d);return c},writeFile(a,b,c={}){c.flags=c.flags||577;a=v.open(a,c.flags,c.mode);if("string"==typeof b){var d=new Uint8Array(ea(b)+1);b=ha(b,d,0,d.length);v.write(a,d,0,b,void 0,c.nc)}else if(ArrayBuffer.isView(b))v.write(a,b,0,b.byteLength,void 0,c.nc);else throw Error("Unsupported data type");v.close(a)},cwd:()=>v.Tb,chdir(a){a=v.Na(a,{Va:!0});if(null===a.node)throw new v.Ha(44);if(!P(a.node.mode))throw new v.Ha(54);
var b=Lb(a.node,"x");if(b)throw new v.Ha(b);v.Tb=a.path},Sb(){e.stdin?v.cb("/dev","stdin",e.stdin):v.symlink("/dev/tty","/dev/stdin");e.stdout?v.cb("/dev","stdout",null,e.stdout):v.symlink("/dev/tty","/dev/stdout");e.stderr?v.cb("/dev","stderr",null,e.stderr):v.symlink("/dev/tty1","/dev/stderr");v.open("/dev/stdin",0);v.open("/dev/stdout",1);v.open("/dev/stderr",1)},Mb(){Xb();v.$a=Array(4096);v.Pa(M,{},"/");v.mkdir("/tmp");v.mkdir("/home");v.mkdir("/home/web_user");Vb();Wb();v.qc={MEMFS:M,NODEFS:U}},
nb(a,b,c){v.nb.Cb=!0;Xb();e.stdin=a||e.stdin;e.stdout=b||e.stdout;e.stderr=c||e.stderr;v.Sb()},Tc(){v.nb.Cb=!1;for(var a=0;a<v.streams.length;a++){var b=v.streams[a];b&&v.close(b)}},Mc(a,b){try{var c=v.Na(a,{Va:!b});a=c.path}catch(g){}var d=!1,f=null;try{c=v.Na(a,{parent:!0}),B.basename(a),c=v.Na(a,{Va:!b}),d=!0,f=c.node}catch(g){}return d?f:null},Kc(a,b){a="string"==typeof a?a:Kb(a);for(b=b.split("/").reverse();b.length;){var c=b.pop();if(c){var d=B.join(a,c);try{v.mkdir(d)}catch(f){}a=d}}return d},
cb(a,b,c,d){a=hb("string"==typeof a?a:Kb(a),b);b=Eb(!!c,!!d);v.cb.Fb||(v.cb.Fb=64);var f=v.hb(v.cb.Fb++,0);ob(f,{open(g){g.seekable=!1},close(){d&&d.buffer&&d.buffer.length&&d(10)},read(g,k,n,y){for(var p=0,A=0;A<y;A++){try{var q=c()}catch(C){throw new v.Ha(29);}if(void 0===q&&0===p)throw new v.Ha(6);if(null===q||void 0===q)break;p++;k[n+A]=q}p&&(g.node.timestamp=Date.now());return p},write(g,k,n,y){for(var p=0;p<y;p++)try{d(k[n+p])}catch(A){throw new v.Ha(29);}y&&(g.node.timestamp=Date.now());return p}});
return Ub(a,b,f)},Jc(a,b,c,d,f){function g(){this.Eb=!1;this.sb=[]}function k(q,C,N,K,O){q=q.node.Ka;if(O>=q.length)return 0;K=Math.min(q.length-O,K);if(q.slice)for(var L=0;L<K;L++)C[N+L]=q[O+L];else for(L=0;L<K;L++)C[N+L]=q.get(O+L);return K}g.prototype.get=function(q){if(!(q>this.length-1||0>q)){var C=q%this.chunkSize;return this.Zb(q/this.chunkSize|0)[C]}};g.prototype.zc=function(q){this.Zb=q};g.prototype.Qb=function(){var q=new XMLHttpRequest;q.open("HEAD",c,!1);q.send(null);if(!(200<=q.status&&
300>q.status||304===q.status))throw Error("Couldn't load "+c+". Status: "+q.status);var C=Number(q.getResponseHeader("Content-length")),N,K=(N=q.getResponseHeader("Accept-Ranges"))&&"bytes"===N;q=(N=q.getResponseHeader("Content-Encoding"))&&"gzip"===N;var O=1048576;K||(O=C);var L=this;L.zc(ba=>{var la=ba*O,ca=(ba+1)*O-1;ca=Math.min(ca,C-1);if("undefined"==typeof L.sb[ba]){var Za=L.sb;if(la>ca)throw Error("invalid range ("+la+", "+ca+") or no bytes requested!");if(ca>C-1)throw Error("only "+C+" bytes available! programmer error!");
var Q=new XMLHttpRequest;Q.open("GET",c,!1);C!==O&&Q.setRequestHeader("Range","bytes="+la+"-"+ca);Q.responseType="arraybuffer";Q.overrideMimeType&&Q.overrideMimeType("text/plain; charset=x-user-defined");Q.send(null);if(!(200<=Q.status&&300>Q.status||304===Q.status))throw Error("Couldn't load "+c+". Status: "+Q.status);la=void 0!==Q.response?new Uint8Array(Q.response||[]):ka(Q.responseText||"",!0);Za[ba]=la}if("undefined"==typeof L.sb[ba])throw Error("doXHR failed!");return L.sb[ba]});if(q||!C)O=
C=1,O=C=this.Zb(0).length,Ca("LazyFiles on gzip forces download of the whole file when length is accessed");this.ic=C;this.hc=O;this.Eb=!0};if("undefined"!=typeof XMLHttpRequest){if(!xa)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var n=new g;Object.defineProperties(n,{length:{get:function(){this.Eb||this.Qb();return this.ic}},chunkSize:{get:function(){this.Eb||this.Qb();return this.hc}}});var y=void 0}else y=c,n=void 0;
var p=Yb(a,b,d,f);n?p.Ka=n:y&&(p.Ka=null,p.url=y);Object.defineProperties(p,{Qa:{get:function(){return this.Ka.length}}});var A={};Object.keys(p.Ia).forEach(q=>{var C=p.Ia[q];A[q]=function(){Zb(p);return C.apply(null,arguments)}});A.read=(q,C,N,K,O)=>{Zb(p);return k(q,C,N,K,O)};A.Za=(q,C,N)=>{Zb(p);var K=ub(C);if(!K)throw new v.Ha(48);k(q,r,K,C,N);return{vb:K,rb:!0}};p.Ia=A;return p}};
function $b(a,b,c){if(B.isAbsolute(b))return b;a=-100===a?v.cwd():Y(a).path;if(0==b.length){if(!c)throw new v.Ha(44);return a}return B.join(a,b)}
function wc(a,b,c){try{var d=a(b)}catch(g){if(g&&g.node&&B.normalize(b)!==B.normalize(Kb(g.node)))return-54;throw g;}F[c>>2]=d.dev;F[c+4>>2]=d.mode;G[c+8>>2]=d.nlink;F[c+12>>2]=d.uid;F[c+16>>2]=d.gid;F[c+20>>2]=d.rdev;I=[d.size>>>0,(H=d.size,1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[c+24>>2]=I[0];F[c+28>>2]=I[1];F[c+32>>2]=4096;F[c+36>>2]=d.blocks;a=d.atime.getTime();b=d.mtime.getTime();var f=d.ctime.getTime();I=[Math.floor(a/1E3)>>>0,(H=Math.floor(a/
1E3),1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[c+40>>2]=I[0];F[c+44>>2]=I[1];G[c+48>>2]=a%1E3*1E3;I=[Math.floor(b/1E3)>>>0,(H=Math.floor(b/1E3),1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[c+56>>2]=I[0];F[c+60>>2]=I[1];G[c+64>>2]=b%1E3*1E3;I=[Math.floor(f/1E3)>>>0,(H=Math.floor(f/1E3),1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[c+
72>>2]=I[0];F[c+76>>2]=I[1];G[c+80>>2]=f%1E3*1E3;I=[d.ino>>>0,(H=d.ino,1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[c+88>>2]=I[0];F[c+92>>2]=I[1];return 0}var xc=void 0;function yc(){var a=F[xc>>2];xc+=4;return a}
var zc=(a,b)=>b+2097152>>>0<4194305-!!a?(a>>>0)+4294967296*b:NaN,Ac=[0,31,60,91,121,152,182,213,244,274,305,335],Bc=[0,31,59,90,120,151,181,212,243,273,304,334],Cc=a=>{var b=ea(a)+1,c=fa(b);c&&ha(a,t,c,b);return c},Dc={},Fc=()=>{if(!Ec){var a={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:("object"==typeof navigator&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:va||"./this.program"},b;for(b in Dc)void 0===Dc[b]?delete a[b]:a[b]=Dc[b];
var c=[];for(b in a)c.push(`${b}=${a[b]}`);Ec=c}return Ec},Ec,Gc=void 0,Hc=[],ta=(a,b)=>{if(!Gc){Gc=new WeakMap;var c=Ma.length;if(Gc)for(var d=0;d<0+c;d++){var f=Ma.get(d);f&&Gc.set(f,d)}}if(c=Gc.get(a)||0)return c;if(Hc.length)c=Hc.pop();else{try{Ma.grow(1)}catch(n){if(!(n instanceof RangeError))throw n;throw"Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.";}c=Ma.length-1}try{Ma.set(c,a)}catch(n){if(!(n instanceof TypeError))throw n;if("function"==typeof WebAssembly.Function){d=WebAssembly.Function;
f={i:"i32",j:"i64",f:"f32",d:"f64",p:"i32"};for(var g={parameters:[],results:"v"==b[0]?[]:[f[b[0]]]},k=1;k<b.length;++k)g.parameters.push(f[b[k]]);b=new d(g,a)}else{d=[1];f=b.slice(0,1);b=b.slice(1);g={i:127,p:127,j:126,f:125,d:124};d.push(96);k=b.length;128>k?d.push(k):d.push(k%128|128,k>>7);for(k=0;k<b.length;++k)d.push(g[b[k]]);"v"==f?d.push(0):d.push(1,g[f]);b=[0,97,115,109,1,0,0,0,1];f=d.length;128>f?b.push(f):b.push(f%128|128,f>>7);b.push.apply(b,d);b.push(2,7,1,1,101,1,102,0,0,7,5,1,1,102,
0,0);b=new WebAssembly.Module(new Uint8Array(b));b=(new WebAssembly.Instance(b,{e:{f:a}})).exports.f}Ma.set(c,b)}Gc.set(a,c);return c},sa=a=>{Gc.delete(Ma.get(a));Hc.push(a)},aa=a=>{var b=fa(a.length);a.subarray||a.slice||(a=new Uint8Array(a));t.set(a,b);return b},ra=a=>{var b=ea(a)+1,c=ja(b);ha(a,t,c,b);return c},Ic=(a,b,c,d)=>{var f={string:p=>{var A=0;null!==p&&void 0!==p&&0!==p&&(A=ra(p));return A},array:p=>{var A=ja(p.length);r.set(p,A);return A}};a=e["_"+a];var g=[],k=0;if(d)for(var n=0;n<d.length;n++){var y=
f[c[n]];y?(0===k&&(k=na()),g[n]=y(d[n])):g[n]=d[n]}c=a.apply(null,g);return c=function(p){0!==k&&qa(k);return"string"===b?p?J(t,p):"":"boolean"===b?!!p:p}(c)};function Jc(a,b,c,d){a||(a=this);this.parent=a;this.Pa=a.Pa;this.Ya=null;this.id=v.yc++;this.name=b;this.mode=c;this.Ja={};this.Ia={};this.rdev=d}
Object.defineProperties(Jc.prototype,{read:{get:function(){return 365===(this.mode&365)},set:function(a){a?this.mode|=365:this.mode&=-366}},write:{get:function(){return 146===(this.mode&146)},set:function(a){a?this.mode|=146:this.mode&=-147}},wc:{get:function(){return P(this.mode)}},vc:{get:function(){return 8192===(this.mode&61440)}}});v.ec=Jc;
v.Lc=(a,b,c,d,f,g,k,n,y,p)=>{function A(C){function N(K){p&&p();n||ia(a,b,K,d,f,y);g&&g();Va()}Cb(C,q,N,()=>{k&&k();Va()})||N(C)}var q=b?kb(B.join(a,b)):a;Ua();"string"==typeof c?Ab(c,C=>A(C),k):A(c)};v.Mb();
Fb={EPERM:63,ENOENT:44,ESRCH:71,EINTR:27,EIO:29,ENXIO:60,E2BIG:1,ENOEXEC:45,EBADF:8,ECHILD:12,EAGAIN:6,EWOULDBLOCK:6,ENOMEM:48,EACCES:2,EFAULT:21,ENOTBLK:105,EBUSY:10,EEXIST:20,EXDEV:75,ENODEV:43,ENOTDIR:54,EISDIR:31,EINVAL:28,ENFILE:41,EMFILE:33,ENOTTY:59,ETXTBSY:74,EFBIG:22,ENOSPC:51,ESPIPE:70,EROFS:69,EMLINK:34,EPIPE:64,EDOM:18,ERANGE:68,ENOMSG:49,EIDRM:24,ECHRNG:106,EL2NSYNC:156,EL3HLT:107,EL3RST:108,ELNRNG:109,EUNATCH:110,ENOCSI:111,EL2HLT:112,EDEADLK:16,ENOLCK:46,EBADE:113,EBADR:114,EXFULL:115,
ENOANO:104,EBADRQC:103,EBADSLT:102,EDEADLOCK:16,EBFONT:101,ENOSTR:100,ENODATA:116,ETIME:117,ENOSR:118,ENONET:119,ENOPKG:120,EREMOTE:121,ENOLINK:47,EADV:122,ESRMNT:123,ECOMM:124,EPROTO:65,EMULTIHOP:36,EDOTDOT:125,EBADMSG:9,ENOTUNIQ:126,EBADFD:127,EREMCHG:128,ELIBACC:129,ELIBBAD:130,ELIBSCN:131,ELIBMAX:132,ELIBEXEC:133,ENOSYS:52,ENOTEMPTY:55,ENAMETOOLONG:37,ELOOP:32,EOPNOTSUPP:138,EPFNOSUPPORT:139,ECONNRESET:15,ENOBUFS:42,EAFNOSUPPORT:5,EPROTOTYPE:67,ENOTSOCK:57,ENOPROTOOPT:50,ESHUTDOWN:140,ECONNREFUSED:14,
EADDRINUSE:3,ECONNABORTED:13,ENETUNREACH:40,ENETDOWN:38,ETIMEDOUT:73,EHOSTDOWN:142,EHOSTUNREACH:23,EINPROGRESS:26,EALREADY:7,EDESTADDRREQ:17,EMSGSIZE:35,EPROTONOSUPPORT:66,ESOCKTNOSUPPORT:137,EADDRNOTAVAIL:4,ENETRESET:39,EISCONN:30,ENOTCONN:53,ETOOMANYREFS:141,EUSERS:136,EDQUOT:19,ESTALE:72,ENOTSUP:138,ENOMEDIUM:148,EILSEQ:25,EOVERFLOW:61,ECANCELED:11,ENOTRECOVERABLE:56,EOWNERDEAD:62,ESTRPIPE:135};var Jb;
if("browser"!==process.env.Dc){U.Mb();var Lc=function(){var a=Ib[Kc];return function(){try{return a.apply(this,arguments)}catch(b){if(b.code)throw new v.Ha(Fb[b.code]);throw b;}}};Jb=Object.assign({},v);for(var Kc in Ib)v[Kc]=Lc()}
var Nc={a:(a,b,c,d)=>{D(`Assertion failed: ${a?J(t,a):""}, at: `+[b?b?J(t,b):"":"unknown filename",c,d?d?J(t,d):"":"unknown function"])},h:function(a,b){try{return a=a?J(t,a):"",v.chmod(a,b),0}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return-c.Ma}},H:function(a,b,c){try{b=b?J(t,b):"";b=$b(a,b);if(c&-8)return-28;var d=v.Na(b,{Va:!0}).node;if(!d)return-44;a="";c&4&&(a+="r");c&2&&(a+="w");c&1&&(a+="x");return a&&Lb(d,a)?-2:0}catch(f){if("undefined"==typeof v||"ErrnoError"!==f.name)throw f;
return-f.Ma}},i:function(a,b){try{return v.fchmod(a,b),0}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return-c.Ma}},g:function(a,b,c){try{return v.fchown(a,b,c),0}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;return-d.Ma}},b:function(a,b,c){xc=c;try{var d=Y(a);switch(b){case 0:var f=yc();if(0>f)return-28;for(;v.streams[f];)f++;return v.gb(d,f).fd;case 1:case 2:return 0;case 3:return d.flags;case 4:return f=yc(),d.flags|=f,0;case 5:return f=yc(),Ia[f+0>>1]=2,
0;case 6:case 7:return 0;case 16:case 8:return-28;case 9:return F[Mc()>>2]=28,-1;default:return-28}}catch(g){if("undefined"==typeof v||"ErrnoError"!==g.name)throw g;return-g.Ma}},f:function(a,b){try{var c=Y(a);return wc(v.stat,c.path,b)}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;return-d.Ma}},n:function(a,b,c){b=zc(b,c);try{if(isNaN(b))return 61;v.Wb(a,b);return 0}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;return-d.Ma}},C:function(a,b){try{if(0===b)return-28;
var c=v.cwd(),d=ea(c)+1;if(b<d)return-68;ha(c,t,a,b);return d}catch(f){if("undefined"==typeof v||"ErrnoError"!==f.name)throw f;return-f.Ma}},F:function(a,b){try{return a=a?J(t,a):"",wc(v.lstat,a,b)}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return-c.Ma}},z:function(a,b,c){try{return b=b?J(t,b):"",b=$b(a,b),b=B.normalize(b),"/"===b[b.length-1]&&(b=b.substr(0,b.length-1)),v.mkdir(b,c,0),0}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;return-d.Ma}},E:function(a,
b,c,d){try{b=b?J(t,b):"";var f=d&256;b=$b(a,b,d&4096);return wc(f?v.lstat:v.stat,b,c)}catch(g){if("undefined"==typeof v||"ErrnoError"!==g.name)throw g;return-g.Ma}},y:function(a,b,c,d){xc=d;try{b=b?J(t,b):"";b=$b(a,b);var f=d?yc():0;return v.open(b,c,f).fd}catch(g){if("undefined"==typeof v||"ErrnoError"!==g.name)throw g;return-g.Ma}},w:function(a,b,c,d){try{b=b?J(t,b):"";b=$b(a,b);if(0>=d)return-28;var f=v.readlink(b),g=Math.min(d,ea(f)),k=r[c+g];ha(f,t,c,d+1);r[c+g]=k;return g}catch(n){if("undefined"==
typeof v||"ErrnoError"!==n.name)throw n;return-n.Ma}},v:function(a){try{return a=a?J(t,a):"",v.rmdir(a),0}catch(b){if("undefined"==typeof v||"ErrnoError"!==b.name)throw b;return-b.Ma}},G:function(a,b){try{return a=a?J(t,a):"",wc(v.stat,a,b)}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return-c.Ma}},r:function(a,b,c){try{return b=b?J(t,b):"",b=$b(a,b),0===c?v.unlink(b):512===c?v.rmdir(b):D("Invalid flags passed to unlinkat"),0}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;
return-d.Ma}},q:function(a,b,c){try{b=b?J(t,b):"";b=$b(a,b,!0);if(c){var d=G[c>>2]+4294967296*F[c+4>>2],f=F[c+8>>2];g=1E3*d+f/1E6;c+=16;d=G[c>>2]+4294967296*F[c+4>>2];f=F[c+8>>2];k=1E3*d+f/1E6}else var g=Date.now(),k=g;v.dc(b,g,k);return 0}catch(n){if("undefined"==typeof v||"ErrnoError"!==n.name)throw n;return-n.Ma}},l:function(a,b,c){a=new Date(1E3*zc(a,b));F[c>>2]=a.getSeconds();F[c+4>>2]=a.getMinutes();F[c+8>>2]=a.getHours();F[c+12>>2]=a.getDate();F[c+16>>2]=a.getMonth();F[c+20>>2]=a.getFullYear()-
1900;F[c+24>>2]=a.getDay();b=a.getFullYear();F[c+28>>2]=(0!==b%4||0===b%100&&0!==b%400?Bc:Ac)[a.getMonth()]+a.getDate()-1|0;F[c+36>>2]=-(60*a.getTimezoneOffset());b=(new Date(a.getFullYear(),6,1)).getTimezoneOffset();var d=(new Date(a.getFullYear(),0,1)).getTimezoneOffset();F[c+32>>2]=(b!=d&&a.getTimezoneOffset()==Math.min(d,b))|0},j:function(a,b,c,d,f,g,k,n){f=zc(f,g);try{if(isNaN(f))return 61;var y=Y(d),p=v.Za(y,a,f,b,c),A=p.vb;F[k>>2]=p.rb;G[n>>2]=A;return 0}catch(q){if("undefined"==typeof v||
"ErrnoError"!==q.name)throw q;return-q.Ma}},k:function(a,b,c,d,f,g,k){g=zc(g,k);try{if(isNaN(g))return 61;var n=Y(f);if(c&2){if(!v.isFile(n.node.mode))throw new v.Ha(43);if(!(d&2)){var y=t.slice(a,a+b);v.bb(n,y,g,b,d)}}}catch(p){if("undefined"==typeof v||"ErrnoError"!==p.name)throw p;return-p.Ma}},s:(a,b,c)=>{function d(y){return(y=y.toTimeString().match(/\(([A-Za-z ]+)\)$/))?y[1]:"GMT"}var f=(new Date).getFullYear(),g=new Date(f,0,1),k=new Date(f,6,1);f=g.getTimezoneOffset();var n=k.getTimezoneOffset();
G[a>>2]=60*Math.max(f,n);F[b>>2]=Number(f!=n);a=d(g);b=d(k);a=Cc(a);b=Cc(b);n<f?(G[c>>2]=a,G[c+4>>2]=b):(G[c>>2]=b,G[c+4>>2]=a)},d:()=>Date.now(),t:()=>2147483648,c:()=>performance.now(),o:a=>{var b=t.length;a>>>=0;if(2147483648<a)return!1;for(var c=1;4>=c;c*=2){var d=b*(1+.2/c);d=Math.min(d,a+100663296);var f=Math;d=Math.max(a,d);a:{f=(f.min.call(f,2147483648,d+(65536-d%65536)%65536)-Fa.buffer.byteLength+65535)/65536;try{Fa.grow(f);La();var g=1;break a}catch(k){}g=void 0}if(g)return!0}return!1},
A:(a,b)=>{var c=0;Fc().forEach((d,f)=>{var g=b+c;f=G[a+4*f>>2]=g;for(g=0;g<d.length;++g)r[f++>>0]=d.charCodeAt(g);r[f>>0]=0;c+=d.length+1});return 0},B:(a,b)=>{var c=Fc();G[a>>2]=c.length;var d=0;c.forEach(f=>d+=f.length+1);G[b>>2]=d;return 0},e:function(a){try{var b=Y(a);v.close(b);return 0}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return c.Ma}},p:function(a,b){try{var c=Y(a);r[b>>0]=c.tty?2:P(c.mode)?3:40960===(c.mode&61440)?7:4;Ia[b+2>>1]=0;I=[0,(H=0,1<=+Math.abs(H)?0<H?
+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[b+8>>2]=I[0];F[b+12>>2]=I[1];I=[0,(H=0,1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[b+16>>2]=I[0];F[b+20>>2]=I[1];return 0}catch(d){if("undefined"==typeof v||"ErrnoError"!==d.name)throw d;return d.Ma}},x:function(a,b,c,d){try{a:{var f=Y(a);a=b;for(var g,k=b=0;k<c;k++){var n=G[a>>2],y=G[a+4>>2];a+=8;var p=v.read(f,r,n,y,g);if(0>p){var A=-1;break a}b+=p;if(p<y)break;
"undefined"!==typeof g&&(g+=p)}A=b}G[d>>2]=A;return 0}catch(q){if("undefined"==typeof v||"ErrnoError"!==q.name)throw q;return q.Ma}},m:function(a,b,c,d,f){b=zc(b,c);try{if(isNaN(b))return 61;var g=Y(a);v.Ua(g,b,d);I=[g.position>>>0,(H=g.position,1<=+Math.abs(H)?0<H?+Math.floor(H/4294967296)>>>0:~~+Math.ceil((H-+(~~H>>>0))/4294967296)>>>0:0)];F[f>>2]=I[0];F[f+4>>2]=I[1];g.Bb&&0===b&&0===d&&(g.Bb=null);return 0}catch(k){if("undefined"==typeof v||"ErrnoError"!==k.name)throw k;return k.Ma}},D:function(a){try{var b=
Y(a);return b.Ia&&b.Ia.fsync?b.Ia.fsync(b):0}catch(c){if("undefined"==typeof v||"ErrnoError"!==c.name)throw c;return c.Ma}},u:function(a,b,c,d){try{a:{var f=Y(a);a=b;for(var g,k=b=0;k<c;k++){var n=G[a>>2],y=G[a+4>>2];a+=8;var p=v.write(f,r,n,y,g);if(0>p){var A=-1;break a}b+=p;"undefined"!==typeof g&&(g+=p)}A=b}G[d>>2]=A;return 0}catch(q){if("undefined"==typeof v||"ErrnoError"!==q.name)throw q;return q.Ma}}},Z=function(){function a(c){Z=c=c.exports;Fa=Z.I;La();Ma=Z.Ba;Oa.unshift(Z.J);Va();return c}
var b={a:Nc};Ua();if(e.instantiateWasm)try{return e.instantiateWasm(b,a)}catch(c){return Da(`Module.instantiateWasm callback failed with error: ${c}`),!1}db(b,function(c){a(c.instance)});return{}}();e._sqlite3_free=a=>(e._sqlite3_free=Z.K)(a);e._sqlite3_value_text=a=>(e._sqlite3_value_text=Z.L)(a);var Mc=()=>(Mc=Z.M)();e._sqlite3_prepare_v2=(a,b,c,d,f)=>(e._sqlite3_prepare_v2=Z.N)(a,b,c,d,f);e._sqlite3_step=a=>(e._sqlite3_step=Z.O)(a);e._sqlite3_finalize=a=>(e._sqlite3_finalize=Z.P)(a);
e._sqlite3_reset=a=>(e._sqlite3_reset=Z.Q)(a);e._sqlite3_clear_bindings=a=>(e._sqlite3_clear_bindings=Z.R)(a);e._sqlite3_value_blob=a=>(e._sqlite3_value_blob=Z.S)(a);e._sqlite3_value_bytes=a=>(e._sqlite3_value_bytes=Z.T)(a);e._sqlite3_value_double=a=>(e._sqlite3_value_double=Z.U)(a);e._sqlite3_value_int=a=>(e._sqlite3_value_int=Z.V)(a);e._sqlite3_value_type=a=>(e._sqlite3_value_type=Z.W)(a);e._sqlite3_result_blob=(a,b,c,d)=>(e._sqlite3_result_blob=Z.X)(a,b,c,d);
e._sqlite3_result_double=(a,b)=>(e._sqlite3_result_double=Z.Y)(a,b);e._sqlite3_result_error=(a,b,c)=>(e._sqlite3_result_error=Z.Z)(a,b,c);e._sqlite3_result_int=(a,b)=>(e._sqlite3_result_int=Z._)(a,b);e._sqlite3_result_int64=(a,b,c)=>(e._sqlite3_result_int64=Z.$)(a,b,c);e._sqlite3_result_null=a=>(e._sqlite3_result_null=Z.aa)(a);e._sqlite3_result_text=(a,b,c,d)=>(e._sqlite3_result_text=Z.ba)(a,b,c,d);e._sqlite3_aggregate_context=(a,b)=>(e._sqlite3_aggregate_context=Z.ca)(a,b);
e._sqlite3_column_count=a=>(e._sqlite3_column_count=Z.da)(a);e._sqlite3_data_count=a=>(e._sqlite3_data_count=Z.ea)(a);e._sqlite3_column_blob=(a,b)=>(e._sqlite3_column_blob=Z.fa)(a,b);e._sqlite3_column_bytes=(a,b)=>(e._sqlite3_column_bytes=Z.ga)(a,b);e._sqlite3_column_double=(a,b)=>(e._sqlite3_column_double=Z.ha)(a,b);e._sqlite3_column_text=(a,b)=>(e._sqlite3_column_text=Z.ia)(a,b);e._sqlite3_column_type=(a,b)=>(e._sqlite3_column_type=Z.ja)(a,b);
e._sqlite3_column_name=(a,b)=>(e._sqlite3_column_name=Z.ka)(a,b);e._sqlite3_bind_blob=(a,b,c,d,f)=>(e._sqlite3_bind_blob=Z.la)(a,b,c,d,f);e._sqlite3_bind_double=(a,b,c)=>(e._sqlite3_bind_double=Z.ma)(a,b,c);e._sqlite3_bind_int=(a,b,c)=>(e._sqlite3_bind_int=Z.na)(a,b,c);e._sqlite3_bind_text=(a,b,c,d,f)=>(e._sqlite3_bind_text=Z.oa)(a,b,c,d,f);e._sqlite3_bind_parameter_index=(a,b)=>(e._sqlite3_bind_parameter_index=Z.pa)(a,b);e._sqlite3_sql=a=>(e._sqlite3_sql=Z.qa)(a);
e._sqlite3_normalized_sql=a=>(e._sqlite3_normalized_sql=Z.ra)(a);e._sqlite3_errmsg=a=>(e._sqlite3_errmsg=Z.sa)(a);e._sqlite3_exec=(a,b,c,d,f)=>(e._sqlite3_exec=Z.ta)(a,b,c,d,f);e._sqlite3_db_cacheflush=a=>(e._sqlite3_db_cacheflush=Z.ua)(a);e._sqlite3_changes=a=>(e._sqlite3_changes=Z.va)(a);e._sqlite3_close_v2=a=>(e._sqlite3_close_v2=Z.wa)(a);e._sqlite3_create_function_v2=(a,b,c,d,f,g,k,n,y)=>(e._sqlite3_create_function_v2=Z.xa)(a,b,c,d,f,g,k,n,y);e._sqlite3_open=(a,b)=>(e._sqlite3_open=Z.ya)(a,b);
var fa=e._malloc=a=>(fa=e._malloc=Z.za)(a),da=e._free=a=>(da=e._free=Z.Aa)(a);e._RegisterExtensionFunctions=a=>(e._RegisterExtensionFunctions=Z.Ca)(a);var sb=(a,b)=>(sb=Z.Da)(a,b),na=()=>(na=Z.Ea)(),qa=a=>(qa=Z.Fa)(a),ja=a=>(ja=Z.Ga)(a);e.stackAlloc=ja;e.stackSave=na;e.stackRestore=qa;e.cwrap=(a,b,c,d)=>{var f=!c||c.every(g=>"number"===g||"boolean"===g);return"string"!==b&&f&&!d?e["_"+a]:function(){return Ic(a,b,c,arguments)}};e.UTF8ToString=pa;e.allocateUTF8OnStack=ra;var Oc;
Ta=function Pc(){Oc||Qc();Oc||(Ta=Pc)};
function Qc(){function a(){if(!Oc&&(Oc=!0,e.calledRun=!0,!Ha)){e.noFSInit||v.nb.Cb||v.nb();v.$b=!1;eb(Oa);if(e.onRuntimeInitialized)e.onRuntimeInitialized();if(e.postRun)for("function"==typeof e.postRun&&(e.postRun=[e.postRun]);e.postRun.length;){var b=e.postRun.shift();Pa.unshift(b)}eb(Pa)}}if(!(0<Ra)){if(e.preRun)for("function"==typeof e.preRun&&(e.preRun=[e.preRun]);e.preRun.length;)Qa();eb(Na);0<Ra||(e.setStatus?(e.setStatus("Running..."),setTimeout(function(){setTimeout(function(){e.setStatus("")},1);
a()},1)):a())}}if(e.preInit)for("function"==typeof e.preInit&&(e.preInit=[e.preInit]);0<e.preInit.length;)e.preInit.pop()();Qc();


        // The shell-pre.js and emcc-generated code goes above
        return Module;
    }); // The end of the promise being returned

  return initSqlJsPromise;
} // The end of our initSqlJs function

// This bit below is copied almost exactly from what you get when you use the MODULARIZE=1 flag with emcc
// However, we don't want to use the emcc modularization. See shell-pre.js
if (typeof exports === 'object' && typeof module === 'object'){
    module.exports = initSqlJs;
    // This will allow the module to be used in ES6 or CommonJS
    module.exports.default = initSqlJs;
}
else if (typeof define === 'function' && define['amd']) {
    define([], function() { return initSqlJs; });
}
else if (typeof exports === 'object'){
    exports["Module"] = initSqlJs;
}
