/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.extensibility.DefaultConvention;
import org.gradle.internal.extensibility.ExtraPropertiesDynamicObjectAdapter;
import org.gradle.internal.extensibility.MixInClosurePropertiesAsMethodsDynamicObject;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.CompositeDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.jspecify.annotations.Nullable;

public class ExtensibleDynamicObject
extends MixInClosurePropertiesAsMethodsDynamicObject
implements HasConvention {
    private final AbstractDynamicObject dynamicDelegate;
    private DynamicObject parent;
    private final Convention convention;
    private DynamicObject beforeConvention;
    private DynamicObject afterConvention;
    private final DynamicObject extraPropertiesDynamicObject;

    public ExtensibleDynamicObject(Object delegate, Class<?> publicType, InstanceGenerator instanceGenerator) {
        this(delegate, (AbstractDynamicObject)ExtensibleDynamicObject.createDynamicObject(delegate, publicType), new DefaultConvention(instanceGenerator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, InstanceGenerator instanceGenerator) {
        this(delegate, dynamicDelegate, new DefaultConvention(instanceGenerator));
    }

    public ExtensibleDynamicObject(Object delegate, AbstractDynamicObject dynamicDelegate, Convention convention) {
        this.dynamicDelegate = dynamicDelegate;
        this.convention = convention;
        this.extraPropertiesDynamicObject = new ExtraPropertiesDynamicObjectAdapter(delegate.getClass(), convention.getExtraProperties());
        this.updateDelegates();
    }

    private static BeanDynamicObject createDynamicObject(Object delegate, Class<?> publicType) {
        return new BeanDynamicObject(delegate, publicType);
    }

    private void updateDelegates() {
        DynamicObject[] delegates = new DynamicObject[6];
        delegates[0] = this.dynamicDelegate;
        delegates[1] = this.extraPropertiesDynamicObject;
        int idx = 2;
        if (this.beforeConvention != null) {
            delegates[idx++] = this.beforeConvention;
        }
        if (this.convention != null) {
            delegates[idx++] = this.convention.getExtensionsAsDynamicObject();
        }
        if (this.afterConvention != null) {
            delegates[idx++] = this.afterConvention;
        }
        boolean addedParent = false;
        if (this.parent != null) {
            addedParent = true;
            delegates[idx++] = this.parent;
        }
        DynamicObject[] objects = new DynamicObject[idx];
        System.arraycopy(delegates, 0, objects, 0, idx);
        this.setObjects(objects);
        if (addedParent) {
            objects = new DynamicObject[--idx];
            System.arraycopy(delegates, 0, objects, 0, idx);
            this.setObjectsForUpdate(objects);
        }
    }

    @Override
    public String getDisplayName() {
        return this.dynamicDelegate.getDisplayName();
    }

    @Override
    public @Nullable Class<?> getPublicType() {
        return this.dynamicDelegate.getPublicType();
    }

    @Override
    public boolean hasUsefulDisplayName() {
        return this.dynamicDelegate.hasUsefulDisplayName();
    }

    public ExtraPropertiesExtension getDynamicProperties() {
        return this.convention.getExtraProperties();
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public void setParent(DynamicObject parent) {
        this.parent = parent;
        this.updateDelegates();
    }

    @Override
    @Deprecated
    public Convention getConvention() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(Convention.class).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_access_to_conventions")).nagUser();
        return this.convention;
    }

    public void addObject(DynamicObject object, Location location) {
        switch (location) {
            case BeforeConvention: {
                this.beforeConvention = object;
                break;
            }
            case AfterConvention: {
                this.afterConvention = object;
            }
        }
        this.updateDelegates();
    }

    public DynamicObject getInheritable() {
        return new InheritedDynamicObject();
    }

    private DynamicObject snapshotInheritable() {
        final ArrayList<DynamicObject> delegates = new ArrayList<DynamicObject>(4);
        delegates.add(this.extraPropertiesDynamicObject);
        if (this.beforeConvention != null) {
            delegates.add(this.beforeConvention);
        }
        delegates.add(this.convention.getExtensionsAsDynamicObject());
        if (this.parent != null) {
            delegates.add(this.parent);
        }
        return new CompositeDynamicObject(){
            {
                this.setObjects(delegates.toArray(new DynamicObject[0]));
            }

            @Override
            public String getDisplayName() {
                return ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName();
            }
        };
    }

    public static enum Location {
        BeforeConvention,
        AfterConvention;

    }

    private class InheritedDynamicObject
    implements DynamicObject {
        private InheritedDynamicObject() {
        }

        public void setProperty(String name, @Nullable Object value) {
            throw new MissingPropertyException(String.format("Could not find property '%s' inherited from %s.", name, ExtensibleDynamicObject.this.dynamicDelegate.getDisplayName()));
        }

        public MissingPropertyException getMissingProperty(String name) {
            return ExtensibleDynamicObject.this.dynamicDelegate.getMissingProperty(name);
        }

        public MissingPropertyException setMissingProperty(String name) {
            return ExtensibleDynamicObject.this.dynamicDelegate.setMissingProperty(name);
        }

        public MissingMethodException methodMissingException(String name, Object ... params) {
            return ExtensibleDynamicObject.this.dynamicDelegate.methodMissingException(name, params);
        }

        public DynamicInvokeResult trySetProperty(String name, @Nullable Object value) {
            this.setProperty(name, value);
            return DynamicInvokeResult.found();
        }

        public DynamicInvokeResult trySetPropertyWithoutInstrumentation(String name, @Nullable Object value) {
            this.setProperty(name, value);
            return DynamicInvokeResult.found();
        }

        public boolean hasProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasProperty(name);
        }

        public Object getProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperty(name);
        }

        public DynamicInvokeResult tryGetProperty(String name) {
            return ExtensibleDynamicObject.this.snapshotInheritable().tryGetProperty(name);
        }

        public Map<String, ?> getProperties() {
            return ExtensibleDynamicObject.this.snapshotInheritable().getProperties();
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().hasMethod(name, arguments);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().tryInvokeMethod(name, arguments);
        }

        public Object invokeMethod(String name, Object ... arguments) {
            return ExtensibleDynamicObject.this.snapshotInheritable().invokeMethod(name, arguments);
        }
    }
}

