/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.reporting.listener;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorType;
import org.gradle.internal.instrumentation.reporting.listener.MethodInterceptionListener;
import org.gradle.internal.instrumentation.reporting.listener.OnInterceptedMethodInsFormatter;
import org.jspecify.annotations.Nullable;

class FileOutputMethodInterceptionListener
implements MethodInterceptionListener,
AutoCloseable {
    private final OnInterceptedMethodInsFormatter formatter;
    private final Writer writer;
    private final File source;

    public FileOutputMethodInterceptionListener(@Nullable File source, File output) {
        this.source = source;
        try {
            this.writer = new OutputStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.formatter = new OnInterceptedMethodInsFormatter();
    }

    @Override
    public void onInterceptedMethodInstruction(BytecodeInterceptorType type, String sourceFileName, String relativePath, String owner, String name, String descriptor, int lineNumber) {
        try {
            this.writer.write(this.formatter.format(this.source, sourceFileName, relativePath, owner, name, descriptor, lineNumber) + "\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

