/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.ConnectionFactory;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.gradle.tooling.internal.consumer.DefaultConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultProjectConnection;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ProjectConnectionCloseListener;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradleConnector
extends GradleConnector
implements ProjectConnectionCloseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleConnector.class);
    public static final GradleVersion MINIMUM_SUPPORTED_GRADLE_VERSION = GradleVersion.version((String)"4.0");
    private final ConnectionFactory connectionFactory;
    private final DistributionFactory distributionFactory;
    private Distribution distribution;
    private final List<DefaultProjectConnection> connections = new ArrayList<DefaultProjectConnection>(4);
    private boolean stopped = false;
    private final DefaultConnectionParameters.Builder connectionParamsBuilder = DefaultConnectionParameters.builder();

    public DefaultGradleConnector(ConnectionFactory connectionFactory, DistributionFactory distributionFactory) {
        this.connectionFactory = connectionFactory;
        this.distributionFactory = distributionFactory;
    }

    public static void close() {
        ConnectorServices.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ProjectConnection connection) {
        List<DefaultProjectConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        List<DefaultProjectConnection> list = this.connections;
        synchronized (list) {
            this.stopped = true;
            for (DefaultProjectConnection connection : this.connections) {
                connection.disconnect();
            }
            this.connections.clear();
        }
    }

    @Override
    public GradleConnector useInstallation(File gradleHome) {
        this.distribution = this.distributionFactory.getDistribution(gradleHome);
        return this;
    }

    @Override
    public GradleConnector useGradleVersion(String gradleVersion) {
        this.distribution = this.distributionFactory.getDistribution(gradleVersion);
        return this;
    }

    @Override
    public GradleConnector useDistribution(URI gradleDistribution) {
        this.distribution = this.distributionFactory.getDistribution(gradleDistribution);
        return this;
    }

    public GradleConnector useClasspathDistribution() {
        this.distribution = this.distributionFactory.getClasspathDistribution();
        return this;
    }

    @Override
    public GradleConnector useBuildDistribution() {
        this.distribution = null;
        return this;
    }

    public GradleConnector useDistributionBaseDir(File distributionBaseDir) {
        this.connectionParamsBuilder.setDistributionBaseDir(distributionBaseDir);
        return this;
    }

    @Override
    public GradleConnector forProjectDirectory(File projectDir) {
        this.connectionParamsBuilder.setProjectDir(projectDir);
        return this;
    }

    @Override
    public GradleConnector useGradleUserHomeDir(File gradleUserHomeDir) {
        this.connectionParamsBuilder.setGradleUserHomeDir(gradleUserHomeDir);
        return this;
    }

    public GradleConnector searchUpwards(boolean searchUpwards) {
        this.connectionParamsBuilder.setSearchUpwards(searchUpwards);
        return this;
    }

    public GradleConnector embedded(boolean embedded) {
        this.connectionParamsBuilder.setEmbedded(embedded);
        return this;
    }

    public GradleConnector daemonMaxIdleTime(int timeoutValue, TimeUnit timeoutUnits) {
        this.connectionParamsBuilder.setDaemonMaxIdleTimeValue(timeoutValue);
        this.connectionParamsBuilder.setDaemonMaxIdleTimeUnits(timeoutUnits);
        return this;
    }

    public GradleConnector daemonBaseDir(File daemonBaseDir) {
        this.connectionParamsBuilder.setDaemonBaseDir(daemonBaseDir);
        return this;
    }

    public DefaultGradleConnector setVerboseLogging(boolean verboseLogging) {
        this.connectionParamsBuilder.setVerboseLogging(verboseLogging);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectConnection connect() throws GradleConnectionException {
        LOGGER.debug("Connecting from tooling API consumer version {}", (Object)GradleVersion.current().getVersion());
        DefaultConnectionParameters connectionParameters = this.connectionParamsBuilder.build();
        if (connectionParameters.getProjectDir() == null) {
            throw new IllegalStateException("A project directory must be specified before creating a connection.");
        }
        if (this.distribution == null) {
            this.distribution = this.distributionFactory.getDefaultDistribution(connectionParameters.getProjectDir(), connectionParameters.isSearchUpwards() != null ? connectionParameters.isSearchUpwards() : true);
        }
        List<DefaultProjectConnection> list = this.connections;
        synchronized (list) {
            if (this.stopped) {
                throw new IllegalStateException("Tooling API client has been disconnected. No other connections may be used.");
            }
            ProjectConnection connection = this.connectionFactory.create(this.distribution, connectionParameters, this);
            this.connections.add((DefaultProjectConnection)connection);
            return connection;
        }
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

