/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.problems.failure.CompositeStackTraceClassifier;
import org.gradle.internal.problems.failure.DefaultFailure;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.internal.problems.failure.InternalStackTraceClassifier;
import org.gradle.internal.problems.failure.StackTraceClassifier;
import org.gradle.internal.problems.failure.StackTraceRelevance;
import org.gradle.util.internal.CollectionUtils;

public class DefaultFailureFactory
implements FailureFactory {
    private final StackTraceClassifier stackTraceClassifier;

    public static DefaultFailureFactory withDefaultClassifier() {
        return new DefaultFailureFactory(new CompositeStackTraceClassifier(new InternalStackTraceClassifier(), StackTraceClassifier.USER_CODE));
    }

    public DefaultFailureFactory(StackTraceClassifier stackTraceClassifier) {
        this.stackTraceClassifier = stackTraceClassifier;
    }

    public Failure create(Throwable failure) {
        return new Job(this.stackTraceClassifier).convert(failure);
    }

    private static final class Job {
        private final StackTraceClassifier stackTraceClassifier;
        private final Set<Throwable> seen = Collections.newSetFromMap(new IdentityHashMap());
        private final InternalTransformer<Failure, Throwable> recursiveConverter = new InternalTransformer<Failure, Throwable>(){

            public Failure transform(Throwable throwable) {
                return this.convertRecursively(throwable);
            }
        };

        private Job(StackTraceClassifier stackTraceClassifier) {
            this.stackTraceClassifier = stackTraceClassifier;
        }

        public Failure convert(Throwable failure) {
            return this.convertRecursively(failure);
        }

        private Failure convertRecursively(Throwable failure) {
            if (!this.seen.add(failure)) {
                Throwable replacement = new Throwable("[CIRCULAR REFERENCE: " + failure + "]");
                replacement.setStackTrace(failure.getStackTrace());
                failure = replacement;
            }
            ImmutableList stackTrace = ImmutableList.copyOf((Object[])failure.getStackTrace());
            List<StackTraceRelevance> relevances = Job.classify((List<StackTraceElement>)stackTrace, this.stackTraceClassifier);
            List<Failure> suppressed = this.convertSuppressed(failure);
            List<Failure> causes = this.convertCauses(failure);
            return new DefaultFailure(failure, (List<StackTraceElement>)stackTrace, relevances, suppressed, causes);
        }

        private List<Failure> convertSuppressed(Throwable parent) {
            if (!JavaVersion.current().isJava7Compatible()) {
                return ImmutableList.of();
            }
            return CollectionUtils.collect((Object[])parent.getSuppressed(), this.recursiveConverter);
        }

        private List<Failure> convertCauses(Throwable parent) {
            ImmutableList.Builder causes = new ImmutableList.Builder();
            if (parent instanceof MultiCauseException) {
                causes.addAll((Iterable)((MultiCauseException)parent).getCauses());
            } else if (parent.getCause() != null) {
                causes.add((Object)parent.getCause());
            }
            return CollectionUtils.collect((Iterable)causes.build(), this.recursiveConverter);
        }

        private static List<StackTraceRelevance> classify(List<StackTraceElement> stackTrace, StackTraceClassifier classifier) {
            ArrayList<StackTraceRelevance> relevance = new ArrayList<StackTraceRelevance>(stackTrace.size());
            for (StackTraceElement stackTraceElement : stackTrace) {
                StackTraceRelevance r = classifier.classify(stackTraceElement);
                if (r == null) {
                    throw new GradleException("Unable to classify stack trace element: " + stackTraceElement);
                }
                relevance.add(r);
            }
            return relevance;
        }
    }
}

