/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DeprecationDataSpec;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.featurelifecycle.DefaultDeprecatedUsageProgressDetails;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.StackTraceSanitizer;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.util.internal.DefaultGradleVersion;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDeprecatedFeatureHandler
implements FeatureHandler<DeprecatedFeatureUsage> {
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";
    public static final String WARNING_SUMMARY = "Deprecated Gradle features were used in this build, making it incompatible with Gradle";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingDeprecatedFeatureHandler.class);
    private static final String ELEMENT_PREFIX = "\tat ";
    private static final String RUN_WITH_STACKTRACE_INFO = "\t(Run with --stacktrace to get the full stack trace of this deprecation warning.)";
    private static boolean traceLoggingEnabled;
    private final Set<String> loggedMessages = new CopyOnWriteArraySet<String>();
    private final Set<String> loggedUsages = new CopyOnWriteArraySet<String>();
    private boolean deprecationsFound = false;
    private ProblemStream problemStream = NoOpProblemDiagnosticsFactory.EMPTY_STREAM;
    private WarningMode warningMode = WarningMode.Summary;
    private BuildOperationProgressEventEmitter progressEventEmitter;
    private Problems problemsService;
    private GradleException error;

    public void init(WarningMode warningMode, BuildOperationProgressEventEmitter progressEventEmitter, Problems problemsService, ProblemStream problemStream) {
        this.warningMode = warningMode;
        this.problemStream = problemStream;
        this.progressEventEmitter = progressEventEmitter;
        this.problemsService = problemsService;
    }

    @Override
    public void featureUsed(DeprecatedFeatureUsage usage) {
        this.deprecationsFound = true;
        ProblemDiagnostics diagnostics = this.problemStream.forCurrentCaller((ProblemStream.StackTraceTransformer)new StackTraceSanitizer(usage.getCalledFrom()));
        if (this.warningMode.shouldDisplayMessages()) {
            this.maybeLogUsage(usage, diagnostics);
        }
        if (this.warningMode == WarningMode.Fail && this.error == null) {
            this.error = new GradleException("Deprecated Gradle features were used in this build, making it incompatible with Gradle " + DefaultGradleVersion.current().getNextMajorVersion().getVersion());
        }
        if (this.problemsService != null) {
            this.reportDeprecation(usage, diagnostics);
        }
        this.fireDeprecatedUsageBuildOperationProgress(usage, diagnostics);
    }

    private void reportDeprecation(final DeprecatedFeatureUsage usage, final ProblemDiagnostics diagnostics) {
        InternalProblemReporter reporter = ((InternalProblems)this.problemsService).getInternalReporter();
        InternalProblem problem = reporter.internalCreate((Action)new Action<InternalProblemSpec>(){

            public void execute(InternalProblemSpec builder) {
                InternalProblemSpec problemSpec = builder.id(LoggingDeprecatedFeatureHandler.getDefaultDeprecationIdDisplayName(usage), usage.getProblemIdDisplayName(), GradleCoreProblemGroup.deprecation()).contextualLabel(usage.getSummary()).details(usage.getRemovalDetails()).documentedAt(usage.getDocumentationUrl()).diagnostics(diagnostics).additionalDataInternal(DeprecationDataSpec.class, (Action)new Action<DeprecationDataSpec>(){

                    public void execute(DeprecationDataSpec data) {
                        data.type(usage.getType().toDeprecationDataType());
                    }
                }).severity(Severity.WARNING);
                if (usage.getType() == DeprecatedFeatureUsage.Type.USER_CODE_DIRECT) {
                    builder.stackLocation();
                }
                LoggingDeprecatedFeatureHandler.addSolution(usage.getAdvice(), problemSpec);
                LoggingDeprecatedFeatureHandler.addSolution(usage.getContextualAdvice(), problemSpec);
            }
        });
        reporter.report((Problem)problem);
    }

    private static String getDefaultDeprecationIdDisplayName(DeprecatedFeatureUsage usage) {
        if (usage.getProblemId() != null) {
            return usage.getProblemId();
        }
        return DeprecationMessageBuilder.createDefaultDeprecationId(usage.getProblemIdDisplayName());
    }

    private static void addSolution(@Nullable String advice, InternalProblemSpec problemSpec) {
        if (advice != null) {
            problemSpec.solution(advice);
        }
    }

    private void maybeLogUsage(DeprecatedFeatureUsage usage, ProblemDiagnostics diagnostics) {
        String featureMessage = usage.formattedMessage();
        Location location = diagnostics.getLocation();
        if (!this.loggedUsages.add(featureMessage) && location == null && diagnostics.getStack().isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (location != null) {
            message.append(location.getFormatted()).append(SystemProperties.getInstance().getLineSeparator());
        }
        message.append(featureMessage);
        if (location != null && !this.loggedUsages.add(message.toString()) && diagnostics.getStack().isEmpty()) {
            return;
        }
        this.displayDeprecationIfSameMessageNotDisplayedBefore(message, diagnostics.getStack());
    }

    private void displayDeprecationIfSameMessageNotDisplayedBefore(StringBuilder message, List<StackTraceElement> callStack) {
        LoggingDeprecatedFeatureHandler.appendLogTraceIfNecessary(message, callStack, 0, 10);
        if (this.loggedMessages.add(message.toString())) {
            LoggingDeprecatedFeatureHandler.appendLogTraceIfNecessary(message, callStack, 10, callStack.size());
            LOGGER.warn(message.toString());
        }
    }

    private void fireDeprecatedUsageBuildOperationProgress(DeprecatedFeatureUsage usage, ProblemDiagnostics diagnostics) {
        if (this.progressEventEmitter != null) {
            this.progressEventEmitter.emitNowIfCurrent((Object)new DefaultDeprecatedUsageProgressDetails(usage, diagnostics));
        }
    }

    public void reset() {
        this.problemStream = NoOpProblemDiagnosticsFactory.EMPTY_STREAM;
        this.progressEventEmitter = null;
        this.loggedMessages.clear();
        this.loggedUsages.clear();
        this.deprecationsFound = false;
        this.error = null;
    }

    public void reportSuppressedDeprecations() {
        if (this.warningMode == WarningMode.Summary && this.deprecationsFound) {
            LOGGER.warn("\n{} {}.\n\nYou can use '--{} {}' to show the individual deprecation warnings and determine if they come from your own scripts or plugins.\n\n{}", new Object[]{WARNING_SUMMARY, DefaultGradleVersion.current().getNextMajorVersion().getVersion(), "warning-mode", WarningMode.All.name().toLowerCase(Locale.ROOT), DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("on this", "command_line_interface", "sec:command_line_warnings")});
        }
    }

    private static void appendLogTraceIfNecessary(StringBuilder message, List<StackTraceElement> stack, int startIndexInclusive, int endIndexExclusive) {
        String lineSeparator = SystemProperties.getInstance().getLineSeparator();
        int endIndex = Math.min(stack.size(), endIndexExclusive);
        if (LoggingDeprecatedFeatureHandler.isTraceLoggingEnabled()) {
            for (int i = startIndexInclusive; i < endIndex; ++i) {
                StackTraceElement frame = stack.get(i);
                LoggingDeprecatedFeatureHandler.appendStackTraceElement(frame, message, lineSeparator);
            }
        } else {
            for (int i = startIndexInclusive; i < endIndex; ++i) {
                StackTraceElement element = stack.get(i);
                if (!LoggingDeprecatedFeatureHandler.isGradleScriptElement(element)) continue;
                LoggingDeprecatedFeatureHandler.appendStackTraceElement(element, message, lineSeparator);
                LoggingDeprecatedFeatureHandler.appendRunWithStacktraceInfo(message, lineSeparator);
                return;
            }
        }
    }

    private static void appendStackTraceElement(StackTraceElement frame, StringBuilder message, String lineSeparator) {
        message.append(lineSeparator).append(ELEMENT_PREFIX).append(frame);
    }

    private static void appendRunWithStacktraceInfo(StringBuilder message, String lineSeparator) {
        message.append(lineSeparator).append(RUN_WITH_STACKTRACE_INFO);
    }

    private static boolean isGradleScriptElement(StackTraceElement element) {
        String fileName = element.getFileName();
        if (fileName == null) {
            return false;
        }
        return (fileName = fileName.toLowerCase(Locale.US)).endsWith(".gradle") || fileName.endsWith(".gradle.kts");
    }

    public static void setTraceLoggingEnabled(boolean traceLoggingEnabled) {
        LoggingDeprecatedFeatureHandler.traceLoggingEnabled = traceLoggingEnabled;
    }

    static boolean isTraceLoggingEnabled() {
        String value = System.getProperty(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME);
        if (value == null) {
            return traceLoggingEnabled;
        }
        return Boolean.parseBoolean(value);
    }

    public GradleException getDeprecationFailure() {
        return this.error;
    }
}

