/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import org.gradle.util.GradleVersion;
import org.jspecify.annotations.Nullable;

class DeprecationTimeline {
    private final String messagePattern;
    private final GradleVersion targetVersion;
    private final String message;

    private DeprecationTimeline(String messagePattern, GradleVersion targetVersion, @Nullable String message) {
        this.messagePattern = messagePattern;
        this.targetVersion = targetVersion;
        this.message = message;
    }

    private DeprecationTimeline(String messagePattern, GradleVersion targetVersion) {
        this(messagePattern, targetVersion, null);
    }

    static DeprecationTimeline willBeRemovedInVersion(GradleVersion version) {
        return new DeprecationTimeline("This is scheduled to be removed in %s.", version);
    }

    static DeprecationTimeline willBecomeAnErrorInVersion(GradleVersion version) {
        return new DeprecationTimeline("This will fail with an error in %s.", version);
    }

    static DeprecationTimeline behaviourWillBeRemovedInVersion(GradleVersion version) {
        return new DeprecationTimeline("This behavior is scheduled to be removed in %s.", version);
    }

    static DeprecationTimeline willChangeInVersion(GradleVersion version) {
        return new DeprecationTimeline("This will change in %s.", version);
    }

    static DeprecationTimeline startingWithVersion(GradleVersion version, String message) {
        return new DeprecationTimeline("Starting with %s, %s.", version, message);
    }

    public String toString() {
        return this.message == null ? String.format(this.messagePattern, this.targetVersion) : String.format(this.messagePattern, this.targetVersion, this.message);
    }
}

