/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.SystemProperties;
import org.jspecify.annotations.Nullable;

public class TextUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s*");
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");
    private static final Joiner KEBAB_JOINER = Joiner.on((String)"-");
    private static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase(Locale.ROOT);
        }
    };
    private static final Pattern NON_UNIX_LINE_SEPARATORS = Pattern.compile("\r\n|\r");

    public static String getWindowsLineSeparator() {
        return "\r\n";
    }

    public static String getUnixLineSeparator() {
        return "\n";
    }

    public static String getPlatformLineSeparator() {
        return SystemProperties.getInstance().getLineSeparator();
    }

    public static @Nullable String convertLineSeparators(@Nullable String str, String sep) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, sep);
    }

    public static String convertLineSeparatorsToUnix(String str) {
        return TextUtil.replaceAll(NON_UNIX_LINE_SEPARATORS, (CharSequence)str, "\n");
    }

    public static String replaceLineSeparatorsOf(CharSequence string, String bySeparator) {
        return TextUtil.replaceAll("\r\n|\r|\n", string, bySeparator);
    }

    private static String replaceAll(String regex, CharSequence inString, String byString) {
        return TextUtil.replaceAll(Pattern.compile(regex), inString, byString);
    }

    private static String replaceAll(Pattern pattern, CharSequence inString, String byString) {
        return pattern.matcher(inString).replaceAll(byString);
    }

    public static String toPlatformLineSeparators(String str) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, TextUtil.getPlatformLineSeparator());
    }

    public static @Nullable String normaliseLineSeparators(@Nullable String str) {
        return str == null ? null : TextUtil.convertLineSeparatorsToUnix(str);
    }

    public static String normaliseFileSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    public static String escapeString(Object obj) {
        return obj == null ? null : TextUtil.escapeJavaStyleString(obj.toString(), false, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            TextUtil.escapeJavaStyleString(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + TextUtil.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + TextUtil.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + TextUtil.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + TextUtil.hex(ch));
                            break;
                        }
                        out.write("\\u000" + TextUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static boolean containsWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String indent(String text, String indent) {
        StringBuilder builder = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!WHITESPACE.matcher(line).matches()) {
                builder.append(indent);
            }
            builder.append(line);
            if (i >= lines.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String shorterOf(String s1, String s2) {
        if (s2.length() >= s1.length()) {
            return s1;
        }
        return s2;
    }

    public static String minus(String originalString, String removeString) {
        String s = originalString.toString();
        int index = s.indexOf(removeString);
        if (index == -1) {
            return s;
        }
        int end = index + removeString.length();
        if (s.length() > end) {
            return s.substring(0, index) + s.substring(end);
        }
        return s.substring(0, index);
    }

    public static String normaliseFileAndLineSeparators(String in) {
        return TextUtil.normaliseLineSeparators(TextUtil.normaliseFileSeparators(in));
    }

    public static String camelToKebabCase(String camelCase) {
        return KEBAB_JOINER.join(Iterables.transform(Arrays.asList(UPPER_CASE.split(camelCase)), TO_LOWERCASE));
    }

    public static String getPluralEnding(Collection<?> collection) {
        return collection.size() > 1 ? "s" : "";
    }

    public static String endLineWithDot(String txt) {
        if (txt.endsWith(".") || txt.endsWith("\n")) {
            return txt;
        }
        return txt + ".";
    }

    public static String screamingSnakeToKebabCase(String text) {
        return StringUtils.replace((String)text.toLowerCase(Locale.ENGLISH), (String)"_", (String)"-");
    }

    public static String removeTrailing(String originalString, String suffix) {
        if (originalString.endsWith(suffix)) {
            return originalString.substring(0, originalString.length() - suffix.length());
        }
        return originalString;
    }
}

