/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import org.gradle.internal.enterprise.GradleEnterprisePluginBuildState;
import org.gradle.internal.enterprise.GradleEnterprisePluginConfig;
import org.gradle.internal.enterprise.GradleEnterprisePluginEndOfBuildListener;
import org.gradle.internal.enterprise.GradleEnterprisePluginRequiredServices;
import org.gradle.internal.enterprise.GradleEnterprisePluginService;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.impl.GradleEnterprisePluginBackgroundJobExecutorsInternal;
import org.gradle.internal.enterprise.impl.GradleEnterprisePluginServiceRefInternal;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.jspecify.annotations.Nullable;

public class DefaultGradleEnterprisePluginAdapter
implements GradleEnterprisePluginAdapter {
    private final GradleEnterprisePluginServiceFactory pluginServiceFactory;
    private final GradleEnterprisePluginConfig config;
    private final GradleEnterprisePluginRequiredServices requiredServices;
    private final GradleEnterprisePluginBuildState buildState;
    private final GradleEnterprisePluginBackgroundJobExecutorsInternal backgroundJobExecutors;
    private final GradleEnterprisePluginServiceRefInternal pluginServiceRef;
    private final BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar;
    private transient GradleEnterprisePluginService pluginService;

    public DefaultGradleEnterprisePluginAdapter(GradleEnterprisePluginServiceFactory pluginServiceFactory, GradleEnterprisePluginConfig config, GradleEnterprisePluginRequiredServices requiredServices, GradleEnterprisePluginBuildState buildState, GradleEnterprisePluginBackgroundJobExecutorsInternal backgroundJobExecutors, GradleEnterprisePluginServiceRefInternal pluginServiceRef, BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar) {
        this.pluginServiceFactory = pluginServiceFactory;
        this.config = config;
        this.requiredServices = requiredServices;
        this.buildState = buildState;
        this.backgroundJobExecutors = backgroundJobExecutors;
        this.pluginServiceRef = pluginServiceRef;
        this.buildOperationNotificationListenerRegistrar = buildOperationNotificationListenerRegistrar;
        this.createPluginService();
    }

    public GradleEnterprisePluginServiceRef getPluginServiceRef() {
        return this.pluginServiceRef;
    }

    public boolean shouldSaveToConfigurationCache() {
        return true;
    }

    public void onLoadFromConfigurationCache() {
        this.createPluginService();
    }

    public void buildFinished(@Nullable Throwable buildFailure) {
        this.backgroundJobExecutors.shutdown();
        if (this.pluginService != null) {
            this.pluginService.getEndOfBuildListener().buildFinished(new DefaultDevelocityPluginResult(buildFailure));
        }
    }

    private void createPluginService() {
        this.pluginService = this.pluginServiceFactory.create(this.config, this.requiredServices, this.buildState);
        this.pluginServiceRef.set(this.pluginService);
        this.buildOperationNotificationListenerRegistrar.register(this.pluginService.getBuildOperationNotificationListener());
    }

    private static class DefaultDevelocityPluginResult
    implements GradleEnterprisePluginEndOfBuildListener.BuildResult {
        private final Throwable buildFailure;

        public DefaultDevelocityPluginResult(@Nullable Throwable buildFailure) {
            this.buildFailure = buildFailure;
        }

        @Override
        public @Nullable Throwable getFailure() {
            return this.buildFailure;
        }
    }
}

