/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IoSupplier<T> {
    public @Nullable T get() throws IOException;

    public static <T> Supplier<T> wrap(IoSupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

