/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.TaskOptionsGenerator;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class TaskDetails {
    static final Comparator<TaskDetails> DEFAULT_COMPARATOR = (o1, o2) -> {
        int depthCompare = o1.getProjectDepth() - o2.getProjectDepth();
        if (depthCompare != 0) {
            return depthCompare;
        }
        return o1.getPath().compareTo(o2.getPath());
    };
    private final String path;
    private final String taskType;
    private final String shortTypeName;
    private final String description;
    private final String group;
    private final int projectDepth;
    private final List<OptionDetails> options;

    private TaskDetails(String path, String taskType, String shortTypeName, @Nullable String description, @Nullable String group, int projectDepth, List<OptionDetails> options) {
        this.path = path;
        this.taskType = taskType;
        this.shortTypeName = shortTypeName;
        this.description = description;
        this.group = group;
        this.projectDepth = projectDepth;
        this.options = options;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getShortTypeName() {
        return this.shortTypeName;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @Nullable String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.path;
    }

    public int getProjectDepth() {
        return this.projectDepth;
    }

    public List<OptionDetails> getOptions() {
        return this.options;
    }

    public static TaskDetails from(Task task, OptionReader optionReader) {
        String path = task.getPath();
        int projectDepth = StringUtils.countMatches((String)path, (String)":");
        List<OptionDetails> options = TaskOptionsGenerator.generate((Object)task, (OptionReader)optionReader).getAll().stream().map(x$0 -> OptionDetails.from(x$0)).collect(Collectors.toList());
        Class<?> declaredTaskType = TaskDetails.getDeclaredTaskType(task);
        String taskType = declaredTaskType.getName();
        String shortTypeName = declaredTaskType.getSimpleName();
        return new TaskDetails(path, taskType, shortTypeName, task.getDescription(), task.getGroup(), projectDepth, options);
    }

    private static Class<?> getDeclaredTaskType(Task original) {
        Class clazz = new DslObject((Object)original).getDeclaredType();
        if (clazz.equals(DefaultTask.class)) {
            return Task.class;
        }
        return clazz;
    }

    public static class OptionDetails {
        private final String name;
        private final String description;
        private final Set<String> availableValues;

        public OptionDetails(String name, String description, Set<String> availableValues) {
            this.name = name;
            this.description = description;
            this.availableValues = availableValues;
        }

        private static OptionDetails from(OptionDescriptor option) {
            return new OptionDetails(option.getName(), option.getDescription(), option.getAvailableValues());
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getAvailableValues() {
            return this.availableValues;
        }
    }
}

