/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.gradle.configuration.TaskDetails;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TaskDetailPrinter {
    private final String taskPath;
    private final List<TaskDetails> tasks;
    private static final String INDENT = "     ";

    public TaskDetailPrinter(String taskPath, List<TaskDetails> tasks) {
        this.taskPath = taskPath;
        this.tasks = tasks;
    }

    public void print(StyledTextOutput output) {
        output.text((Object)"Detailed task information for ").withStyle(StyledTextOutput.Style.UserInput).println((Object)this.taskPath);
        Map<String, List<TaskDetails>> detailsByTaskType = this.groupTasksByType(this.tasks);
        Set<String> typeNames = detailsByTaskType.keySet();
        boolean multipleTaskTypes = typeNames.size() > 1;
        List sortedTaskTypes = CollectionUtils.sort(typeNames);
        for (String taskType : sortedTaskTypes) {
            output.println();
            List<TaskDetails> tasksByType = detailsByTaskType.get(taskType);
            TaskDetails anyTask = tasksByType.iterator().next();
            String shortTypeName = anyTask.getShortTypeName();
            LinePrefixingStyledTextOutput pathOutput = this.createIndentedOutput(output, INDENT);
            pathOutput.println((Object)("Path" + TextUtil.getPluralEnding(tasksByType)));
            for (TaskDetails task : tasksByType) {
                pathOutput.withStyle(StyledTextOutput.Style.UserInput).println((Object)task.getPath());
            }
            output.println();
            LinePrefixingStyledTextOutput typeOutput = this.createIndentedOutput(output, INDENT);
            typeOutput.println((Object)"Type");
            typeOutput.withStyle(StyledTextOutput.Style.UserInput).text((Object)shortTypeName);
            typeOutput.println((Object)(" (" + taskType + ")"));
            this.printlnCommandlineOptions(output, tasksByType);
            output.println();
            this.printTaskDescription(output, tasksByType);
            output.println();
            this.printTaskGroup(output, tasksByType);
            if (!multipleTaskTypes) continue;
            output.println();
            output.println((Object)"----------------------");
        }
    }

    private Map<String, List<TaskDetails>> groupTasksByType(Collection<TaskDetails> tasks) {
        return tasks.stream().collect(Collectors.groupingBy(TaskDetails::getTaskType, LinkedHashMap::new, Collectors.toList()));
    }

    private void printTaskDescription(StyledTextOutput output, List<TaskDetails> tasks) {
        this.printTaskAttribute(output, "Description", tasks, (InternalTransformer<String, TaskDetails>)((InternalTransformer)TaskDetails::getDescription));
    }

    private void printTaskGroup(StyledTextOutput output, List<TaskDetails> tasks) {
        this.printTaskAttribute(output, "Group", tasks, (InternalTransformer<String, TaskDetails>)((InternalTransformer)TaskDetails::getGroup));
    }

    private void printTaskAttribute(StyledTextOutput output, String attributeHeader, List<TaskDetails> tasks, InternalTransformer<String, TaskDetails> transformer) {
        int count = ((HashSet)CollectionUtils.collect(tasks, new HashSet(), transformer)).size();
        LinePrefixingStyledTextOutput attributeOutput = this.createIndentedOutput(output, INDENT);
        if (count == 1) {
            attributeOutput.println((Object)attributeHeader);
            TaskDetails task = tasks.iterator().next();
            String value = (String)transformer.transform((Object)task);
            attributeOutput.println((Object)(value == null ? "-" : value));
        } else {
            attributeOutput.println((Object)(attributeHeader + "s"));
            for (TaskDetails task : tasks) {
                attributeOutput.withStyle(StyledTextOutput.Style.UserInput).text((Object)("(" + task.getPath() + ") "));
                String value = (String)transformer.transform((Object)task);
                attributeOutput.println((Object)(value == null ? "-" : value));
            }
        }
    }

    private void printlnCommandlineOptions(StyledTextOutput output, List<TaskDetails> tasks) {
        ArrayList<TaskDetails.OptionDetails> allOptions = new ArrayList<TaskDetails.OptionDetails>();
        for (TaskDetails task : tasks) {
            allOptions.addAll(task.getOptions());
        }
        if (!allOptions.isEmpty()) {
            output.println();
            output.text((Object)"Options").println();
        }
        Map<String, Set<String>> optionToAvailableOptionsValues = this.optionToAvailableValues(allOptions);
        Map<String, String> optionToDescription = this.optionToDescription(allOptions);
        Iterator<String> optionNames = optionToAvailableOptionsValues.keySet().iterator();
        while (optionNames.hasNext()) {
            String currentOption = optionNames.next();
            Set<String> availableValues = optionToAvailableOptionsValues.get(currentOption);
            String optionString = "--" + currentOption;
            output.text((Object)INDENT).withStyle(StyledTextOutput.Style.UserInput).text((Object)optionString);
            output.text((Object)INDENT).text((Object)optionToDescription.get(currentOption));
            if (!availableValues.isEmpty()) {
                int optionDescriptionOffset = 2 * INDENT.length() + optionString.length();
                LinePrefixingStyledTextOutput prefixedOutput = this.createIndentedOutput(output, optionDescriptionOffset);
                prefixedOutput.println();
                prefixedOutput.println((Object)"Available values are:");
                for (String value : availableValues) {
                    prefixedOutput.text((Object)INDENT);
                    prefixedOutput.withStyle(StyledTextOutput.Style.UserInput).println((Object)value);
                }
            } else {
                output.println();
            }
            if (!optionNames.hasNext()) continue;
            output.println();
        }
    }

    private Map<String, Set<String>> optionToAvailableValues(List<TaskDetails.OptionDetails> allOptions) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (TaskDetails.OptionDetails optionDescriptor : allOptions) {
            if (result.containsKey(optionDescriptor.getName())) {
                Sets.SetView commonValues = Sets.intersection(optionDescriptor.getAvailableValues(), (Set)((Set)result.get(optionDescriptor.getName())));
                result.put(optionDescriptor.getName(), new TreeSet(commonValues));
                continue;
            }
            result.put(optionDescriptor.getName(), optionDescriptor.getAvailableValues());
        }
        return result;
    }

    private Map<String, String> optionToDescription(List<TaskDetails.OptionDetails> allOptions) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (TaskDetails.OptionDetails optionDescriptor : allOptions) {
            result.put(optionDescriptor.getName(), optionDescriptor.getDescription());
        }
        return result;
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, int offset) {
        return this.createIndentedOutput(output, StringUtils.leftPad((String)"", (int)offset, (char)' '));
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, String prefix) {
        return new LinePrefixingStyledTextOutput(output, (CharSequence)prefix, false);
    }
}

