/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing.testng;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.xml.MarkupBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.serialization.Cached;
import org.jspecify.annotations.Nullable;

public abstract class TestNGOptions
extends TestFrameworkOptions {
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private static final String DEFAULT_PARALLEL_MODE = null;
    private static final int DEFAULT_THREAD_COUNT = -1;
    private static final int DEFAULT_SUITE_THREAD_POOL_SIZE_DEFAULT = 1;
    private File outputDirectory;
    private Set<String> includeGroups = new LinkedHashSet<String>();
    private Set<String> excludeGroups = new LinkedHashSet<String>();
    private String configFailurePolicy = "skip";
    private Set<String> listeners = new LinkedHashSet<String>();
    private String parallel = DEFAULT_PARALLEL_MODE;
    private int threadCount = -1;
    private boolean useDefaultListeners;
    private String threadPoolFactoryClass;
    private String suiteName = "Gradle suite";
    private String testName = "Gradle test";
    private List<File> suiteXmlFiles = new ArrayList<File>();
    private boolean preserveOrder;
    private boolean groupByInstances;
    private transient StringWriter suiteXmlWriter;
    private transient MarkupBuilder suiteXmlBuilder;
    private final Cached<String> cachedSuiteXml = Cached.of((Callable)new Callable<String>(){

        @Override
        public String call() {
            return TestNGOptions.this.suiteXmlWriter != null ? TestNGOptions.this.suiteXmlWriter.toString() : null;
        }
    });
    private final File projectDir;

    @Inject
    public TestNGOptions(ProjectLayout projectLayout) {
        this.projectDir = projectLayout.getProjectDirectory().getAsFile();
        this.getSuiteThreadPoolSize().convention((Object)1);
    }

    public void copyFrom(TestNGOptions other) {
        this.outputDirectory = other.outputDirectory;
        TestNGOptions.replace(this.includeGroups, other.includeGroups);
        TestNGOptions.replace(this.excludeGroups, other.excludeGroups);
        this.configFailurePolicy = other.configFailurePolicy;
        TestNGOptions.replace(this.listeners, other.listeners);
        this.parallel = other.parallel;
        this.threadCount = other.threadCount;
        this.getSuiteThreadPoolSize().set(other.getSuiteThreadPoolSize());
        this.useDefaultListeners = other.useDefaultListeners;
        this.threadPoolFactoryClass = other.threadPoolFactoryClass;
        this.suiteName = other.suiteName;
        this.testName = other.testName;
        TestNGOptions.replace(this.suiteXmlFiles, other.suiteXmlFiles);
        this.preserveOrder = other.preserveOrder;
        this.groupByInstances = other.groupByInstances;
    }

    private static <T> void replace(Collection<T> target, Collection<T> source) {
        target.clear();
        target.addAll(source);
    }

    public MarkupBuilder suiteXmlBuilder() {
        this.suiteXmlWriter = new StringWriter();
        this.suiteXmlBuilder = new MarkupBuilder((Writer)this.suiteXmlWriter);
        return this.suiteXmlBuilder;
    }

    public void suites(String ... suiteFiles) {
        for (String suiteFile : suiteFiles) {
            this.suiteXmlFiles.add(new File(this.getProjectDir(), suiteFile));
        }
    }

    @Internal
    protected File getProjectDir() {
        return this.projectDir;
    }

    public void suites(File ... suiteFiles) {
        this.suiteXmlFiles.addAll(Arrays.asList(suiteFiles));
    }

    @ToBeReplacedByLazyProperty
    public List<File> getSuites(File testSuitesDir) {
        ArrayList<File> suites = new ArrayList<File>();
        suites.addAll(this.suiteXmlFiles);
        final String suiteXmlMarkup = this.getSuiteXml();
        if (suiteXmlMarkup != null) {
            File buildSuiteXml = new File(testSuitesDir.getAbsolutePath(), "build-suite.xml");
            if (buildSuiteXml.exists() && !buildSuiteXml.delete()) {
                throw new RuntimeException("failed to remove already existing build-suite.xml file");
            }
            IoActions.writeTextFile((File)buildSuiteXml, (Action)new ErroringAction<BufferedWriter>(){

                protected void doExecute(BufferedWriter writer) throws Exception {
                    writer.write("<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">");
                    writer.newLine();
                    writer.write(suiteXmlMarkup);
                }
            });
            suites.add(buildSuiteXml);
        }
        return suites;
    }

    public TestNGOptions includeGroups(String ... includeGroups) {
        this.includeGroups.addAll(Arrays.asList(includeGroups));
        return this;
    }

    public TestNGOptions excludeGroups(String ... excludeGroups) {
        this.excludeGroups.addAll(Arrays.asList(excludeGroups));
        return this;
    }

    public TestNGOptions useDefaultListeners() {
        this.useDefaultListeners = true;
        return this;
    }

    public TestNGOptions useDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        return this;
    }

    public Object propertyMissing(String name) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().getProperty((Object)this.suiteXmlBuilder, name);
        }
        throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
    }

    public Object methodMissing(String name, Object args) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().invokeMethod((Object)this.suiteXmlBuilder, name, args);
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), (Object[])args);
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public Set<String> getIncludeGroups() {
        return this.includeGroups;
    }

    public void setIncludeGroups(Set<String> includeGroups) {
        this.includeGroups = includeGroups;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public Set<String> getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(Set<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getConfigFailurePolicy() {
        return this.configFailurePolicy;
    }

    public void setConfigFailurePolicy(String configFailurePolicy) {
        this.configFailurePolicy = configFailurePolicy;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Set<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(Set<String> listeners) {
        this.listeners = listeners;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public @Nullable String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Internal
    @Incubating
    public abstract Property<Integer> getSuiteThreadPoolSize();

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean getUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    @Internal
    @Incubating
    @ToBeReplacedByLazyProperty
    public String getThreadPoolFactoryClass() {
        return this.threadPoolFactoryClass;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }

    @Incubating
    public void setThreadPoolFactoryClass(String threadPoolFactoryClass) {
        this.threadPoolFactoryClass = threadPoolFactoryClass;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @ToBeReplacedByLazyProperty
    public List<File> getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(List<File> suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    public void setPreserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean getGroupByInstances() {
        return this.groupByInstances;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isGroupByInstances() {
        return this.groupByInstances;
    }

    public void setGroupByInstances(boolean groupByInstances) {
        this.groupByInstances = groupByInstances;
    }

    @Input
    @Optional
    protected String getSuiteXml() {
        return (String)this.cachedSuiteXml.get();
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public StringWriter getSuiteXmlWriter() {
        return this.suiteXmlWriter;
    }

    public void setSuiteXmlWriter(StringWriter suiteXmlWriter) {
        this.suiteXmlWriter = suiteXmlWriter;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public MarkupBuilder getSuiteXmlBuilder() {
        return this.suiteXmlBuilder;
    }

    public void setSuiteXmlBuilder(MarkupBuilder suiteXmlBuilder) {
        this.suiteXmlBuilder = suiteXmlBuilder;
    }
}

