/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.apache.groovy.lang.annotation.Incubating;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.reporting.components.ComponentReport;
import org.gradle.api.reporting.dependents.DependentComponentsReport;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.diagnostics.ArtifactTransformsReportTask;
import org.gradle.api.tasks.diagnostics.BuildEnvironmentReportTask;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.OutgoingVariantsReportTask;
import org.gradle.api.tasks.diagnostics.ResolvableConfigurationsReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.jspecify.annotations.NullMarked;

@Incubating
@NullMarked
public abstract class SoftwareReportingTasksPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        String projectName = project.toString();
        tasks.register("dependencyInsight", DependencyInsightReportTask.class, (Action)new DependencyInsightReportTaskAction(projectName));
        tasks.register("dependencies", DependencyReportTask.class, (Action)new DependencyReportTaskAction(projectName));
        tasks.register("buildEnvironment", BuildEnvironmentReportTask.class, (Action)new BuildEnvironmentReportTaskAction(projectName));
        this.registerDeprecatedSoftwareModelTasks(tasks, projectName);
        tasks.register("outgoingVariants", OutgoingVariantsReportTask.class, task -> {
            task.setDescription("Displays the outgoing variants of " + projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
            task.getShowAll().convention((Object)false);
        });
        tasks.register("resolvableConfigurations", ResolvableConfigurationsReportTask.class, task -> {
            task.setDescription("Displays the configurations that can be resolved in " + projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
            task.getShowAll().convention((Object)false);
            task.getRecursive().convention((Object)false);
        });
        tasks.register("artifactTransforms", ArtifactTransformsReportTask.class, task -> {
            task.setDescription("Displays the Artifact Transforms that can be executed in " + projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
        });
        tasks.withType(TaskReportTask.class).configureEach(task -> task.getShowTypes().convention((Object)false));
    }

    private void registerDeprecatedSoftwareModelTasks(TaskContainer tasks, String projectName) {
        tasks.register("components", ComponentReport.class, (Action)new ComponentReportAction(projectName));
        tasks.register("dependentComponents", DependentComponentsReport.class, (Action)new DependentComponentsReportAction(projectName));
    }

    private static class DependencyInsightReportTaskAction
    implements Action<DependencyInsightReportTask> {
        private final String projectName;

        public DependencyInsightReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependencyInsightReportTask task) {
            task.setDescription("Displays the insight into a specific dependency in " + this.projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
            task.getShowingAllVariants().convention((Object)false);
        }
    }

    private static class DependencyReportTaskAction
    implements Action<DependencyReportTask> {
        private final String projectName;

        public DependencyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependencyReportTask task) {
            task.setDescription("Displays all dependencies declared in " + this.projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
        }
    }

    private static class BuildEnvironmentReportTaskAction
    implements Action<BuildEnvironmentReportTask> {
        private final String projectName;

        public BuildEnvironmentReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(BuildEnvironmentReportTask task) {
            task.setDescription("Displays all buildscript dependencies declared in " + this.projectName + ".");
            task.setGroup("help");
            task.setImpliesSubProjects(true);
        }
    }

    private static class ComponentReportAction
    implements Action<ComponentReport> {
        private final String projectName;

        public ComponentReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(ComponentReport task) {
            task.setDescription("Displays the components produced by " + this.projectName + ". [deprecated]");
            task.setImpliesSubProjects(true);
        }
    }

    private static class DependentComponentsReportAction
    implements Action<DependentComponentsReport> {
        private final String projectName;

        public DependentComponentsReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependentComponentsReport task) {
            task.setDescription("Displays the dependent components of components in " + this.projectName + ". [deprecated]");
            task.setImpliesSubProjects(true);
        }
    }
}

