/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.gradle.kotlin.dsl.resolver.FindGradleSources;
import org.gradle.kotlin.dsl.resolver.SourceDistributionProvider;
import org.gradle.kotlin.dsl.resolver.SourceDistributionResolver;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 D2\u00020\u0001:\u0001DB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u00102\u001a\u00020(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020(04H\u0002J\b\u00105\u001a\u00020\u000eH\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000eH\u0002J/\u00109\u001a\u00020:\"\u0010\b\u0000\u0010;\u0018\u0001*\b\u0012\u0004\u0012\u00020=0<2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0>04H\u0082\bJ\b\u0010?\u001a\u00020:H\u0002J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0AH\u0016J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010C\u001a\u00020+H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR-\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020! #*\b\u0012\u0004\u0012\u00020!0\"0 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001e\u001a\u0004\b$\u0010%\u00a8\u0006E"}, d2={"Lorg/gradle/kotlin/dsl/resolver/SourceDistributionResolver;", "Lorg/gradle/kotlin/dsl/resolver/SourceDistributionProvider;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "getConfigurations", "()Lorg/gradle/api/artifacts/ConfigurationContainer;", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "getDependencies", "()Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "gradleVersion", "", "getGradleVersion", "()Ljava/lang/String;", "projectInternal", "Lorg/gradle/api/internal/project/ProjectInternal;", "getProjectInternal", "()Lorg/gradle/api/internal/project/ProjectInternal;", "repositories", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "getRepositories", "()Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "resolver", "Lorg/gradle/api/internal/project/ProjectInternal$DetachedResolver;", "getResolver", "()Lorg/gradle/api/internal/project/ProjectInternal$DetachedResolver;", "resolver$delegate", "Lkotlin/Lazy;", "sourceDirs", "", "Ljava/io/File;", "", "kotlin.jvm.PlatformType", "getSourceDirs", "()Ljava/util/Set;", "sourceDirs$delegate", "createSourceRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "dependencyVersion", "detachedConfigurationFor", "Lorg/gradle/api/artifacts/Configuration;", "dependency", "Lorg/gradle/api/artifacts/Dependency;", "gradleSourceDependency", "Lorg/gradle/api/artifacts/ExternalModuleDependency;", "isSnapshot", "", "ivy", "configure", "Lorg/gradle/api/Action;", "minimumGradleVersion", "previous", "", "versionDigit", "registerTransform", "", "T", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "Lorg/gradle/api/artifacts/transform/TransformSpec;", "registerTransforms", "repositoryNameFor", "", "toVersionRange", "transientConfigurationForSourcesDownload", "Companion", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nSourceDistributionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceDistributionProvider.kt\norg/gradle/kotlin/dsl/resolver/SourceDistributionResolver\n*L\n1#1,176:1\n122#1:177\n*S KotlinDebug\n*F\n+ 1 SourceDistributionProvider.kt\norg/gradle/kotlin/dsl/resolver/SourceDistributionResolver\n*L\n63#1:177\n*E\n"})
public final class SourceDistributionResolver
implements SourceDistributionProvider {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy sourceDirs$delegate;
    @NotNull
    private final Lazy resolver$delegate;
    @NotNull
    private static final Attribute<String> artifactType;
    @NotNull
    public static final String ZIP_TYPE = "zip";
    @NotNull
    public static final String SOURCE_DIRECTORY = "src-directory";

    public SourceDistributionResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceDirs$delegate = NamedDomainObjectCollectionExtensionsKt.provideDelegate(LazyKt.lazy((Function0)((Function0)new Function0<Set<File>>(this){
            final /* synthetic */ SourceDistributionResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Set<File> invoke() {
                SourceDistributionResolver.access$createSourceRepository(this.this$0);
                SourceDistributionResolver.access$registerTransforms(this.this$0);
                return SourceDistributionResolver.access$transientConfigurationForSourcesDownload(this.this$0).getFiles();
            }
        })), (Object)this, $$delegatedProperties[0]);
        this.resolver$delegate = NamedDomainObjectCollectionExtensionsKt.provideDelegate(LazyKt.lazy((Function0)((Function0)new Function0<ProjectInternal.DetachedResolver>(this){
            final /* synthetic */ SourceDistributionResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ProjectInternal.DetachedResolver invoke() {
                return SourceDistributionResolver.access$getProjectInternal(this.this$0).newDetachedResolver();
            }
        })), (Object)this, $$delegatedProperties[1]);
    }

    @Override
    @NotNull
    public Collection<File> sourceDirs() {
        Collection collection;
        try {
            Set<File> set = this.getSourceDirs();
            Intrinsics.checkNotNullExpressionValue(set, (String)"{\n            sourceDirs\n        }");
            collection = set;
        }
        catch (Exception ex) {
            this.project.getLogger().warn("Unexpected exception while resolving Gradle distribution sources: " + ex.getMessage(), (Throwable)ex);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private final Set<File> getSourceDirs() {
        Lazy lazy = this.sourceDirs$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void registerTransforms() {
        void this_$iv;
        SourceDistributionResolver sourceDistributionResolver = this;
        Action configure$iv = registerTransforms.1.INSTANCE;
        boolean $i$f$registerTransform = false;
        super.getDependencies().registerTransform(FindGradleSources.class, configure$iv);
    }

    private final Configuration transientConfigurationForSourcesDownload() {
        Configuration configuration;
        Configuration $this$transientConfigurationForSourcesDownload_u24lambda_u240 = configuration = this.detachedConfigurationFor((Dependency)this.gradleSourceDependency());
        boolean bl = false;
        $this$transientConfigurationForSourcesDownload_u24lambda_u240.getAttributes().attribute(artifactType, (Object)SOURCE_DIRECTORY);
        return configuration;
    }

    private final Configuration detachedConfigurationFor(Dependency dependency) {
        Dependency[] dependencyArray = new Dependency[]{dependency};
        Configuration configuration = this.getConfigurations().detachedConfiguration(dependencyArray);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configurations.detachedConfiguration(dependency)");
        return configuration;
    }

    private final ExternalModuleDependency gradleSourceDependency() {
        return DependencyHandlerExtensionsKt.create(this.getDependencies(), "gradle", "gradle", this.dependencyVersion(this.getGradleVersion()), null, "src", ZIP_TYPE);
    }

    private final IvyArtifactRepository createSourceRepository() {
        return this.ivy((Action<IvyArtifactRepository>)new Action(this){
            final /* synthetic */ SourceDistributionResolver this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(IvyArtifactRepository $this$ivy) {
                Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$this$ivy");
                String repoName = SourceDistributionResolver.access$repositoryNameFor(this.this$0, SourceDistributionResolver.access$getGradleVersion(this.this$0));
                $this$ivy.setName("Gradle " + repoName);
                $this$ivy.setUrl((Object)("https://services.gradle.org/" + repoName));
                $this$ivy.metadataSources((Action)createSourceRepository.1.INSTANCE);
                $this$ivy.patternLayout(new Action(this.this$0){
                    final /* synthetic */ SourceDistributionResolver this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void execute(IvyPatternRepositoryLayout $this$patternLayout) {
                        Intrinsics.checkNotNullParameter((Object)$this$patternLayout, (String)"$this$patternLayout");
                        if (SourceDistributionResolver.access$isSnapshot(this.this$0, SourceDistributionResolver.access$getGradleVersion(this.this$0))) {
                            $this$patternLayout.ivy("/dummy");
                        }
                        $this$patternLayout.artifact("[module]-[revision](-[classifier])(.[ext])");
                    }
                });
            }
        });
    }

    private final String repositoryNameFor(String gradleVersion) {
        return this.isSnapshot(gradleVersion) ? "distributions-snapshots" : "distributions";
    }

    private final String dependencyVersion(String gradleVersion) {
        return this.isSnapshot(gradleVersion) ? this.toVersionRange(gradleVersion) : gradleVersion;
    }

    private final boolean isSnapshot(String gradleVersion) {
        return StringsKt.contains$default((CharSequence)gradleVersion, (char)'+', (boolean)false, (int)2, null);
    }

    private final String toVersionRange(String gradleVersion) {
        return '(' + this.minimumGradleVersion() + ", " + gradleVersion + ']';
    }

    private final /* synthetic */ <T extends TransformAction<TransformParameters.None>> void registerTransform(Action<TransformSpec<TransformParameters.None>> configure2) {
        boolean $i$f$registerTransform = false;
        DependencyHandler dependencyHandler = this.getDependencies();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        dependencyHandler.registerTransform(TransformAction.class, configure2);
    }

    private final IvyArtifactRepository ivy(Action<IvyArtifactRepository> configure2) {
        IvyArtifactRepository ivyArtifactRepository = this.getRepositories().ivy(configure2);
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactRepository, (String)"repositories.ivy(configure)");
        return ivyArtifactRepository;
    }

    private final String minimumGradleVersion() {
        String baseVersionString = GradleVersion.version((String)this.getGradleVersion()).getBaseVersion().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)baseVersionString, (String)"baseVersionString");
        char[] cArray = new char[]{'.'};
        List list2 = StringsKt.split$default((CharSequence)baseVersionString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String major = (String)list2.get(0);
        String minor = (String)list2.get(1);
        return Intrinsics.areEqual((Object)minor, (Object)"0") ? this.previous(major) + ".0" : major + '.' + this.previous(minor);
    }

    private final int previous(String versionDigit) {
        return Integer.parseInt(versionDigit) - 1;
    }

    private final ProjectInternal.DetachedResolver getResolver() {
        Lazy lazy = this.resolver$delegate;
        return (ProjectInternal.DetachedResolver)lazy.getValue();
    }

    private final ProjectInternal getProjectInternal() {
        Project project = this.project;
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        return (ProjectInternal)project;
    }

    private final RepositoryHandler getRepositories() {
        RepositoryHandler repositoryHandler = this.getResolver().getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"resolver.repositories");
        return repositoryHandler;
    }

    private final ConfigurationContainer getConfigurations() {
        ConfigurationContainer configurationContainer = this.getResolver().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"resolver.configurations");
        return configurationContainer;
    }

    private final DependencyHandler getDependencies() {
        DependencyHandler dependencyHandler = this.getResolver().getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"resolver.dependencies");
        return dependencyHandler;
    }

    private final String getGradleVersion() {
        String string = this.project.getGradle().getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.gradle.gradleVersion");
        return string;
    }

    public static final /* synthetic */ String access$repositoryNameFor(SourceDistributionResolver $this, String gradleVersion) {
        return $this.repositoryNameFor(gradleVersion);
    }

    public static final /* synthetic */ String access$getGradleVersion(SourceDistributionResolver $this) {
        return $this.getGradleVersion();
    }

    public static final /* synthetic */ boolean access$isSnapshot(SourceDistributionResolver $this, String gradleVersion) {
        return $this.isSnapshot(gradleVersion);
    }

    public static final /* synthetic */ IvyArtifactRepository access$createSourceRepository(SourceDistributionResolver $this) {
        return $this.createSourceRepository();
    }

    public static final /* synthetic */ void access$registerTransforms(SourceDistributionResolver $this) {
        $this.registerTransforms();
    }

    public static final /* synthetic */ Configuration access$transientConfigurationForSourcesDownload(SourceDistributionResolver $this) {
        return $this.transientConfigurationForSourcesDownload();
    }

    public static final /* synthetic */ ProjectInternal access$getProjectInternal(SourceDistributionResolver $this) {
        return $this.getProjectInternal();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SourceDistributionResolver.class, "sourceDirs", "getSourceDirs()Ljava/util/Set;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SourceDistributionResolver.class, "resolver", "getResolver()Lorg/gradle/api/internal/project/ProjectInternal$DetachedResolver;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Attribute attribute = Attribute.of((String)"artifactType", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"artifactType\", String::class.java)");
        artifactType = attribute;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gradle/kotlin/dsl/resolver/SourceDistributionResolver$Companion;", "", "()V", "SOURCE_DIRECTORY", "", "ZIP_TYPE", "artifactType", "Lorg/gradle/api/attributes/Attribute;", "getArtifactType", "()Lorg/gradle/api/attributes/Attribute;", "kotlin-dsl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Attribute<String> getArtifactType() {
            return artifactType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

