/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ivy.IvyComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Project.class})
public class GraphVariantSelector {
    private final AttributeSchemaServices attributeSchemaServices;
    private final ResolutionFailureHandler failureHandler;

    public GraphVariantSelector(AttributeSchemaServices attributeSchemaServices, ResolutionFailureHandler failureHandler) {
        this.attributeSchemaServices = attributeSchemaServices;
        this.failureHandler = failureHandler;
    }

    public ResolutionFailureHandler getFailureHandler() {
        return this.failureHandler;
    }

    public VariantGraphResolveState selectByAttributeMatching(ImmutableAttributes consumerAttributes, Set<CapabilitySelector> capabilitySelectors, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        VariantGraphResolveState result = this.selectByAttributeMatchingLenient(consumerAttributes, capabilitySelectors, targetComponentState, consumerSchema, requestedArtifacts);
        if (result == null) {
            ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
            AttributeMatcher attributeMatcher = this.attributeSchemaServices.getMatcher(consumerSchema, targetComponent.getAttributesSchema());
            GraphSelectionCandidates candidates = targetComponentState.getCandidatesForGraphVariantSelection();
            throw this.failureHandler.noCompatibleVariantsFailure(attributeMatcher, targetComponentState, (AttributeContainerInternal)consumerAttributes, capabilitySelectors, candidates);
        }
        return result;
    }

    public @Nullable VariantGraphResolveState selectByAttributeMatchingLenient(ImmutableAttributes consumerAttributes, Set<CapabilitySelector> capabilitySelectors, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        List<VariantGraphResolveState> sameClassifier;
        String classifier;
        List<? extends VariantGraphResolveState> candidates = targetComponentState.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching();
        assert (!candidates.isEmpty());
        ImmutableAttributesSchema producerSchema = targetComponentState.getMetadata().getAttributesSchema();
        AttributeMatcher attributeMatcher = this.attributeSchemaServices.getMatcher(consumerSchema, producerSchema);
        ImmutableList<VariantGraphResolveState> variantsProvidingRequestedCapabilities = GraphVariantSelector.filterVariantsByRequestedCapabilities(targetComponentState, capabilitySelectors, candidates, true);
        if (variantsProvidingRequestedCapabilities.isEmpty()) {
            throw this.failureHandler.noVariantsWithMatchingCapabilitiesFailure(attributeMatcher, targetComponentState, consumerAttributes, capabilitySelectors, candidates);
        }
        List<VariantGraphResolveState> matches = attributeMatcher.matchMultipleCandidates(variantsProvidingRequestedCapabilities, consumerAttributes);
        if (matches.size() < 2) {
            return GraphVariantSelector.zeroOrSingleVariant(matches);
        }
        if ((matches = GraphVariantSelector.filterVariantsByRequestedCapabilities(targetComponentState, capabilitySelectors, matches, false)).size() < 2) {
            return GraphVariantSelector.zeroOrSingleVariant(matches);
        }
        if ((matches = attributeMatcher.matchMultipleCandidates(matches, consumerAttributes)).size() < 2) {
            return GraphVariantSelector.zeroOrSingleVariant(matches);
        }
        if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = GraphVariantSelector.findVariantsProvidingExactlySameClassifier(matches, classifier)).size() < 2) {
            return GraphVariantSelector.zeroOrSingleVariant(sameClassifier);
        }
        throw this.failureHandler.ambiguousVariantsFailure(attributeMatcher, targetComponentState, (AttributeContainerInternal)consumerAttributes, capabilitySelectors, matches);
    }

    public VariantGraphResolveState selectLegacyVariant(ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema, ResolutionFailureHandler failureHandler) {
        VariantGraphResolveState conf = targetComponentState.getCandidatesForGraphVariantSelection().getLegacyVariant();
        if (conf == null) {
            throw failureHandler.noVariantsFailure(targetComponentState, (AttributeContainerInternal)consumerAttributes);
        }
        this.validateVariantAttributes(conf, consumerAttributes, targetComponentState, consumerSchema);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(conf);
        return conf;
    }

    public VariantGraphResolveState selectVariantByConfigurationName(String name, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema) {
        VariantGraphResolveState conf;
        if (targetComponentState instanceof IvyComponentGraphResolveState) {
            conf = ((IvyComponentGraphResolveState)targetComponentState).getCandidatesForGraphVariantSelection().getVariantByConfigurationName(name);
        } else if (targetComponentState instanceof LocalComponentGraphResolveState) {
            conf = ((LocalComponentGraphResolveState)targetComponentState).getCandidatesForGraphVariantSelection().getVariantByConfigurationName(name);
        } else {
            throw new IllegalArgumentException("Cannot select a variant by configuration name from '" + targetComponentState.getId() + "'.");
        }
        if (conf == null) {
            throw this.failureHandler.configurationDoesNotExistFailure(targetComponentState, name);
        }
        this.validateVariantAttributes(conf, consumerAttributes, targetComponentState, consumerSchema);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(conf);
        return conf;
    }

    private void validateVariantAttributes(VariantGraphResolveState conf, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema) {
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        AttributeMatcher attributeMatcher = this.attributeSchemaServices.getMatcher(consumerSchema, targetComponent.getAttributesSchema());
        if (!(consumerAttributes.isEmpty() || conf.getAttributes().isEmpty() || attributeMatcher.isMatchingCandidate(conf.getAttributes(), consumerAttributes))) {
            throw this.failureHandler.configurationNotCompatibleFailure(attributeMatcher, targetComponentState, conf, (AttributeContainerInternal)consumerAttributes, conf.getCapabilities());
        }
    }

    private static List<VariantGraphResolveState> findVariantsProvidingExactlySameClassifier(List<VariantGraphResolveState> matches, String classifier) {
        ArrayList sameClassifier = Collections.emptyList();
        for (VariantGraphResolveState match : matches) {
            if (!GraphVariantSelector.variantProvidesClassifier(match, classifier)) continue;
            if (sameClassifier == Collections.EMPTY_LIST) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private static boolean variantProvidesClassifier(VariantGraphResolveState variant, String classifier) {
        Set<? extends VariantResolveMetadata> artifactSets = variant.prepareForArtifactResolution().getArtifactVariants();
        for (VariantResolveMetadata variantResolveMetadata : artifactSets) {
            if (!GraphVariantSelector.artifactSetStrictlyProvidesClassifier(variantResolveMetadata, classifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean artifactSetStrictlyProvidesClassifier(VariantResolveMetadata artifactSet, String classifier) {
        ImmutableList<? extends ComponentArtifactMetadata> artifacts = artifactSet.getArtifacts();
        if (artifacts.size() != 1) {
            return false;
        }
        ComponentArtifactMetadata componentArtifactMetadata = (ComponentArtifactMetadata)artifacts.get(0);
        if (!(componentArtifactMetadata instanceof ModuleComponentArtifactMetadata)) {
            return false;
        }
        return classifier.equals(componentArtifactMetadata.getName().getClassifier());
    }

    private static @Nullable VariantGraphResolveState zeroOrSingleVariant(List<VariantGraphResolveState> matches) {
        if (matches.isEmpty()) {
            return null;
        }
        assert (matches.size() == 1);
        VariantGraphResolveState match = matches.get(0);
        GraphVariantSelector.maybeEmitConsumptionDeprecation(match);
        return match;
    }

    private static void maybeEmitConsumptionDeprecation(VariantGraphResolveState targetVariant) {
        if (targetVariant.getMetadata().isDeprecated()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration((String)targetVariant.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
    }

    private static ImmutableList<VariantGraphResolveState> filterVariantsByRequestedCapabilities(ComponentGraphResolveState targetComponent, Set<CapabilitySelector> capabilitySelectors, Collection<? extends VariantGraphResolveState> consumableVariants, boolean lenient) {
        ImmutableCapability defaultCapability = targetComponent.getDefaultCapability();
        boolean explicitlyRequested = !capabilitySelectors.isEmpty();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableVariants.size());
        for (VariantGraphResolveState variantGraphResolveState : consumableVariants) {
            ImmutableCapabilities capabilities = variantGraphResolveState.getCapabilities();
            if (explicitlyRequested) {
                if (!GraphVariantSelector.matchesCapabilitySelectors(capabilitySelectors, capabilities, defaultCapability, lenient)) continue;
                builder.add((Object)variantGraphResolveState);
                continue;
            }
            if (!GraphVariantSelector.containsImplicitCapability(capabilities, defaultCapability, lenient)) continue;
            builder.add((Object)variantGraphResolveState);
        }
        return builder.build();
    }

    private static boolean containsImplicitCapability(ImmutableCapabilities capabilities, ImmutableCapability implicitCapability, boolean lenient) {
        if (capabilities.isEmpty()) {
            return true;
        }
        ImmutableSet<ImmutableCapability> capabilitiesSet = capabilities.asSet();
        if (capabilitiesSet.size() == 1 && capabilitiesSet.iterator().next() instanceof ShadowedCapability) {
            return true;
        }
        for (Capability capability : capabilities) {
            if (capability instanceof ShadowedCapability) {
                capability = ((ShadowedCapability)capability).getShadowedCapability();
            }
            if (!implicitCapability.getGroup().equals(capability.getGroup()) || !implicitCapability.getName().equals(capability.getName())) continue;
            return lenient || capabilities.asSet().size() == 1;
        }
        return false;
    }

    private static boolean matchesCapabilitySelectors(Set<CapabilitySelector> capabilitySelectors, ImmutableCapabilities capabilities, ImmutableCapability implicitCapability, boolean lenient) {
        if (capabilities.isEmpty()) {
            capabilities = ImmutableCapabilities.of((Capability)implicitCapability);
        }
        for (CapabilitySelector selector : capabilitySelectors) {
            if (!GraphVariantSelector.noMatchingCapability(selector, capabilities, implicitCapability)) continue;
            return false;
        }
        if (lenient) {
            return true;
        }
        for (CapabilityInternal capability : capabilities) {
            if (!GraphVariantSelector.noMatchingSelector(capability, capabilitySelectors, implicitCapability)) continue;
            return false;
        }
        return true;
    }

    private static boolean noMatchingCapability(CapabilitySelector selector, ImmutableCapabilities capabilities, ImmutableCapability implicitCapability) {
        for (CapabilityInternal capability : capabilities) {
            if (!GraphVariantSelector.matches(selector, capability, implicitCapability)) continue;
            return false;
        }
        return true;
    }

    private static boolean noMatchingSelector(CapabilityInternal capability, Set<CapabilitySelector> selectors, ImmutableCapability implicitCapability) {
        for (CapabilitySelector selector : selectors) {
            if (!GraphVariantSelector.matches(selector, capability, implicitCapability)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(CapabilitySelector selector, CapabilityInternal capability, ImmutableCapability implicitCapability) {
        CapabilitySelectorInternal internalSelector = (CapabilitySelectorInternal)selector;
        return internalSelector.matches(capability.getGroup(), capability.getName(), implicitCapability);
    }
}

