/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveStateFactory;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.jspecify.annotations.Nullable;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentGraphResolveMetadata>
implements LocalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final boolean adHoc;
    private final LocalVariantGraphResolveStateFactory variantFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final InMemoryCacheFactory cacheFactory;
    private final ComponentIdentifier overrideComponentId;
    private final AtomicReference<CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>> graphSelectionCandidates = new AtomicReference();
    private final AtomicReference<CalculatedValue<List<ResolvedVariantResult>>> selectableVariantResults = new AtomicReference();

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentGraphResolveMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, boolean adHoc, LocalVariantGraphResolveStateFactory variantFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, InMemoryCacheFactory cacheFactory, @Nullable ComponentIdentifier overrideComponentId) {
        super(instanceId, metadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.adHoc = adHoc;
        this.variantFactory = variantFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.cacheFactory = cacheFactory;
        this.overrideComponentId = overrideComponentId;
        this.initCalculatedValues();
    }

    @Override
    public void reevaluate() {
        this.variantFactory.invalidate();
        this.initCalculatedValues();
    }

    private void initCalculatedValues() {
        this.graphSelectionCandidates.set((CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>)this.calculatedValueContainerFactory.create(Describables.of((Object)"variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeGraphSelectionCandidates(this.variantFactory, this.overrideComponentId)));
        this.selectableVariantResults.set((CalculatedValue<List<ResolvedVariantResult>>)this.calculatedValueContainerFactory.create(Describables.of((Object)"public variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeSelectableVariantResults(this)));
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentGraphResolveMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public boolean isAdHoc() {
        return this.adHoc;
    }

    @Override
    public LocalComponentGraphResolveState copyWithComponentId(ComponentIdentifier overrideComponentId) {
        LocalComponentGraphResolveMetadata originalMetadata = (LocalComponentGraphResolveMetadata)this.getMetadata();
        LocalComponentGraphResolveMetadata copiedMetadata = new LocalComponentGraphResolveMetadata(originalMetadata.getModuleVersionId(), overrideComponentId, originalMetadata.getStatus(), originalMetadata.getAttributesSchema());
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), copiedMetadata, this.getAttributeDesugaring(), this.idGenerator, this.adHoc, this.variantFactory, this.calculatedValueContainerFactory, this.cacheFactory, overrideComponentId);
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        return new LocalComponentArtifactResolveMetadata((ComponentGraphResolveMetadata)this.getMetadata());
    }

    @Override
    public LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates> value = this.graphSelectionCandidates.get();
        value.finalizeIfNotAlready();
        return (LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates)value.get();
    }

    private static LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates computeGraphSelectionCandidates(LocalVariantGraphResolveStateFactory variantFactory, @Nullable ComponentIdentifier overrideComponentId) {
        ImmutableList.Builder variantsWithAttributes = new ImmutableList.Builder();
        ImmutableMap.Builder variantsByConfigurationName = ImmutableMap.builder();
        variantFactory.visitConsumableVariants(variantState -> {
            if (overrideComponentId != null) {
                variantState = variantState.copyWithComponentId(overrideComponentId);
            }
            if (!variantState.getAttributes().isEmpty()) {
                variantsWithAttributes.add(variantState);
            }
            if (variantState.getMetadata().getConfigurationName() != null) {
                variantsByConfigurationName.put((Object)variantState.getMetadata().getConfigurationName(), variantState);
            }
        });
        return new DefaultLocalComponentGraphSelectionCandidates((List<? extends LocalVariantGraphResolveState>)variantsWithAttributes.build(), (Map<String, LocalVariantGraphResolveState>)variantsByConfigurationName.build());
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        CalculatedValue<List<ResolvedVariantResult>> value = this.selectableVariantResults.get();
        value.finalizeIfNotAlready();
        return (List)value.get();
    }

    private static List<ResolvedVariantResult> computeSelectableVariantResults(DefaultLocalComponentGraphResolveState component) {
        return component.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().stream().flatMap(variant -> variant.prepareForArtifactResolution().getArtifactVariants().stream()).map(variant -> new DefaultResolvedVariantResult(component.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)component.getAttributeDesugaring().desugar(variant.getAttributes().asImmutable()), component.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentGraphResolveMetadata metadata;

        public LocalComponentArtifactResolveMetadata(ComponentGraphResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return ImmutableModuleSources.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class DefaultLocalComponentGraphSelectionCandidates
    implements LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates {
        private final List<? extends LocalVariantGraphResolveState> variantsWithAttributes;
        private final Map<String, LocalVariantGraphResolveState> variantsByConfigurationName;

        public DefaultLocalComponentGraphSelectionCandidates(List<? extends LocalVariantGraphResolveState> variantsWithAttributes, Map<String, LocalVariantGraphResolveState> variantsByConfigurationName) {
            this.variantsWithAttributes = variantsWithAttributes;
            this.variantsByConfigurationName = variantsByConfigurationName;
        }

        public List<? extends LocalVariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variantsWithAttributes;
        }

        @Override
        public @Nullable VariantGraphResolveState getLegacyVariant() {
            return this.getVariantByConfigurationName("default");
        }

        @Override
        public @Nullable LocalVariantGraphResolveState getVariantByConfigurationName(String name) {
            return this.variantsByConfigurationName.get(name);
        }

        @Override
        public List<LocalVariantGraphResolveState> getAllSelectableVariants() {
            HashSet<String> configurationNames = new HashSet<String>(this.variantsByConfigurationName.keySet());
            for (LocalVariantGraphResolveState localVariantGraphResolveState : this.variantsWithAttributes) {
                if (localVariantGraphResolveState.getMetadata().getConfigurationName() == null) continue;
                configurationNames.remove(localVariantGraphResolveState.getMetadata().getConfigurationName());
            }
            ArrayList<LocalVariantGraphResolveState> result = new ArrayList<LocalVariantGraphResolveState>(this.variantsWithAttributes);
            for (String configurationName : configurationNames) {
                result.add(this.variantsByConfigurationName.get(configurationName));
            }
            return result;
        }
    }
}

