/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

public class ProjectDerivedCapability
implements CapabilityInternal {
    private final Project project;
    private final String featureName;
    private volatile String capabilityName;

    public ProjectDerivedCapability(Project project) {
        this(project, null);
    }

    public ProjectDerivedCapability(Project project, @Nullable String featureName) {
        this.project = project;
        this.featureName = featureName;
    }

    public String getGroup() {
        return ProjectDerivedCapability.notNull("group", this.project.getGroup());
    }

    public String getName() {
        if (this.capabilityName == null) {
            this.capabilityName = ProjectDerivedCapability.computeCapabilityName(this.project, this.featureName);
        }
        return this.capabilityName;
    }

    private static String computeCapabilityName(Project project, @Nullable String featureName) {
        if (featureName == null) {
            return project.getName();
        }
        return project.getName() + "-" + TextUtil.camelToKebabCase((String)featureName);
    }

    public String getVersion() {
        return ProjectDerivedCapability.notNull("version", this.project.getVersion());
    }

    public int hashCode() {
        int hash = this.getVersion().hashCode();
        hash = 31 * hash + this.getName().hashCode();
        hash = 31 * hash + this.getGroup().hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability that = (Capability)o;
        return Objects.equal((Object)this.getGroup(), (Object)that.getGroup()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getVersion(), (Object)that.getVersion());
    }

    private static String notNull(String id, Object o) {
        if (o == null) {
            throw new InvalidUserDataException(id + " must not be null");
        }
        return o.toString();
    }

    public String getCapabilityId() {
        return this.getGroup() + ":" + this.getName();
    }
}

