/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CapabilityNotationParserFactory
implements Factory<NotationParser<Object, Capability>> {
    private static final CapabilityNotationParser STRICT_CONVERTER = CapabilityNotationParserFactory.createSingletonConverter(true);
    private static final CapabilityNotationParser LENIENT_CONVERTER = CapabilityNotationParserFactory.createSingletonConverter(false);
    private final boolean versionIsRequired;

    public CapabilityNotationParserFactory(boolean versionIsRequired) {
        this.versionIsRequired = versionIsRequired;
    }

    private static CapabilityNotationParser createSingletonConverter(boolean strict) {
        final NotationParser parser = NotationParserBuilder.toType(Capability.class).converter((NotationConverter)new StringNotationParser(strict)).converter((NotationConverter)(strict ? new StrictCapabilityMapNotationParser() : new LenientCapabilityMapNotationParser())).toComposite();
        return new CapabilityNotationParser(){

            public Capability parseNotation(Object notation) throws TypeConversionException {
                return (Capability)parser.parseNotation(notation);
            }

            public void describe(DiagnosticsVisitor visitor) {
                parser.describe(visitor);
            }
        };
    }

    public @NonNull CapabilityNotationParser create() {
        return this.versionIsRequired ? STRICT_CONVERTER : LENIENT_CONVERTER;
    }

    private static class StringNotationParser
    extends TypedNotationConverter<CharSequence, Capability> {
        private final boolean versionIsRequired;

        StringNotationParser(boolean versionIsRequired) {
            super(CharSequence.class);
            this.versionIsRequired = versionIsRequired;
        }

        protected Capability parseType(CharSequence notation) {
            String stringNotation = notation.toString();
            String[] parts = stringNotation.split(":");
            if (parts.length != 3 && (this.versionIsRequired || parts.length != 2)) {
                StringNotationParser.reportInvalidNotation(stringNotation);
            }
            for (String part : parts) {
                if (!StringUtils.isEmpty((String)part)) continue;
                StringNotationParser.reportInvalidNotation(stringNotation);
            }
            String version = parts.length == 3 ? parts[2] : null;
            return new DefaultImmutableCapability(parts[0], parts[1], version);
        }

        private static void reportInvalidNotation(String notation) {
            throw new InvalidUserDataException("Invalid format for capability: '" + notation + "'. The correct notation is a 3-part group:name:version notation, e.g: 'org.group:capability:1.0'");
        }
    }

    private static class StrictCapabilityMapNotationParser
    extends MapNotationConverter<Capability> {
        private StrictCapabilityMapNotationParser() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.group', name: 'capability', version: '1.0']");
        }

        protected Capability parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return new DefaultImmutableCapability(group, name, version);
        }
    }

    private static class LenientCapabilityMapNotationParser
    extends MapNotationConverter<Capability> {
        private LenientCapabilityMapNotationParser() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.group', name: 'capability', version: '1.0']");
        }

        protected Capability parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") @Nullable String version) {
            return new DefaultImmutableCapability(group, name, version);
        }
    }
}

