/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectInternal dependencyProject;

    public DefaultProjectDependency(ProjectInternal dependencyProject) {
        this.dependencyProject = dependencyProject;
    }

    public String getPath() {
        return this.getTargetProjectIdentity().getProjectPath().toString();
    }

    @Deprecated
    public Project getDependencyProject() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(ProjectDependency.class, (String)"getDependencyProject()").willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_get_dependency_project")).nagUser();
        return this.dependencyProject;
    }

    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    public String getName() {
        return this.dependencyProject.getName();
    }

    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    public ProjectIdentity getTargetProjectIdentity() {
        return this.dependencyProject.getOwner().getIdentity();
    }

    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.dependencyProject);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    public List<Capability> getRequestedCapabilities() {
        return (List)this.getCapabilitySelectors().stream().map(c -> {
            if (c instanceof SpecificCapabilitySelector) {
                return ((DefaultSpecificCapabilitySelector)c).getBackingCapability();
            }
            if (c instanceof FeatureCapabilitySelector) {
                return new ProjectDerivedCapability((Project)this.dependencyProject, ((FeatureCapabilitySelector)c).getFeatureName());
            }
            throw new UnsupportedOperationException("Unsupported capability selector type: " + c.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    @Deprecated
    public boolean contentEquals(Dependency dependency) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Dependency.class, (String)"contentEquals(Dependency)").withAdvice("Use Object.equals(Object) instead")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_content_equals")).nagUser();
        if (this == dependency) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != dependency.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)dependency;
        if (!this.isCommonContentEquals((ModuleDependency)that)) {
            return false;
        }
        return this.getTargetProjectIdentity().equals((Object)that.getTargetProjectIdentity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)((Object)o);
        if (!this.getTargetProjectIdentity().equals((Object)that.getTargetProjectIdentity())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(that.getTargetConfiguration()) : that.getTargetConfiguration() != null) {
            return false;
        }
        if (!Objects.equal((Object)this.getAttributes(), (Object)that.getAttributes())) {
            return false;
        }
        return Objects.equal((Object)this.getCapabilitySelectors(), (Object)that.getCapabilitySelectors());
    }

    public int hashCode() {
        int hashCode = this.getTargetProjectIdentity().hashCode();
        if (this.getTargetConfiguration() != null) {
            hashCode = 31 * hashCode + this.getTargetConfiguration().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return "project '" + this.getTargetProjectIdentity().getBuildTreePath() + "'";
    }
}

