/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.distribution.plugins;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.internal.DefaultDistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.TextUtil;

public abstract class DistributionBasePlugin
implements Plugin<Project> {
    private static final String DISTRIBUTION_GROUP = "distribution";
    private static final String TASK_DIST_ZIP_NAME = "distZip";
    private static final String TASK_DIST_TAR_NAME = "distTar";
    private static final String TASK_ASSEMBLE_NAME = "assembleDist";
    private final Instantiator instantiator;
    private final FileOperations fileOperations;
    private final CollectionCallbackActionDecorator callbackActionDecorator;

    @Inject
    public DistributionBasePlugin(Instantiator instantiator, FileOperations fileOperations, CollectionCallbackActionDecorator callbackActionDecorator) {
        this.instantiator = instantiator;
        this.fileOperations = fileOperations;
        this.callbackActionDecorator = callbackActionDecorator;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().create(DistributionContainer.class, "distributions", DefaultDistributionContainer.class, new Object[]{Distribution.class, this.instantiator, project.getObjects(), this.fileOperations, this.callbackActionDecorator});
        distributions.all(dist -> DistributionBasePlugin.configureDistribution((ProjectInternal)project, dist));
        project.afterEvaluate(p -> distributions.forEach(distribution -> {
            if (((String)distribution.getDistributionBaseName().get()).equals("")) {
                throw new GradleException(String.format("Distribution '%s' must not have an empty distributionBaseName.", distribution.getName()));
            }
        }));
    }

    private static void configureDistribution(ProjectInternal project, Distribution dist) {
        String assembleTaskName;
        String installTaskName;
        String tarTaskName;
        String zipTaskName;
        dist.getContents().from(new Object[]{"src/" + dist.getName() + "/dist"});
        if (dist.getName().equals("main")) {
            zipTaskName = TASK_DIST_ZIP_NAME;
            tarTaskName = TASK_DIST_TAR_NAME;
            installTaskName = "installDist";
            assembleTaskName = TASK_ASSEMBLE_NAME;
            dist.getDistributionBaseName().convention((Object)project.getName());
        } else {
            zipTaskName = dist.getName() + "DistZip";
            tarTaskName = dist.getName() + "DistTar";
            installTaskName = "install" + StringUtils.capitalize((String)dist.getName()) + "Dist";
            assembleTaskName = "assemble" + StringUtils.capitalize((String)dist.getName()) + "Dist";
            dist.getDistributionBaseName().convention((Object)String.format("%s-%s", project.getName(), dist.getName()));
        }
        TaskProvider<Zip> zipTask = DistributionBasePlugin.addArchiveTask((Project)project, zipTaskName, Zip.class, dist);
        TaskProvider<Tar> tarTask = DistributionBasePlugin.addArchiveTask((Project)project, tarTaskName, Tar.class, dist);
        DistributionBasePlugin.addInstallTask((Project)project, installTaskName, dist);
        DistributionBasePlugin.addAssembleTask(project, dist, assembleTaskName, zipTask, tarTask);
        PublishArtifactSet archivesArtifacts = project.getConfigurations().getByName("archives").getArtifacts();
        archivesArtifacts.add((Object)new LazyPublishArtifact(zipTask, project.getFileResolver(), project.getTaskDependencyFactory()));
        archivesArtifacts.add((Object)new LazyPublishArtifact(tarTask, project.getFileResolver(), project.getTaskDependencyFactory()));
    }

    private static <T extends AbstractArchiveTask> TaskProvider<T> addArchiveTask(Project project, String taskName, Class<T> type, Distribution distribution) {
        return project.getTasks().register(taskName, type, task -> {
            task.setDescription("Bundles the project as a distribution.");
            task.setGroup(DISTRIBUTION_GROUP);
            task.getArchiveBaseName().convention(distribution.getDistributionBaseName());
            task.getArchiveClassifier().convention(distribution.getDistributionClassifier());
            CopySpec childSpec = project.copySpec();
            childSpec.with(new CopySpec[]{distribution.getContents()});
            childSpec.into(() -> TextUtil.removeTrailing((String)((String)task.getArchiveFileName().get()), (String)("." + (String)task.getArchiveExtension().get())));
            task.with(new CopySpec[]{childSpec});
        });
    }

    private static void addInstallTask(Project project, String taskName, Distribution distribution) {
        project.getTasks().register(taskName, Sync.class, installTask -> {
            installTask.setDescription("Installs the project as a distribution as-is.");
            installTask.setGroup(DISTRIBUTION_GROUP);
            installTask.with(new CopySpec[]{distribution.getContents()});
            Provider installDirectoryName = project.provider(() -> {
                String baseName = (String)distribution.getDistributionBaseName().get();
                String classifier = (String)distribution.getDistributionClassifier().getOrNull();
                return "install/" + baseName + (classifier != null ? "-" + classifier : "");
            });
            installTask.into((Object)project.getLayout().getBuildDirectory().dir(installDirectoryName));
        });
    }

    private static void addAssembleTask(ProjectInternal project, Distribution dist, String distAssembleTaskName, TaskProvider<Zip> zipTask, TaskProvider<Tar> tarTask) {
        project.getTasks().register(distAssembleTaskName, DefaultTask.class, assembleTask -> {
            assembleTask.setDescription("Assembles the " + dist.getName() + " distributions");
            assembleTask.setGroup(DISTRIBUTION_GROUP);
            assembleTask.dependsOn(new Object[]{zipTask});
            assembleTask.dependsOn(new Object[]{tarTask});
        });
    }
}

