/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.LineInFileLocation;
import org.gradle.api.problems.OffsetInFileLocation;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.internal.InternalDocLink;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.PluginIdLocation;
import org.gradle.api.problems.internal.ProblemProgressDetails;
import org.gradle.api.problems.internal.StackTraceLocation;
import org.gradle.api.problems.internal.TaskLocation;
import org.gradle.operations.problems.DocumentationLink;
import org.gradle.operations.problems.ProblemSeverity;
import org.gradle.operations.problems.ProblemUsageProgressDetails;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultProblemProgressDetails
implements ProblemProgressDetails,
ProblemUsageProgressDetails {
    private final InternalProblem problem;

    public DefaultProblemProgressDetails(InternalProblem problem) {
        this.problem = problem;
    }

    public InternalProblem getProblem() {
        return this.problem;
    }

    public org.gradle.operations.problems.ProblemDefinition getDefinition() {
        return new DevelocityProblemDefinition(this.problem.getDefinition());
    }

    public ProblemSeverity getSeverity() {
        switch (this.problem.getDefinition().getSeverity()) {
            case ADVICE: {
                return ProblemSeverity.ADVICE;
            }
            case WARNING: {
                return ProblemSeverity.WARNING;
            }
            case ERROR: {
                return ProblemSeverity.ERROR;
            }
        }
        throw new IllegalArgumentException("Unknown severity: " + (Object)((Object)this.problem.getDefinition().getSeverity()));
    }

    public @Nullable String getContextualLabel() {
        return this.problem.getContextualLabel();
    }

    public List<String> getSolutions() {
        return this.problem.getSolutions();
    }

    public @Nullable String getDetails() {
        return this.problem.getDetails();
    }

    public List<org.gradle.operations.problems.ProblemLocation> getOriginLocations() {
        return this.convertProblemLocations(this.problem.getOriginLocations());
    }

    public List<org.gradle.operations.problems.ProblemLocation> getContextualLocations() {
        return this.convertProblemLocations(this.problem.getContextualLocations());
    }

    private @NonNull ImmutableList<org.gradle.operations.problems.ProblemLocation> convertProblemLocations(List<ProblemLocation> locations) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProblemLocation location : locations) {
            org.gradle.operations.problems.ProblemLocation develocityLocation = DefaultProblemProgressDetails.convertToLocation(location);
            if (develocityLocation == null) continue;
            builder.add((Object)develocityLocation);
        }
        return builder.build();
    }

    private static @Nullable org.gradle.operations.problems.ProblemLocation convertToLocation(ProblemLocation location) {
        if (location instanceof FileLocation) {
            return DefaultProblemProgressDetails.convertToDevelocityFileLocation(location);
        }
        if (location instanceof TaskLocation) {
            return null;
        }
        if (location instanceof PluginIdLocation) {
            return new DevelocityPluginIdLocation((PluginIdLocation)location);
        }
        if (location instanceof StackTraceLocation) {
            return new DevelocityStackTraceLocation((StackTraceLocation)location);
        }
        throw new IllegalArgumentException("Unknown location type: " + location.getClass() + ", location: '" + location + "'");
    }

    private static @NonNull org.gradle.operations.problems.FileLocation convertToDevelocityFileLocation(ProblemLocation location) {
        if (location instanceof LineInFileLocation) {
            return new DevelocityLineInFileLocation((LineInFileLocation)location);
        }
        if (location instanceof OffsetInFileLocation) {
            return new DevelocityOffsetInFileLocation((OffsetInFileLocation)location);
        }
        return new DevelocityFileLocation((FileLocation)location);
    }

    public @Nullable Throwable getFailure() {
        return this.problem.getException() == null ? null : this.problem.getException();
    }

    private static class DevelocityProblemDefinition
    implements org.gradle.operations.problems.ProblemDefinition {
        private final ProblemDefinition definition;

        public DevelocityProblemDefinition(ProblemDefinition definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.definition.getId().getName();
        }

        public String getDisplayName() {
            return this.definition.getId().getDisplayName();
        }

        public org.gradle.operations.problems.ProblemGroup getGroup() {
            return new DevelocityProblemGroup(this.definition.getId().getGroup());
        }

        public @Nullable DocumentationLink getDocumentationLink() {
            InternalDocLink documentationLink = (InternalDocLink)this.definition.getDocumentationLink();
            return documentationLink == null ? null : new DevelocityDocumentationLink(documentationLink);
        }

        private static class DevelocityProblemGroup
        implements org.gradle.operations.problems.ProblemGroup {
            private final ProblemGroup currentGroup;

            public DevelocityProblemGroup(ProblemGroup currentGroup) {
                this.currentGroup = currentGroup;
            }

            public String getName() {
                return this.currentGroup.getName();
            }

            public String getDisplayName() {
                return this.currentGroup.getDisplayName();
            }

            public @Nullable org.gradle.operations.problems.ProblemGroup getParent() {
                ProblemGroup parent = this.currentGroup.getParent();
                return parent == null ? null : new DevelocityProblemGroup(parent);
            }
        }

        private static class DevelocityDocumentationLink
        implements DocumentationLink {
            private final InternalDocLink documentationLink;

            public DevelocityDocumentationLink(InternalDocLink documentationLink) {
                this.documentationLink = documentationLink;
            }

            public String getUrl() {
                return this.documentationLink.getUrl();
            }
        }
    }

    private static class DevelocityPluginIdLocation
    implements org.gradle.operations.problems.PluginIdLocation {
        private final PluginIdLocation pluginId;

        public DevelocityPluginIdLocation(PluginIdLocation pluginId) {
            this.pluginId = pluginId;
        }

        public String getPluginId() {
            return this.pluginId.getPluginId();
        }

        public String getDisplayName() {
            return "plugin '" + this.pluginId.getPluginId() + "'";
        }
    }

    private static class DevelocityStackTraceLocation
    implements org.gradle.operations.problems.StackTraceLocation {
        private final StackTraceLocation stackTraceLocation;

        public DevelocityStackTraceLocation(StackTraceLocation stackTraceLocation) {
            this.stackTraceLocation = stackTraceLocation;
        }

        public @Nullable org.gradle.operations.problems.FileLocation getFileLocation() {
            return this.stackTraceLocation.getFileLocation() == null ? null : DefaultProblemProgressDetails.convertToDevelocityFileLocation(this.stackTraceLocation.getFileLocation());
        }

        public List<StackTraceElement> getStackTrace() {
            return this.stackTraceLocation.getStackTrace();
        }

        public String getDisplayName() {
            return "stack trace location " + this.stackTraceLocation.getFileLocation();
        }
    }

    private static class DevelocityLineInFileLocation
    extends DevelocityFileLocation
    implements org.gradle.operations.problems.LineInFileLocation {
        private final LineInFileLocation lineInFileLocation;

        public DevelocityLineInFileLocation(LineInFileLocation lineInFileLocation) {
            super(lineInFileLocation);
            this.lineInFileLocation = lineInFileLocation;
        }

        public int getLine() {
            return this.lineInFileLocation.getLine();
        }

        public @Nullable Integer getColumn() {
            return this.lineInFileLocation.getColumn() <= 0 ? null : Integer.valueOf(this.lineInFileLocation.getColumn());
        }

        public @Nullable Integer getLength() {
            return this.lineInFileLocation.getLength() <= 0 ? null : Integer.valueOf(this.lineInFileLocation.getLength());
        }

        @Override
        public String getDisplayName() {
            String location = this.getPath() + ":" + this.getLine();
            if (this.getColumn() != null) {
                location = location + ":" + this.getColumn();
            }
            if (this.getLength() != null) {
                location = location + ":" + this.getLength();
            }
            return "file '" + location + "'";
        }
    }

    private static class DevelocityOffsetInFileLocation
    extends DevelocityFileLocation
    implements org.gradle.operations.problems.OffsetInFileLocation {
        private final OffsetInFileLocation offsetInFileLocation;

        public DevelocityOffsetInFileLocation(OffsetInFileLocation offsetInFileLocation) {
            super(offsetInFileLocation);
            this.offsetInFileLocation = offsetInFileLocation;
        }

        public int getOffset() {
            return this.offsetInFileLocation.getOffset();
        }

        public int getLength() {
            return this.offsetInFileLocation.getLength();
        }

        @Override
        public String getDisplayName() {
            return "offset in file '" + this.getPath() + ":" + this.getOffset() + ":" + this.getLength() + "'";
        }
    }

    private static class DevelocityFileLocation
    implements org.gradle.operations.problems.FileLocation {
        private final FileLocation location;

        public DevelocityFileLocation(FileLocation location) {
            this.location = location;
        }

        public String getPath() {
            return this.location.getPath();
        }

        public String getDisplayName() {
            return "file '" + this.getPath() + "'";
        }
    }
}

