/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedDevelocityPlugin;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;
import org.jspecify.annotations.Nullable;

public class AlreadyOnClasspathPluginResolver
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;
    private final ClassLoaderScope parentLoaderScope;
    private final PluginInspector pluginInspector;
    private final PluginVersionTracker pluginVersionTracker;

    public AlreadyOnClasspathPluginResolver(PluginResolver delegate, PluginRegistry corePluginRegistry, ClassLoaderScope parentLoaderScope, PluginDescriptorLocator pluginDescriptorLocator, PluginInspector pluginInspector, PluginVersionTracker pluginVersionTracker) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
        this.parentLoaderScope = parentLoaderScope;
        this.pluginInspector = pluginInspector;
        this.pluginVersionTracker = pluginVersionTracker;
    }

    @Override
    public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
        PluginId pluginId = pluginRequest.getId();
        if (this.isCorePlugin(pluginId) || !this.isPresentOnClasspath(pluginId)) {
            return this.delegate.resolve(pluginRequest);
        }
        String version = AlreadyOnClasspathPluginResolver.getVersion(pluginRequest);
        if (version == null) {
            return this.resolveAlreadyOnClasspath(pluginId, null);
        }
        if (pluginRequest.getId().equals(AutoAppliedDevelocityPlugin.BUILD_SCAN_PLUGIN_ID) && this.isPresentOnClasspath(AutoAppliedDevelocityPlugin.ID)) {
            throw new InvalidPluginRequestException(pluginRequest, "The build scan plugin is not compatible with this version of Gradle.\nPlease see https://gradle.com/help/gradle-6-build-scan-plugin for more information.");
        }
        String existingVersion = this.pluginVersionTracker.findPluginVersionAt(this.parentLoaderScope, pluginId.getId());
        if (existingVersion == null) {
            throw new InvalidPluginRequestException(pluginRequest, "The request for this plugin could not be satisfied because the plugin is already on the classpath with an unknown version, so compatibility cannot be checked.");
        }
        if (!existingVersion.equals(version)) {
            throw new InvalidPluginRequestException(pluginRequest, "The request for this plugin could not be satisfied because the plugin is already on the classpath with a different version (" + existingVersion + ").");
        }
        return this.resolveAlreadyOnClasspath(pluginId, existingVersion);
    }

    private static @Nullable String getVersion(PluginRequestInternal pluginRequest) {
        if (pluginRequest.getOriginalRequest() != null) {
            return pluginRequest.getOriginalRequest().getVersion();
        }
        return pluginRequest.getVersion();
    }

    private PluginResolutionResult resolveAlreadyOnClasspath(PluginId pluginId, @Nullable String pluginVersion) {
        DefaultPluginRegistry pluginRegistry = new DefaultPluginRegistry(this.pluginInspector, this.parentLoaderScope);
        PluginImplementation plugin = pluginRegistry.lookup(pluginId);
        if (plugin != null) {
            ClassPathPluginResolution pluginResolution = new ClassPathPluginResolution(pluginId, pluginVersion, plugin);
            return PluginResolutionResult.found(pluginResolution);
        }
        return PluginResolutionResult.notFound("Classpath", "Plugin with id '" + pluginId + "' not found.");
    }

    private boolean isPresentOnClasspath(PluginId pluginId) {
        return this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString()) != null;
    }

    private boolean isCorePlugin(PluginId pluginId) {
        return this.corePluginRegistry.lookup(pluginId) != null;
    }
}

