/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.io.IoConsumer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DirectoryBuildCache
implements BuildCacheTempFileStore,
Closeable,
LocalBuildCache {
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;
    private final FileAccessTracker fileAccessTracker;
    private final String failedFileSuffix;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DirectoryBuildCache(PersistentCache persistentCache, FileAccessTracker fileAccessTracker, String failedFileSuffix) {
        this.persistentCache = persistentCache;
        this.tempFileStore = new DefaultBuildCacheTempFileStore((prefix, suffix) -> {
            try {
                return Files.createTempFile(persistentCache.getBaseDir().toPath(), prefix, suffix, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.fileAccessTracker = fileAccessTracker;
        this.failedFileSuffix = failedFileSuffix;
    }

    @Override
    public boolean load(HashCode key, IoConsumer<InputStream> reader) {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.loadLocally(key, file -> {
            try {
                Closer closer = Closer.create();
                FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream((File)file));
                try {
                    reader.accept((Object)stream);
                    loaded.set(true);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        return loaded.get();
    }

    @Override
    public void loadLocally(HashCode key, Consumer<? super File> reader) {
        this.persistentCache.withFileLock(() -> {
            this.lock.readLock().lock();
            try {
                this.loadInsideLock(key, reader);
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    private void loadInsideLock(HashCode key, Consumer<? super File> reader) {
        File file = this.getCacheEntryFile(key);
        if (!file.exists()) {
            return;
        }
        this.fileAccessTracker.markAccessed(file);
        try {
            reader.accept(file);
        }
        catch (Exception e) {
            File failedFile = new File(file.getAbsolutePath() + this.failedFileSuffix);
            FileUtils.deleteQuietly((File)failedFile);
            file.renameTo(failedFile);
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void store(HashCode key, IoConsumer<OutputStream> result) {
        this.tempFileStore.withTempFile(key, file -> {
            try (Closer closer = Closer.create();){
                result.accept((Object)((OutputStream)closer.register((Closeable)new FileOutputStream((File)file))));
            }
            catch (IOException ex) {
                throw UncheckedException.throwAsUncheckedException((Throwable)ex);
            }
            this.storeLocally(key, (File)file);
        });
    }

    @Override
    public void storeLocally(HashCode key, File file) {
        this.persistentCache.withFileLock(() -> {
            this.lock.writeLock().lock();
            try {
                this.storeInsideLock(key, file);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private void storeInsideLock(HashCode key, File sourceFile) {
        File targetFile = this.getCacheEntryFile(key);
        try {
            Files.move(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Couldn't move cache entry '%s' into local cache: %s", key, e), e);
        }
        this.fileAccessTracker.markAccessed(targetFile);
    }

    public void withTempFile(HashCode key, Consumer<? super File> action) {
        this.persistentCache.withFileLock(() -> this.tempFileStore.withTempFile(key, action));
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }

    private File getCacheEntryFile(HashCode key) {
        return new File(this.persistentCache.getBaseDir(), key.toString());
    }
}

