/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.internal.RelativePathUtil;
import org.jspecify.annotations.Nullable;

public abstract class JacocoTaskExtension {
    private final JacocoAgentJar agent;
    private final JavaForkOptions task;
    private boolean enabled = true;
    private final RegularFileProperty destinationFile;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private List<String> excludeClassLoaders = new ArrayList<String>();
    private boolean includeNoLocationClasses;
    private String sessionId;
    private boolean dumpOnExit = true;
    private Output output = Output.FILE;
    private String address;
    private int port;
    private File classDumpDir;
    private boolean jmx;

    @Inject
    public JacocoTaskExtension(ObjectFactory objects, JacocoAgentJar agent, JavaForkOptions task) {
        this.agent = agent;
        this.task = task;
        this.destinationFile = objects.fileProperty();
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Optional
    @OutputFile
    @ToBeReplacedByLazyProperty
    public @Nullable File getDestinationFile() {
        return (File)this.destinationFile.getAsFile().getOrNull();
    }

    public void setDestinationFile(Provider<File> destinationFile) {
        this.destinationFile.fileProvider(destinationFile);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile.set(destinationFile);
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(@Nullable List<String> includes) {
        this.includes = includes;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(@Nullable List<String> excludes) {
        this.excludes = excludes;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable List<String> getExcludeClassLoaders() {
        return this.excludeClassLoaders;
    }

    public void setExcludeClassLoaders(@Nullable List<String> excludeClassLoaders) {
        this.excludeClassLoaders = excludeClassLoaders;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isIncludeNoLocationClasses() {
        return this.includeNoLocationClasses;
    }

    public void setIncludeNoLocationClasses(boolean includeNoLocationClasses) {
        this.includeNoLocationClasses = includeNoLocationClasses;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isDumpOnExit() {
        return this.dumpOnExit;
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.dumpOnExit = dumpOnExit;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Optional
    @LocalState
    @ToBeReplacedByLazyProperty
    public @Nullable File getClassDumpDir() {
        return this.classDumpDir;
    }

    public void setClassDumpDir(@Nullable File classDumpDir) {
        this.classDumpDir = classDumpDir;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isJmx() {
        return this.jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getAgentClasspath() {
        return this.agent.getAgentConf();
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getAsJvmArg() {
        StringBuilder builder = new StringBuilder();
        ArgumentAppender argument = new ArgumentAppender(builder, this.task.getWorkingDir());
        builder.append("-javaagent:");
        builder.append(this.agent.getJar().getAbsolutePath());
        builder.append('=');
        argument.append("destfile", this.getDestinationFile());
        argument.append("append", true);
        argument.append("includes", this.getIncludes());
        argument.append("excludes", this.getExcludes());
        argument.append("exclclassloader", this.getExcludeClassLoaders());
        if (this.agent.supportsInclNoLocationClasses()) {
            argument.append("inclnolocationclasses", this.isIncludeNoLocationClasses());
        }
        argument.append("sessionid", this.getSessionId());
        argument.append("dumponexit", this.isDumpOnExit());
        argument.append("output", this.getOutput().getAsArg());
        argument.append("address", this.getAddress());
        argument.append("port", this.getPort());
        argument.append("classdumpdir", this.getClassDumpDir());
        if (this.agent.supportsJmx()) {
            argument.append("jmx", this.isJmx());
        }
        return builder.toString();
    }

    public static enum Output {
        FILE,
        TCP_SERVER,
        TCP_CLIENT,
        NONE;


        public String getAsArg() {
            return this.toString().toLowerCase(Locale.US).replaceAll("_", "");
        }
    }

    private static class ArgumentAppender {
        private final StringBuilder builder;
        private final File workingDirectory;
        private boolean anyArgs;

        public ArgumentAppender(StringBuilder builder, File workingDirectory) {
            this.builder = builder;
            this.workingDirectory = workingDirectory;
        }

        public void append(String name, @Nullable Object value) {
            if (!(value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof String && StringUtils.isEmpty((String)((String)value)) || value instanceof Integer && (Integer)value == 0)) {
                if (this.anyArgs) {
                    this.builder.append(',');
                }
                this.builder.append(name).append('=');
                if (value instanceof Collection) {
                    this.builder.append(Joiner.on((char)':').join((Iterable)((Collection)value)));
                } else if (value instanceof File) {
                    this.builder.append(RelativePathUtil.relativePath((File)this.workingDirectory, (File)((File)value)));
                } else {
                    this.builder.append(value);
                }
                this.anyArgs = true;
            }
        }
    }
}

