/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.jspecify.annotations.Nullable;

public class SyncCopyActionDecorator
implements CopyAction {
    private final File baseDestDir;
    private final CopyAction delegate;
    private final PatternFilterable preserveSpec;
    private final Deleter deleter;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public SyncCopyActionDecorator(File baseDestDir, CopyAction delegate, Deleter deleter, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this(baseDestDir, delegate, null, deleter, directoryFileTreeFactory);
    }

    public SyncCopyActionDecorator(File baseDestDir, CopyAction delegate, @Nullable PatternFilterable preserveSpec, Deleter deleter, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.baseDestDir = baseDestDir;
        this.delegate = delegate;
        this.preserveSpec = preserveSpec;
        this.deleter = deleter;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashSet visited = new HashSet();
        WorkResult didWork = this.delegate.execute(action -> stream.process(details -> {
            visited.add(details.getRelativePath());
            action.processFile(details);
        }));
        SyncCopyActionDecoratorFileVisitor fileVisitor = new SyncCopyActionDecoratorFileVisitor(visited, this.preserveSpec, this.deleter);
        DirectoryFileTree walker = this.directoryFileTreeFactory.create(this.baseDestDir).postfix();
        walker.visit((FileVisitor)fileVisitor);
        visited.clear();
        return WorkResults.didWork((didWork.getDidWork() || fileVisitor.didWork ? 1 : 0) != 0);
    }

    private static class SyncCopyActionDecoratorFileVisitor
    implements FileVisitor {
        private final Set<RelativePath> visited;
        private final Spec<FileTreeElement> preserveSpec;
        private final PatternSet preserveSet;
        private final Deleter deleter;
        private boolean didWork;

        private SyncCopyActionDecoratorFileVisitor(Set<RelativePath> visited, @Nullable PatternFilterable preserveSpec, Deleter deleter) {
            this.visited = visited;
            this.deleter = deleter;
            PatternSet preserveSet = new PatternSet();
            if (preserveSpec != null) {
                preserveSet.include((Iterable)preserveSpec.getIncludes());
                preserveSet.exclude((Iterable)preserveSpec.getExcludes());
            }
            this.preserveSet = preserveSet;
            this.preserveSpec = preserveSet.getAsSpec();
        }

        public void visitDir(FileVisitDetails dirDetails) {
            this.maybeDelete(dirDetails);
        }

        public void visitFile(FileVisitDetails fileDetails) {
            this.maybeDelete(fileDetails);
        }

        private void maybeDelete(FileVisitDetails fileDetails) {
            RelativePath path = fileDetails.getRelativePath();
            if (!(this.visited.contains(path) || !this.preserveSet.isEmpty() && this.preserveSpec.isSatisfiedBy((Object)fileDetails))) {
                try {
                    this.didWork = this.deleter.deleteRecursively(fileDetails.getFile());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }
}

