/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import com.google.common.annotations.VisibleForTesting;
import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.util.internal.ClosureBackedAction;
import org.jspecify.annotations.Nullable;

@NonExtensible
public class CopySpecWrapper
implements SyncSpec {
    @VisibleForTesting
    final SyncSpec delegate;

    @Inject
    public CopySpecWrapper(SyncSpec delegate) {
        this.delegate = delegate;
    }

    public boolean isCaseSensitive() {
        return this.delegate.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.delegate.setCaseSensitive(caseSensitive);
    }

    public boolean getIncludeEmptyDirs() {
        return this.delegate.getIncludeEmptyDirs();
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.delegate.setIncludeEmptyDirs(includeEmptyDirs);
    }

    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.delegate.getDuplicatesStrategy();
    }

    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.delegate.setDuplicatesStrategy(strategy);
    }

    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.delegate.filesMatching(pattern, action);
        return this;
    }

    public CopySpec filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.delegate.filesMatching(patterns, action);
        return this;
    }

    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.delegate.filesNotMatching(pattern, action);
        return this;
    }

    public CopySpec filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.delegate.filesNotMatching(patterns, action);
        return this;
    }

    public CopySpec with(CopySpec ... sourceSpecs) {
        this.delegate.with(sourceSpecs);
        return this;
    }

    public CopySpec from(Object ... sourcePaths) {
        this.delegate.from(sourcePaths);
        return this;
    }

    public CopySpec from(Object sourcePath, Closure c) {
        return this.delegate.from(sourcePath, (Action)new ClosureBackedAction(c));
    }

    public CopySpec from(Object sourcePath, Action<? super CopySpec> configureAction) {
        return this.delegate.from(sourcePath, configureAction);
    }

    public CopySpec setIncludes(Iterable<String> includes) {
        this.delegate.setIncludes(includes);
        return this;
    }

    public CopySpec setExcludes(Iterable<String> excludes) {
        this.delegate.setExcludes(excludes);
        return this;
    }

    public CopySpec include(String ... includes) {
        this.delegate.include(includes);
        return this;
    }

    public CopySpec include(Iterable<String> includes) {
        this.delegate.include(includes);
        return this;
    }

    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.delegate.include(includeSpec);
        return this;
    }

    public CopySpec include(Closure includeSpec) {
        this.delegate.include(includeSpec);
        return this;
    }

    public CopySpec exclude(String ... excludes) {
        this.delegate.exclude(excludes);
        return this;
    }

    public CopySpec exclude(Iterable<String> excludes) {
        this.delegate.exclude(excludes);
        return this;
    }

    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.delegate.exclude(excludeSpec);
        return this;
    }

    public CopySpec exclude(Closure excludeSpec) {
        this.delegate.exclude(excludeSpec);
        return this;
    }

    public CopySpec into(Object destPath) {
        this.delegate.into(destPath);
        return this;
    }

    public CopySpec into(Object destPath, Closure configureClosure) {
        return this.delegate.into(destPath, configureClosure);
    }

    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        return this.delegate.into(destPath, copySpec);
    }

    public CopySpec rename(Closure closure) {
        this.delegate.rename((Transformer)new ClosureBackedTransformer(closure));
        return this;
    }

    public CopySpec rename(Transformer<String, String> renamer) {
        this.delegate.rename(renamer);
        return this;
    }

    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.delegate.rename(sourceRegEx, replaceWith);
        return this;
    }

    public CopyProcessingSpec rename(Pattern sourceRegEx, String replaceWith) {
        this.delegate.rename(sourceRegEx, replaceWith);
        return this;
    }

    public CopySpec filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.delegate.filter(properties, filterType);
        return this;
    }

    public CopySpec filter(Class<? extends FilterReader> filterType) {
        this.delegate.filter(filterType);
        return this;
    }

    public CopySpec filter(Closure closure) {
        this.delegate.filter(closure);
        return this;
    }

    public CopySpec filter(Transformer<String, String> transformer) {
        this.delegate.filter(transformer);
        return this;
    }

    public CopySpec expand(Map<String, ?> properties) {
        this.delegate.expand(properties);
        return this;
    }

    public CopySpec expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
        this.delegate.expand(properties, action);
        return this;
    }

    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.delegate.eachFile(action);
        return this;
    }

    public CopySpec eachFile(Closure closure) {
        this.delegate.eachFile(closure);
        return this;
    }

    @Deprecated
    public Integer getFileMode() {
        return this.delegate.getFileMode();
    }

    @Deprecated
    public CopyProcessingSpec setFileMode(@Nullable Integer mode) {
        this.delegate.setFileMode(mode);
        return this;
    }

    public Property<ConfigurableFilePermissions> getFilePermissions() {
        return this.delegate.getFilePermissions();
    }

    public CopyProcessingSpec filePermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.delegate.filePermissions(configureAction);
    }

    @Deprecated
    public Integer getDirMode() {
        return this.delegate.getDirMode();
    }

    @Deprecated
    public CopyProcessingSpec setDirMode(@Nullable Integer mode) {
        this.delegate.setDirMode(mode);
        return this;
    }

    public Property<ConfigurableFilePermissions> getDirPermissions() {
        return this.delegate.getDirPermissions();
    }

    public CopyProcessingSpec dirPermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.delegate.dirPermissions(configureAction);
    }

    public Set<String> getIncludes() {
        return this.delegate.getIncludes();
    }

    public Set<String> getExcludes() {
        return this.delegate.getExcludes();
    }

    public String getFilteringCharset() {
        return this.delegate.getFilteringCharset();
    }

    public void setFilteringCharset(String charset) {
        this.delegate.setFilteringCharset(charset);
    }

    public PatternFilterable getPreserve() {
        return this.delegate.getPreserve();
    }

    public SyncSpec preserve(Action<? super PatternFilterable> action) {
        return this.delegate.preserve(action);
    }
}

